class 'stockAppliance' (Appliance)

stockAppliance.products = {}
stockAppliance.productFillLimit = -1
stockAppliance.productFillAnim = "WORK_FRONT"
stockAppliance.productFillTime = 400
stockAppliance.productFillSound = ""
stockAppliance.productFillMethod = "all" -- can be {"all", "random", "firstserve" }
stockAppliance.randomN = nil
stockAppliance.timer = 0
stockAppliance.fill = 0

function stockAppliance:__init() super()
end

function stockAppliance:onCreate()
	Appliance.onCreate(self)
	self:createHighlight()
end

function stockAppliance:onClick()
    Appliance.onClick(self)
    self:playSound("SOUND_OBJECT_CLICK")
end

function stockAppliance:onWorkStart(task)

	local startWorking = false
	for index, product in pairs(self.products) do
        if (getProduct(product) and getProduct(product):getStock() < getProduct(product):getMaxStock()) then
			startWorking = true
        end
	end

    -- Only work if the bag isn't full yet
    if (startWorking == true) then  
	    task:setDuration(-1)
	    task:getPerson():animate(self.productFillAnim, -1, false, -1)
	    self.timer = self.productFillTime
	    self:playSound(self.productFillSound, true)
	    self:clearOverhead()
	    self.fill = self.productFillLimit
	    return Appliance.onWorkStart(self, task)	    
    end
    
    return false

end

function stockAppliance:onWorkUpdate(task, time)

    local done = false

    if (self.timer > 0) then
        self.timer = self.timer - time
        if (self.timer <= 0) then
			done = true
			self.fill = self.fill - 1
			
			if (self.productFillMethod == "all") then
				for index, product in pairs(self.products) do
					if (getProduct(product)) then
						getProduct(product):incStock()
						if (getProduct(product):getStock() < getProduct(product):getMaxStock()) then
							done = false
						end
					end
				end			
			elseif (self.productFillMethod == "random") then
				-- increase one
				-- first get a random index
				local n
				if (self.randomN) then
					n = self.randomN
				else
					n = math.random(#(self.products))
				end
				assert(n >= 1)
				assert(n <= #(self.products))
				-- increase it
				local product = self.products[n]
				if (getProduct(product)) then
					getProduct(product):incStock()
				end	
				-- check if done
				for index, product in pairs(self.products) do
					if (getProduct(product)) then
						if (getProduct(product):getStock() < getProduct(product):getMaxStock()) then
							done = false
						end
					end
				end						
			elseif (self.productFillMethod == "firstserve") then
				for index, product in pairs(self.products) do
					if (getProduct(product)) then
						if (getProduct(product):getStock() < getProduct(product):getMaxStock()) then
							getProduct(product):incStock()
							if (getProduct(product):getStock() < getProduct(product):getMaxStock()) then
								done = false
							end
							break
						end
					end
				end			
			else
				cout("stockAppliance - invalid productFillMethod!")
			end
			
			if (self.fill == 0) then
				done = true
			end
			
			if (done == false) then
                self.timer = self.productFillTime         
            end     
        end    
    end
    
    return (done) or (task:getPerson():hasTasksToDo())

end

function stockAppliance:onWorkComplete(task)

	self:stopSound(self.productFillSound)

end
