-- a hidden object
class 'pearappliance' (Appliance)

-- internal variables
pearappliance.toSturDuration = 80000
pearappliance.toDirtyDuration = 8000
pearappliance.sturDuration = 2000
pearappliance.cleanDuration = 8000

pearappliance.timer = 0
pearappliance.state = "READY"
pearappliance.working = false
pearappliance.blinking = false
pearappliance.dirtyTimer = pearappliance.toSturDuration
pearappliance.productName = "POACHED_PEAR"
pearappliance.stirAnim = "PROD_ANIM_PEARS_ROTATE"
pearappliance.stirSound = "SOUND_STIRSOUND_LOOP"
pearappliance.spillAnim = "PROD_ANIM_PEARS_SPILL"
pearappliance.spillSound = "SOUND_SOUP_BOILS_OVER"
pearappliance.alertSound = "SOUND_STIRSOUP_ALERT"
pearappliance.cleanSound = "SOUND_CLEAN_PUFF_MESS"
pearappliance.overheadAnimation = "INGAME_SOUP_STIR"
pearappliance.workAnim = "WORK_FRONT"
pearappliance.hintID = "HINT_STIR_PEARS"

function pearappliance:__init() super()
end

function pearappliance:onClick()

    self:playSound("SOUND_OBJECT_CLICK")
	
	if (self:isSelected() == false) then	
		Appliance.onClick(self)
		self:setSelected(true)	
		self.working = true
		self:clearOverhead()	
	end
	
end

function pearappliance:onWorkStart(task)

	self:setSelected(false)

	if (Appliance.onWorkStart(self, task)) then
		if (self.state == "CLEAN") then
			self:removeHighlight()
			emily:animate(self.workAnim, -1, 10)
			self.timer = self.sturDuration
            self:animate(self.stirAnim, -1)
            self:playSound(self.stirSound, true)
	        return true
	       
		elseif (self.state == "DIRTY") then
			
			self:removeHighlight()
			self:playSound(self.cleanSound, true)
			emily:animate(self.workAnim, -1, 9)
			self.timer = self.cleanDuration
	        return true
		end
		
	end
	
	return false

end

function pearappliance:onTick(time)

	if (scene:isStartingMovie() or scene:isPlayingMovie() or self.working == true or self:isSelected()) then
		return
	end
	
	if (self.state == "READY") then
		self.dirtyTimer = self.dirtyTimer - time
		if (self.dirtyTimer <= 3000 and self.blinking == false) then			
		
			self.blinking = true
			getProduct(self.productName):blink(25)
		elseif (self.dirtyTimer <= 0) then

			local poachedPear = getProduct(self.productName)
			self:createHighlight()
			self.dirtyTimer = self.toDirtyDuration
			self.state = "CLEAN"
			self.blinking = false
			poachedPear:setVisible(false)
			poachedPear:removeModifiers()
			poachedPear:setAlpha(1.0)
			poachedPear:setClickable(false)		
			self:createOverhead(self.overheadAnimation, "ingame")
			self:playSound(self.alertSound)			
			if (self.hintID ~= "") then
				hm:openHint(getHintIndex(self.hintID), poachedPear:getScreenX(), poachedPear:getScreenY())		
			end
		end

	elseif (self.state == "CLEAN") then

		self.dirtyTimer = self.dirtyTimer - time
		
		if (self.dirtyTimer <= 3000 and self.blinking == false and self:getOverhead()) then
			self.blinking = true
			self:getOverhead():blink(25)
		elseif (self.dirtyTimer <= 0 and self.blinking == true and self:getOverhead()) then			
			self:animate(self.spillAnim, 1, false, 12, true)			
			self:playSound(self.spillSound)
			self:getOverhead():removeModifiers()
			self:getOverhead():setAlpha(1.0)
			self.blinking = false
			self:clearOverhead()
			self.dirtyTimer = 1000			
		elseif (self.dirtyTimer <= 0) then
			self.blinking = false
			self.state = "DIRTY"
		end

	end
	
end

function pearappliance:onWorkUpdate(task, time)

	Appliance.onWorkUpdate(self, task, time)
	self.timer = self.timer - time
	if (self.timer <= 0) then	
		return true
	end
	return false
end

function pearappliance:onWorkComplete(task)

	if (self.state == "CLEAN") then
		self:stopSound(self.stirSound)
	elseif (self.state == "DIRTY") then
		self:stopSound(self.cleanSound)
	end

	self.state = "READY"		
    self:animate(self.spillAnim, 0)
	self:setCurrentFrame(0)
	self.dirtyTimer = self.toSturDuration	
	getProduct(self.productName):setVisible(true)
	getProduct(self.productName):setClickable(true)
	self.working = false
	
	Appliance.onWorkComplete(self, task)
end
