-- a hidden object
class 'packageappliance' (Appliance)

-- internal variables
packageappliance.minappearDuration = 60000
packageappliance.maxappearDuration = 120000

packageappliance.numPackages = 1
packageappliance.active = false
packageappliance.timer = 0
packageappliance.pickupDuration = 1500
packageappliance.appearDuration = getRandomRange(packageappliance.minappearDuration, packageappliance.maxappearDuration)

function packageappliance:__init() super()
end

function packageappliance:onClick()

    self:playSound("SOUND_OBJECT_CLICK")
	
	if (self:isSelected() == false) then
	
		Appliance.onClick(self)
		self:setSelected(true)	
	end
	
end

function packageappliance:onTick(time)
	if (scene:isStartingMovie() or scene:isPlayingMovie()) then
		return
	end

	if (getAppliance("rest0_newsstand") == nil or self.numPackages == 0) then
		return
	end
	
	if (self:isVisible() == false and self.active == false) then
		self.appearDuration = self.appearDuration - time
		if (self.appearDuration <= 0) then			
			self.numPackages = self.numPackages - 1
			self.active = true
			local bully = pm:createPerson("npc")
			bully:setBaseName("INGAME_PERSON_BULLY")
			bully:setDefaultSection("characters")
			bully:setPosition(grid:getNode(49, 1))
			bully:qWalkToXY(self:getWorkNode():getGridX(), self:getWorkNode():getGridY() - 3)
			bully:qPlaySound("SOUND_DROP_PAPERS")
			bully:qAnimateWait("PUTDOWN_PAPER", 1)
			bully:qCallback(self, function(self)
				self:createHighlight()
				self:setVisible(true)
				self:checkHint()
			end)
			bully:qAnimate("IDLE", 0)
			bully:qWalkToXY(49, 1)
			bully:qDestroy()
			self.appearDuration = 9999999	
		end
	end	
end

function packageappliance:onWorkStart(task)

	self:setSelected(false)
	self:removeHighlight()

	if (Appliance.onWorkStart(self, task)) then
		emily:animate("WORK_BACK", -1, 10)
		self.timer = self.pickupDuration
		self:playSound("SOUND_GRAB_NEWSPAPER")
        return true  
	end
	
	return false
end

function packageappliance:onWorkUpdate(task, time)
	self.timer = self.timer - time
	if (self.timer <= 0) then
	
		return true
	end
	return false
end

function packageappliance:onWorkComplete(task)

	local greyPaper = getProduct("NEWSPAPER_GREY")
	getProduct("NEWSPAPER_PINK"):incStock(1)
	greyPaper:incStock(4)
	
	hm:openHint(getHintIndex("HINT_NEWSPAPERS_REFILLED"), greyPaper:getScreenX() + (greyPaper:getWidth() / 2), greyPaper:getScreenY() + greyPaper:getHeight())

	self:setVisible(false)
	self.active = false
	self.appearDuration = getRandomRange(self.minappearDuration, self.maxappearDuration)

	Appliance.onWorkComplete(self, task)
end

function packageappliance:checkHint()
	hm:placeArrow(getArrowIndex("ARROW_HINT_NEWSPAPERS_DROPED"), self, 0, 10)
end
