class 'fishholeAppliance' (stockAppliance)

fishholeAppliance.choices =
{
	"FISHRED",
	"FISHBLUE",
}
fishholeAppliance.delay = nil
fishholeAppliance.soundFish = "SOUND_FISHING"

function fishholeAppliance:__init() super()
end

function fishholeAppliance:onWorkStart(task)

	-- reset random choice
	self.randomN = nil

	if (stockAppliance.onWorkStart(self, task)) then
		-- choose

		local list =  {}
		for index, product in pairs(self.products) do
			if (getProduct(product) and getProduct(product):getStock() < getProduct(product):getMaxStock()) then
				List.push_back(list, index)
			end
		end
			
		self.randomN = list[math.random(#(list))]		
		
		-- set animation
		-- don't play yet
		task:getPerson():animate(self.choices[self.randomN], 0)		
		-- set sound		
		if (self.soundFish ~= "") then
			task:getPerson():playSound(self.soundFish)
		end		
		-- calculate animation delay
		local fc = task:getPerson():getFrameCount()
		local ft = 1000 / task:getPerson():getDefaultFrameRate()
		self.delay = self.productFillTime - fc * ft
		return true
	end
	
	return false

end

function fishholeAppliance:onWorkUpdate(task, time)

	if (self.delay > 0) then
		self.delay = self.delay - time
		if (self.delay <= 0) then
			task:getPerson():animate(self.choices[self.randomN], 1)	
		end	
	end

	return stockAppliance.onWorkUpdate(self, task, time)

end

function fishholeAppliance:onWorkComplete(task)

	stockAppliance.onWorkComplete(self, task)

end