class 'fireplaceAppliance' (Appliance)

-- internal variables
fireplaceAppliance.toAddWoodDuration = 60000
fireplaceAppliance.toStartFireDuration = 8000
fireplaceAppliance.addWoodDuration = 2000
fireplaceAppliance.startFireDuration = 4000

fireplaceAppliance.timer = 0
fireplaceAppliance.working = false
fireplaceAppliance.isLocked = false

fireplaceAppliance.fire = nil
fireplaceAppliance.fireBaseX = -52
fireplaceAppliance.fireBaseY = -123
fireplaceAppliance.frameSpeed = 8

fireplaceAppliance.timeToStartFromDead = 2000
fireplaceAppliance.timeToStartFromSmoulder = 1000

fireplaceAppliance.timeRaging = 120000
fireplaceAppliance.timeSmouldering = 8000

fireplaceAppliance.stateTimer = 0
fireplaceAppliance.pauseStateTimer = false

function fireplaceAppliance:__init() super()
end

function fireplaceAppliance:onCreate()
	Appliance.onCreate(self)
	
	self:initFireAnim()
	
	self:setState("RAGING")
	fireplaceAppliance.working = false
	
	self:createHighlight()
end

function fireplaceAppliance:onClick()
	getProduct("WOOD"):onClick()
end


function fireplaceAppliance:isRaging()
	return self.state == "RAGING"
end

function fireplaceAppliance:isDead()
	return self.state == "OUT" or self.isLocked
end

function fireplaceAppliance:setLocked()
	self:setState("RAGING") 
	self.working = true
	self.isLocked = true
	um:setHeated(false)
end

function fireplaceAppliance:initFireAnim()
	
	if (self.fire == nil) then
		self.fire = createSprite()
		self.fire:setDefaultSection(player:getCurrentResourceSection())
		self.fire:setX(self.fireBaseX)
		self.fire:setY(self.fireBaseY)
		self:addChild(self.fire)
	end
	
	--self.fire:setAlpha(0.5)
end

function fireplaceAppliance:getWorkTime()

	if (self.state == "SMOULDERING") then
		return self.addWoodDuration
	       
	elseif (self.state == "OUT") then
		return self.startFireDuration

	end
	
	return 400
end

function fireplaceAppliance:onWorkStart(task)

	self:setSelected(false)

	self.working = true

	getObject("fireplace_front"):removeOverhead()
	
	return Appliance.onWorkStart(self, task)

end

function fireplaceAppliance:onTick(time)	
	if (scene:isStartingMovie() or scene:isPlayingMovie()) then
		return
	end
		
	if (self.working) then
		return
	end
	
	if (not self:isDead()) then
		self.stateTimer = self.stateTimer - time
		if (self.stateTimer <= 0) then
			self:gotoNextTimedState()
		end
	end
end

function fireplaceAppliance:gotoNextTimedState()

	if (self.state == "RAGING") then
		self:setState("SMOULDERING")
		
	elseif (self.state == "SMOULDERING") then
		self:setState("OUT")
			
	end

end

function fireplaceAppliance:onWorkUpdate(task, time)

	Appliance.onWorkUpdate(self, task, time)
	--cout("WORKING\n")
	self.timer = self.timer - time
	if (self.timer <= 0) then	
		cout("FINISHED WORKING\n")
		return true
	end
	return false
end

function fireplaceAppliance:onWorkComplete(task)

	--cout("WORKING COMPLETE\n")
	self:setState("RAGING")
	self.working = false
	
	Appliance.onWorkComplete(self, task)
end

function fireplaceAppliance:setState(newState)
	
	if (newState ~= self.state) then
		
		if (newState == "RAGING") then
			self.blinking = false
			self.fire:animate("ANIM_FIRE_LIT", -1, false, self.frameSpeed)
			self.stateTimer = self.timeRaging
			self:playSound("SOUND_FIREPLACE_LOOP", true)
			um:setHeated(true)
			
		elseif (newState == "SMOULDERING") then

			getObject("fireplace_front"):createOverhead("INGAME_EXCLAMATION_SIGN")
			getObject("fireplace_front"):getOverhead():setX(22)
			getObject("fireplace_front"):getOverhead():setY(-74)
			getObject("fireplace_front"):getOverhead():blink(25)

			self.blinking = true
			self.stateTimer = self.timeSmouldering
			self.fire:blink(25)
			local p = getProduct("WOOD")
			if (p) then			
				hm:openHint(getHintIndex("HINT_MORE_LOGS"), p:getScreenX(), p:getScreenY() - (p:getHeight() / 2))
			end
			
		elseif (newState == "OUT") then
			self:stopSound("SOUND_FIREPLACE_LOOP")
			self:playSound("SOUND_FIREPLACE_OUT") 
			self.blinking = false
			self.fire:animate("ANIM_FIRE_DIE", 1, false, self.frameSpeed, true)
			um:setHeated(false)
			getObject("fireplace_front"):removeOverhead()

		end
		self.state = newState
		
	end
	
end
