
class 'chestnutGrill' (Appliance)

chestnutGrill.currState = "INVALID"

chestnutGrill.slotInfo = {}
chestnutGrill.hotPlateX = { 1, 1 }
chestnutGrill.hotPlateY = { 11, 11 }

chestnutGrill.heatingUpAnim		= "ANIM_TRASHCAN_HEATING_UP"
chestnutGrill.heatedLoop		= "ANIM_TRASHCAN_HEATED"
chestnutGrill.coolingDownAnim	= "ANIM_TRASHCAN_COOLING_DOWN"

chestnutGrill.platesSetup = false

chestnutGrill.timer = 0
chestnutGrill.warmUpTime = 1000
chestnutGrill.coolDownTime = 1000

function chestnutGrill:__init() super()
end

function chestnutGrill:setupPlates()

	if (not self.platesSetup) then
		local slotCount = 0
		for index = 0, 1 do
			local slot = self:getSlot(index)
			if (slot ~= nil) then
				local infoIndex = index + 1
				slot:setName("slot" .. index)
				local fakeImage = createSprite()
				fakeImage:setDefaultSection(player:getCurrentResourceSection())
				fakeImage:animate(self.heatingUpAnim, 0)
				fakeImage:setX(self.hotPlateX[infoIndex])
				fakeImage:setY(self.hotPlateY[infoIndex])
				
				self.slotInfo[infoIndex] = {}
				self.slotInfo[infoIndex].slotName = slot:getName()
				self.slotInfo[infoIndex].currState = "INVALID"
				self.slotInfo[infoIndex].image = fakeImage
				self.slotInfo[infoIndex].timer = 0
				
				slotCount = slotCount + 1
				slot:addChild(fakeImage)
			end
		end
		if (slotCount == 2) then
			self.platesSetup = true
		end
	end
	
end

function chestnutGrill:setSlotState(slotInfo, state)
	
	-- local slotInfo = self:getSlotInfo[slot]
	if (state ~= slotInfo.currState) then
		slotInfo.currState = state
		
		if (state == "warming up") then
			slotInfo.image:animate(self.heatingUpAnim, 1, false, 10, true)
			slotInfo.timer = self.warmUpTime
			
		elseif (state == "hot") then
			slotInfo.image:animate(self.heatedLoop, -1, 10)
			
		elseif (state == "cooling down") then
			slotInfo.image:animate(self.coolingDownAnim, 1, false, 10, true)
			slotInfo.timer = self.coolDownTime
			
		elseif (state == "idle") then
			slotInfo.image:animate(self.heatingUpAnim, 0)
			
		end
		
	end
end

function chestnutGrill:onTick(time)
	for index = 1, table.getn(self.slotInfo) do
		local slotInfo = self.slotInfo[index]
		if (slotInfo.currState == "warming up") then
			slotInfo.timer = slotInfo.timer - time
			if (slotInfo.timer <= 0) then
				self:setSlotState(slotInfo, "hot")
			end
			
		elseif (slotInfo.currState == "cooling down") then
			slotInfo.timer = slotInfo.timer - time
			if (slotInfo.timer <= 0) then
				self:setSlotState(slotInfo, "idle")
			end
		end
	end
end

function chestnutGrill:startSlotBaking(slot)
	local slotInfo = self:getSlotInfo(slot)
	self:setSlotState(slotInfo, "warming up")
end

function chestnutGrill:stopSlotBaking(slot)
	local slotInfo = self:getSlotInfo(slot)
	self:setSlotState(slotInfo, "cooling down")
end

function chestnutGrill:bla()
end

function chestnutGrill:getSlotInfo(slot)

	local nrInfo = table.getn(self.slotInfo)	
	for i = 1, nrInfo do
		if (self.slotInfo[i].slotName == slot:getName()) then
			return self.slotInfo[i]
		end
	end
	return nil
end
