restaurant4 = {}
restaurant4.stars = {}
restaurant4.numStars = 100

function rotateWindmill()
	
	local windmill = scene:child("WINDMILL")
	if (windmill) then
		windmill:animate(
			-- sync the rotation duration with OUTRO_RAD_ROTATION_TIME from default.xml
			-- so the speed will be the same during the game outro
			{drotation=360, duration=3000},
			{call=rotateWindmill}
		)
	end

end

function restaurant4:initialize()
	restaurant4.stars = {}
	local background = scenes.SCENE_INTERSTITIAL:child("BACKGROUND")
	
	local starNode = background:newChildSprite({x=0, y=0})
	for i = 0, restaurant4.numStars do
		local star = starNode:newChildSprite({x=math.random(164) * 5, y=math.random(104) * 5, image="STARSMALL0", section="interstitial", anchorpoint="center"})
		star:setScale(0.3 + (math.random(10) / 17))
		restaurant4.stars[i] = star
	end
	starNode:doEvery(50, restaurant4.twinkleStar)

	background:newChildSprite({x=0, y=0, image="FOREGROUND4", section="interstitial"})	
	background:newChildSprite({name="WINDMILL", x=25, y=255, image="WINDMILL", section="interstitial", pivotpoint="center"})	
	
	rotateWindmill()
end

function restaurant4:twinkleStar()
	local star = restaurant4.stars[math.random(restaurant4.numStars)]:newChildSprite({x=0, y=0, image="STARBIG0", section="interstitial", anchorpoint="center", alpha=0})
	
	star:animate(		
		{alpha=1, duration=500 + math.random(500)},
		{alpha=0, duration=500 + math.random(500)},
		{call=function() star:setObsolete() end}			
	)
	
	return 120 + math.random(80)
end

function restaurant4:simpleAnimation()
	local background = scene:child("BACKGROUND")
	local black = scene:newChildSprite({x=0, y=0, image="BACKGROUND1", section="interstitial"})
	black:setColor({alpha=0, red=0, green=0, blue=0})
	
	moveCalender(false)
	moveButtons(false)
	moveRestSelection(false)
	
	black:animate(		
		{alpha=1, duration=1000},
		{command="updateObjects", target=background},
		{command="updateBackground", target=background},
		{alpha=0, duration=1000},
		{call=function() 
			moveCalender(true)
			moveButtons(true)
			moveRestSelection(true)
			black:setObsolete() end}
	)
end
