--=============================================================================
-- Global helper functions
--=============================================================================
function transitionAnimation()
	moveCalender(false)
	moveButtons(false)
	moveRestSelection(false)

	local background = scene:child("BACKGROUND")
	background:animate(	
		{delay=1000},
		{command="play", target=background}
	)
end

function showMapScene()
	local background = scene:child("BACKGROUND")
	local black = scene:newChildSprite({x=0, y=0, image="BACKGROUND1", section="interstitial"})
	black:setColor({alpha=0, red=0, green=0, blue=0})

	black:animate(
		{alpha=1, duration=1000},
		{command="clear", target=background},
		{command="endMovie", target=background},
		{command="updateObjects", target=background},
		{command="updateLayout", target=background},
		{command="enableInput", target=background},
		{alpha=0, duration=1000},
		{call=function() black:setObsolete() end }
	)
end

function moveCalender(onscreen)
	local calender = scene:child("CALENDER")
	if (onscreen) then
		calender:animate({x=535, duration=500})
	else
		calender:animate({x=800, duration=500})
	end
	calender:setEnabled(onscreen)
end

function moveRestSelection(onscreen)
	local restSelection = scene:child("RESTAURANT_SELECTION")
	if (onscreen) then
		restSelection:animate({y=0, duration=500})
	else
		restSelection:animate({y=-restSelection:height(), duration=500})
	end
	restSelection:setEnabled(onscreen)
end

function moveButtons(onscreen)
	local shop = scene:child("BUTTON_SHOP")
	local start = scene:child("BUTTON_START")
	local trophy = scene:child("BUTTON_TROPHY")
	local guibar = scene:child("GUIBAR")
	local h = 600 - guibar:height()

	if (onscreen) then
		shop:animate({x=shop:x(), y=580, duration=500})
		start:animate({x=start:x(), y=580, duration=500})
		trophy:animate({x=trophy:x(), y=580, duration=500})
		guibar:animate({x=guibar:x(), y=h, duration=500})		
	else
		shop:animate({x=shop:x(), y=700, duration=500})
		start:animate({x=start:x(), y=700, duration=500})
		trophy:animate({x=trophy:x(), y=700, duration=500})
		guibar:animate({x=guibar:x(), y=h + 120, duration=500})		
	end
end

function lerp(val1, val2, fact)
	return val1 + fact * (val2 - val1)
end

function jcurve(fact)
	return fact * fact
end

function rcurve(fact)
	local temp = (fact - 1.0)
	temp = temp * temp
	return 1.0 - temp
end

function scurve(fact)
	local temp = (3 - fact - fact)
	temp = temp * fact * fact
	return temp
end

--=============================================================================
-- Drive-thru scene
--=============================================================================
restaurant0 = {}
restaurant0.stars = {}

function restaurant0:initialize()
	restaurant0.stars = {}
	local background = scenes.SCENE_INTERSTITIAL:child("BACKGROUND")

	local starNode = background:newChildSprite({x=0, y=0})
	for i=0, 200 do
		local star = starNode:newChildSprite({x=math.random(164) * 5, y=math.random(104) * 5, image="STARSMALL0", section="interstitial", anchorpoint="center"})
		star:setScale(0.4 + (math.random(10) / 17))
		restaurant0.stars[i] = star
	end
	starNode:doEvery(50, restaurant0.twinkleStar)
	
	local particle = newChildParticleEffect(background, "PARTICLE_SMOKE")
	particle:setX(384)
	particle:setY(303)
	
	background:newChildSprite({x=0, y=0, image="FOREGROUND0", section="interstitial"})	
end

function restaurant0:twinkleStar()
	local star = restaurant0.stars[math.random(200)]:newChildSprite({x=0, y=0, image="STARBIG0", section="interstitial", anchorpoint="center", alpha=0})
	
	star:animate(		
		{alpha=1, duration=500 + math.random(500)},
		{alpha=0, duration=500 + math.random(500)},
		{call=function() star:setObsolete() end}			
	)
	
	return 80 + math.random(80)
end

function restaurant0:simpleAnimation()
	local background = scene:child("BACKGROUND")
	local black = scene:newChildSprite({x=0, y=0, image="BACKGROUND1", section="interstitial"})
	black:setColor({alpha=0, red=0, green=0, blue=0})
	
	moveCalender(false)
	moveButtons(false)
	moveRestSelection(false)
	
	black:animate(		
		{alpha=1, duration=1000},
		{command="updateObjects", target=background},
		{command="updateBackground", target=background},	
		{alpha=0, duration=1000},
		{call=function() 
			moveCalender(true)
			moveButtons(true)
			moveRestSelection(true)
			black:setObsolete() end}			
	)
end

