(function () {

/* Mini jQuery-like library. */
var nlp = NodeList.prototype, ep = Element.prototype;
var $ = document.querySelectorAll.bind(document);
ep.$ = ep.querySelectorAll;
ep.is = ep.webkitMatchesSelector;
ep.addClass = function (cls) { this.classList.add(cls); return this; };
ep.removeClass = function (cls) { this.classList.remove(cls); return this; };
nlp.is = function (sel) { return this[0].is(sel); };
['forEach', 'reduce', 'map'].forEach(function (method) { nlp[method] = Array.prototype[method]; });
function fe(lambda) { return function () { var args = arguments; this.forEach(function (ele) { lambda.apply(ele, args); }); return this; }; }
['addClass', 'removeClass', 'addEventListener', 'removeEventListener'].forEach(function (method) { nlp[method] = fe(ep[method]); });

/* Program logic. */
var draggingBox = null;
var container = $('#layout-block')[0];
var placeholder = $('#layout-box-placeholder')[0];
var stagingArea = $('#layout-staging-area')[0];
var LINE_HEIGHT = 31;
var bAvatarHidden = false;

$('html').addEventListener("mousedown", function (evt) {
	if (!evt.target.is('.layout-box')) return true;
	if (draggingBox) return true;
	//$("#layout-lines-warning")[0].innerHTML = "";
	draggingBox = evt.target;
	placeholder.style.webkitBoxOrdinalGroup = draggingBox.style.webkitBoxOrdinalGroup;
	placeholder.style.minWidth = getComputedStyle(draggingBox).minWidth;
	placeholder.style.webkitBoxFlex = getComputedStyle(draggingBox).webkitBoxFlex;
	draggingBox.style.left = (evt.clientX - ~~(/*draggingBox.offsetWidth*/150 / 2)) + 'px';
	draggingBox.style.top = (evt.clientY - ~~(LINE_HEIGHT / 2)) + 'px';
	draggingBox.style.width = /*draggingBox.offsetWidth*/150 + 'px';
	draggingBox.style.height = LINE_HEIGHT + 'px';
	draggingBox.addClass('layout-dragging');
	//placeholder.innerHTML = draggingBox.innerHTML;
	placeholder.style.backgroundImage = getComputedStyle(draggingBox).backgroundImage;
	placeholder.style.backgroundColor = getComputedStyle(draggingBox).backgroundColor;
	placeholder.style.backgroundPosition = getComputedStyle(draggingBox).backgroundPosition;
	placeholder.style.backgroundRepeat = getComputedStyle(draggingBox).backgroundRepeat;
	draggingBox.parentElement.appendChild(placeholder);
	container.appendChild(draggingBox);
	placeholder.removeClass('hidden');
	return false;
}).addEventListener("mousemove", function (evt) {
	if (!draggingBox) return true;
	var mouseX = Math.max(85, Math.min(620, evt.clientX));
	var mouseY = Math.max(90, Math.min(420, evt.clientY));
	draggingBox.style.left = (mouseX - ~~(draggingBox.offsetWidth / 2)) + 'px';
	draggingBox.style.top = (mouseY - ~~(draggingBox.offsetHeight / 2)) + 'px';
	
	// Step 1. Find the line we're moving to.
	var toLine;
	if (mouseY >= stagingArea.offsetTop) {
		// We're going to the staging area.
		// But if such a move leaves no other line in the actual layout area, we have to stay.
		if ($('.layout-line').length === 1 && placeholder.parentElement !== stagingArea && placeholder.is(':only-child')) {
			// We can't leave. Turns out we can't even move (we're the sole box in this line). So say goodbye!
			return false;
		}
		toLine = stagingArea;
	} else {
		var toLineNo = 0, insertBefore = false, lines = $('.layout-line');
		
		// Determine the destination line number with the following loop.
		for (var idx = 0; idx < lines.length; idx++) {
			var line = lines[idx];
			if (toLineNo < idx) break;
			// There is a special case when we drag a lonely box downwards (we need to make it
			// more inclined to jump lines).
			if (placeholder.is(':only-child') && !line.is('.layout-newline') && placeholder.parentElement === line) {
				if (mouseY > line.offsetTop + line.offsetHeight / 2) {
					toLineNo = idx + 1;
					break;
				}
			} else {
				if (mouseY < line.offsetTop + line.offsetHeight / 4) insertBefore = true;
				else if (mouseY > line.offsetTop + line.offsetHeight * 3 / 4) toLineNo = idx + 1;
			}
		};
		
		if (insertBefore || toLineNo === lines.length) {
			// We're moving to a new line.
			// But if moving to the new line causes our old line to become empty, we might as well stay.
			if (placeholder.is(':only-child') && placeholder.parentElement !== stagingArea) {
				// No need to leave. Better yet, no need to move at all! Hooray!
				return false;
			}
			// If moving to the new line results in the line number cap being breached, we have to stay.
			if (lines.length >= 5) {
				if (toLineNo === lines.length) toLineNo = 4;
			} else {
				var newLine = document.createElement('div').addClass('layout-line').addClass('layout-newline');
				if (insertBefore) $('.layout-line')[toLineNo].insertAdjacentElement('beforebegin', newLine);
				else $('#layout-lines')[0].appendChild(newLine);
			}
		}
		toLine = $('.layout-line')[toLineNo];
	}
	
	// Step 2. Move to that line.
	if (placeholder.parentElement !== toLine) {
		// We'll need to leave the current line.
		// But before we do that, we need to make sure the other boxes here agree with the decision.
		var order = parseInt(placeholder.style.webkitBoxOrdinalGroup), oldLine = placeholder.parentElement;
		/*
		if (!bAvatarHidden && oldLine.children.length === 1 && oldLine !== stagingArea && $(".layout-line").length === 2) {
			$("#layout-lines-warning")[0].innerHTML = "具有头像框的界面，不允许将所有的工具栏拖动到一行里面。";
			return;
		}
		*/
		oldLine.$('.layout-box').forEach(function (box, idx, boxes) {
			if (parseInt(box.style.webkitBoxOrdinalGroup) > order) {
				box.style.webkitBoxOrdinalGroup = parseInt(box.style.webkitBoxOrdinalGroup) - 1;
			}
		});
		// Now that everything is settled, set sail for the new line!
		toLine.appendChild(placeholder);
		if (oldLine.children.length === 0 && oldLine !== stagingArea) oldLine.parentElement.removeChild(oldLine);
		draggingBox.style.width = /*placeholder.offsetWidth*/150 + 'px';
		draggingBox.style.height = LINE_HEIGHT + 'px';
		draggingBox.style.left = (mouseX - ~~(/*placeholder.offsetWidth*/150 / 2)) + 'px';
		draggingBox.style.top = (mouseY - ~~(LINE_HEIGHT / 2)) + 'px';
		// Default to the last box in the line. We'll adjust the order soon.
		placeholder.style.webkitBoxOrdinalGroup = toLine.$('.layout-box').length;
		placeholder.style.minWidth = getComputedStyle(draggingBox).minWidth;
		placeholder.style.webkitBoxFlex = getComputedStyle(draggingBox).webkitBoxFlex;
		
	}
	
	// Step 3. Find the order of our box in this line.
	var newLineBoxes = toLine.$('.layout-box'), orderToBox = new Array(newLineBoxes.length);
	var HMARGIN = 6;
	var curOrder = parseInt(placeholder.style.webkitBoxOrdinalGroup) - 1;
	var newOrder = newLineBoxes.length - 1;
	newLineBoxes.forEach(function (box) {
		orderToBox[parseInt(box.style.webkitBoxOrdinalGroup) - 1] = box;
	});
	
	// Calculate the offsets ourselves. Sometimes (though very rarely) WebKit will hiccup and the offsets
	// could become volatile during script execution, which might lead to erratic behavior.
	var offLeft = new Array(newLineBoxes.length), offRight = new Array(newLineBoxes.length);
	offLeft[0] = 0; offRight[0] = orderToBox[0].offsetWidth;
	for (idx = 1; idx < newLineBoxes.length; idx++) {
		offLeft[idx] = offLeft[idx - 1] + orderToBox[idx - 1].offsetWidth + HMARGIN;
		offRight[idx] = offRight[idx - 1] + orderToBox[idx].offsetWidth + HMARGIN;
	}
	// Calculate new order.
	var cursor = mouseX - orderToBox[0].offsetLeft;
	for (idx = 1; idx < newLineBoxes.length; idx++) {
		if (cursor < ~~((offLeft[idx - 1] + offRight[idx]) / 2)) {
			newOrder = idx - 1;
			break;
		}
	}
	
	// Step 4. Move to that order.
	// Our "order" is 0-based while webkitBoxOrdinalGroup is 1-based. To minimize brainfart:
	curOrder += 1; newOrder += 1;
	if (curOrder > newOrder) {
		newLineBoxes.forEach(function (box) {
			var order = parseInt(box.style.webkitBoxOrdinalGroup);
			if (order >= newOrder && order < curOrder) box.style.webkitBoxOrdinalGroup = order + 1;
		});
		placeholder.style.webkitBoxOrdinalGroup = newOrder;
	} else if (curOrder < newOrder) {
		newLineBoxes.forEach(function (box) {
			var order = parseInt(box.style.webkitBoxOrdinalGroup);
			if (order <= newOrder && order > curOrder) box.style.webkitBoxOrdinalGroup = order - 1;
		});
		placeholder.style.webkitBoxOrdinalGroup = newOrder;
	}
	return false;
}).addEventListener("mouseup", function (evt) {
	if (!draggingBox) return true;
	draggingBox.style.left = draggingBox.style.top = draggingBox.style.width = draggingBox.style.height = '';
	draggingBox.style.webkitBoxOrdinalGroup = placeholder.style.webkitBoxOrdinalGroup;
	placeholder.parentElement.removeClass('layout-newline');
	placeholder.parentElement.appendChild(draggingBox);
	container.appendChild(placeholder);
	placeholder.addClass('hidden');
	draggingBox.removeClass('layout-dragging');
	draggingBox = null;
	commit();
	// Make sure the avatar is positioned correctly.
	skinManagerCmd.callCmd({ cmd: "getHeadPortraitPosition", module: "rebar" }, function (rs) {
		setAvatarPos(rs.position);
	});
	return false;
});

$("#layout-checkbox-avatar").addEventListener("click", function(evt) {
	skinManagerCmd.callCmd({ cmd: "setAvatarStatus", module: "rebar" }, function () {
		init();
	});
});

var curAvatarPos;

function setAvatarPos(pos) {
	var avatar = $('#layout-avatar')[0], fakeline = $('#layout-fakeline')[0], avatarCheckbox = $('#layout-checkbox-avatar')[0];
	if (pos === undefined) pos = curAvatarPos;
	avatarCheckbox.disabled = false;
	switch (pos) {
		case -1:
			fakeline.addClass("hidden");
			avatar.addClass("hidden");
			bAvatarHidden = true;
			avatarCheckbox.checked = false; avatarCheckbox.disabled = true; break;
		case 0: fakeline.addClass("hidden");
				avatar.addClass("hidden"); 
				bAvatarHidden = true; 
				avatarCheckbox.checked = false; break;
		case 1: $('#layout-lines')[0].insertAdjacentElement('afterbegin', avatar);
				avatar.removeClass("hidden"); avatar.removeClass("right");
				fakeline.removeClass("hidden"); 
				bAvatarHidden = false; 
				avatarCheckbox.checked = true; break;
		case 2: $('#layout-lines')[0].insertAdjacentElement('afterbegin', avatar);
				avatar.removeClass("hidden"); avatar.removeClass("right");
				fakeline.addClass("hidden"); 
				bAvatarHidden = false; 
				avatarCheckbox.checked = true; break;
		case 3: 
				if ($('.layout-line').length === 2)
					$('.layout-line')[0].insertAdjacentElement('beforebegin', avatar);
				else
					$('.layout-line')[0].insertAdjacentElement('afterend', avatar);
				avatar.removeClass("hidden"); avatar.removeClass("right");
				fakeline.addClass("hidden"); 
				bAvatarHidden = false; 
				avatarCheckbox.checked = true; break;
		case 4: $('.layout-line')[0].insertAdjacentElement('afterend', avatar);
				avatar.removeClass("hidden"); avatar.addClass("right");
				fakeline.addClass("hidden"); 
				bAvatarHidden = false; 
				avatarCheckbox.checked = true; break;
	}
	curAvatarPos = pos;
};

var originalBoxes;
var originalAvatarPosition;
var bFirst = true;

function generateTitle(strName) {
	switch (strName) {
		case "Title":
			return 'title="标题栏" ';
		case "Menu":
			return 'title="菜单栏" ';
		case "Toolbar":
			return 'title="工具栏" ';
		case "Addrbar":
			return 'title="地址栏" ';
		case "Searchbar":
			return 'title="搜索栏" ';
		case "Favorbar":
			return 'title="收藏栏" ';
		case "Extensionbar":
			return 'title="常用工具栏" ';
		case "Oftenbar":
			return 'title="最常访问栏" ';
	}
}

skinManagerCmd.callCmd({ cmd: "getHeadPortraitPosition", module: "rebar" }, function (rs) {
	// 仅仅是为了设置一个全局变量
	originalAvatarPosition = rs.position;
});

function init(outsideListener) {
	var rebarLayout = function() {
		skinManagerCmd.callCmd({ cmd: "getRebarStatus", module: "rebar" }, function (obj) {
			// alert(JSON.stringify(obj));
			//$("#layout-lines-warning")[0].innerHTML = "";
			var boxes = obj.rebarInfo;
			var skinType = obj.skinType;
			if (bFirst) {
				originalBoxes = boxes;
				bFirst = false;
			}
			var lines = ['<div id="layout-avatar"></div><div id="layout-fakeline" class="hidden"></div>'];
			var orderInLine = 0, i, hidden = false;
			for (i = 0; i < boxes.length; i++) {
				if (!hidden) {
					if (boxes[i].status === "Show_FirstOfLine") {
						orderInLine = 0;
						if (i !== 0) lines.push('</div>');
						lines.push('<div class="layout-line">');
					} else if (boxes[i].status === "Hide") {
						if (i !== 0) lines.push('</div>');
						$('#layout-lines')[0].innerHTML = lines.join('');
						lines = [];
						hidden = true;
						orderInLine = 0;
					}
				}
				orderInLine += 1;
				lines.push('<div class="layout-box" ' + generateTitle(boxes[i].name) + 'style="-webkit-box-ordinal-group: ' + orderInLine +
					'" id="layout-box-' + boxes[i].name + (skinType === "chrome" ? "-Chrome" : "") + '"></div>');
			}
			if (hidden) {
				$('#layout-staging-area')[0].innerHTML = lines.join('');
			} else {
				if (i !== 0) lines.push('</div>');
				$('#layout-lines')[0].innerHTML = lines.join('');
				$('#layout-staging-area')[0].innerHTML = "";
			}
			skinManagerCmd.callCmd({ cmd: "getHeadPortraitPosition", module: "rebar" }, function (rs) {
				setAvatarPos(rs.position);
			});
		});
	};

	rebarLayout();
	if (outsideListener)
		skinManagerCmd.addEventListener("rebarChangeFromOutside", function() {
			rebarLayout();
		});
}

function commit() {
	var boxes = $('#layout-lines .layout-line').reduce(function (sum, line) {
		var curLineBoxElements = line.$('.layout-box');
		var curLineBoxes = new Array(curLineBoxElements.length);
		curLineBoxElements.forEach(function (box) {
			var order = +box.style.webkitBoxOrdinalGroup - 1;
			curLineBoxes[order] = {
				name: box.id.slice(11).split("-Chrome")[0],
				status: order === 0 ? "Show_FirstOfLine" : "Show",
				width: parseInt(getComputedStyle(box).width)
			};
		});
		return sum.concat(curLineBoxes);
	}, []);
	boxes = boxes.concat($('#layout-staging-area .layout-box').map(function (box) {
		return {
			name: box.id.slice(11).split("-Chrome")[0],
			status: "Hide",
			width: parseInt(getComputedStyle(box).width)
		};
	}));
	// alert(JSON.stringify(boxes));
	skinManagerCmd.callCmd({ cmd: "setRebarStatus", arg: boxes, module: "rebar" }, function (response) {});
}

function initButtonEvents() {
	$("#layout-button-restore").addEventListener("click", function(evt) {
		var checkboxAvatar = $("#layout-checkbox-avatar")[0];
		skinManagerCmd.callCmd({ cmd: "restoreToDefault", module: "rebar" }, function () {
			init();
		});
	});
	
	$("#layout-button-save").addEventListener("click", function(evt) {
		skinManagerCmd.callCmd({ cmd: "closeWindow", module: "rebar" }, function () {});
	});
	
	$("#layout-button-cancel").addEventListener("click", function(evt) {
		skinManagerCmd.callCmd({ cmd: "setRebarStatus", arg: originalBoxes, module: "rebar" }, function (response) {
			skinManagerCmd.callCmd({ cmd: "getHeadPortraitPosition", module: "rebar" }, function (rs) {
				if (rs.position !== originalAvatarPosition) {
					skinManagerCmd.callCmd({ cmd: "setAvatarStatus", module: "rebar" }, function () {
						setAvatarPos(originalAvatarPosition);
					});
				}
				skinManagerCmd.callCmd({ cmd: "closeWindow", module: "rebar" }, function () {});
			});
		});
	});
}

init(true);
initButtonEvents();

})();
