/**
 * Author: Lynn Chen & Chris Wu
 * Email: homlean@gmail.com
 *
 * Lots of jobs to be done!
 */

    // SEAJS模块，需要继续细化
define(function (require, exports, module) {
    // 配置`商店`，存储于%appdata%\SogouExplore\CommCfg.xml，extradatausedbystartpagelocal字段
    var store = new Store();
    // debug
    window.store = store;
    // 设置本地图片为背景
    ntp.setLocalBg = function (uri) {
        var bgStyle = 'background-image:url("'+uri+'")';
        document.getElementsByTagName('body')[0].style.cssText = bgStyle;
        store.setItem('background', uri)
    };

    // TODO : use another api
    // 设置网络上的图片为背景
    ntp.setWebBg = function (url) {
        startPageCmd.callCmd({'cmd':'copyImage', 'url':url, 'slot':1}, function (arg) {
            console.log('copyimage---webbg');
            console.log(arg);

            if (arg.succeed === true) {
                var timestamp = Date.now();
                console.log('arg.urlarg.urlarg.urlarg.url')
                var imgUrl = arg.url +"?ver="+ timestamp;
                var bgStyle = 'background-image:url("'+imgUrl+'")';
                document.getElementsByTagName('body')[0].style.cssText = bgStyle;
                store.setItem('background', imgUrl)
            }
        })
    };

    // 设置纯色为背景
    // 此版已删

    // pingback
    ntp.ping = function (code) {
        window.external.StartPageCall('pingback', code)
    };

    // 在当前tab或新建tab打开URL
    ntp.openUrl = function (url) {
        startPageCmd.callCmd({cmd:"navigate", url:url, newTab:ntp.newtab, background:false })
    };

    // TODO CLEAR
    $(document).click(function (e) {
        var $sogoudailySetting = $('#sd-setting')
        $('.balloon').not($sogoudailySetting).hide();
        $('.more-btn').removeClass('ul-unfold');
        if ($sogoudailySetting.css('display') === 'block') {
            $('#sd-index .setting').trigger('click');
        }
    });

    // 从explorer读取起始页配置
    startPageCmd.callCmd({ cmd:"init" }, function (arg) {
        // 判断数据存储格式是否为JSON字符串，早期的配置以xml格式存储

        var isJsonConf = store.init(arg.localData);

        (function () {
            var PRESET = require('./preset');

            // 如果数据格式为JSON，则获取配置数据并初始化
            var pingCode = /index1/.test(location.href) ? 1 : 2,
                searchEngine = store.getItem('searchEngine') || 'sogou',
                searchState = JSON.parse(store.getItem('searchState')) || [],
                page = parseInt(store.getItem('page')) || 0,
                loc = JSON.parse(store.getItem('location')) || [],
                background = store.getItem('background') || '',
                lastCustomBg = store.getItem('lastCustomBg') || '',
//                tileNum = parseInt(store.getItem('tileNum')) || 0,
                tileNum = 12,
                NEWTAB = [null, true, false],
                newtabCode = 'newtab' + pingCode,
                newtab = NEWTAB[pingCode],
                bgIdx = JSON.parse(store.getItem('bgidx')) || 0,
                preset;

            var savedNewtab = store.getItem(newtabCode);

            /*判断版本升级到4.2*/
            if( PRESET.ver === "4.2.0.0" && store.getItem('preset') !== null && (JSON.parse(store.getItem('preset')).ver == null || JSON.parse(store.getItem('preset')).ver < "4.2.0.0") ){
                console.log('update!');
                preset = PRESET;
                store.setItem('background','');//4.1升4.2背景清空,默认选中第一张
                background = '';
                bgIdx = 0;
                store.setItem('bgidx', bgIdx);
                ntp.preset = preset;
                ntp.bgIdx = bgIdx;
                ntp.PRESET = PRESET;

            }
            else{
                console.log('old way')
                preset = JSON.parse(store.getItem('preset')) || PRESET;
            }
            console.log(PRESET)
            console.log(preset)


            if (savedNewtab != null) {
                newtab = savedNewtab
            }

            ntp.hardwareId = arg.hardwareId;
//            ntp.iconPath = arg.iconPath;
            ntp.thumbnailPath = arg.thumbnailPath + '/';

            // 如果数据格式非JSON格式，则对其进行转换
            if (!isJsonConf) {
                // 预设背景
                var BG = {
                    'b1':'http:\/\/download.ie.sogou.com\/img\/startup\/bg1.jpg',
                    'b2':'http:\/\/download.ie.sogou.com\/img\/startup\/bg2.jpg',
                    'b3':'http:\/\/download.ie.sogou.com\/img\/startup\/bg3.jpg',
                    'b4':'http:\/\/download.ie.sogou.com\/img\/startup\/bg4.jpg',
                    'b5':'http:\/\/download.ie.sogou.com\/img\/startup\/bg5.jpg',
                    'b6':'http:\/\/download.ie.sogou.com\/img\/startup\/bg6.jpg',
                    'b7':'http:\/\/download.ie.sogou.com\/img\/startup\/bg7.jpg',
                    'b8':'http:\/\/download.ie.sogou.com\/img\/startup\/bg8.jpg',
                    'b9':'C:/Documents and Settings/Administrator/Application Data/SogouExplorer/Thumbnails/backgorund.jpg',
                    'b10':'http:\/\/download.ie.sogou.com\/img\/startup\/10.jpg',
                    'c1':'#efcdcd',
                    'c2':'#e7e0bc',
                    'c3':'#cce8cf',
                    'c4':'#aec8e3',
                    'c5':'#b0b0b0',
                    'c6':'#80883a'
                };

                // 背景与所在位置的对应关系
                var BGIDX = {
                    'b1':0,
                    'b2':1,
                    'b3':2,
                    'b4':3,
                    'b5':4,
                    'b6':5,
                    'b7':6,
                    'b8':7,
                    'b9':8
                };

                var rPage = /<page>(\w+)<\/page>/;
                var rBackground = /<backPic1>(\w+)<\/backPic1>/;
                var rCustomBg = /<lastCustomBg>(\w+)<\/lastCustomBg>/;
                var rNum = /<stl_num>(\w+)<\/stl_num>/;
                var rNewtab1 = /<isTargetBlank>(\w+)<\/isTargetBlank>/;
                var rNewtab2 = /<isTargetBlank2>(\w+)<\/isTargetBlank2>/;
                var rLocation = /<favor_location>(\w+)<\/favor_location>/;
                var rSearch = /<cookiesel\d>(\w+)<\/cookiesel\d>/g;
                var rSearchEngine = /<cookiesel\d>(\w+)<\/cookiesel\d>/;

                var oldConfig = arg.localData;
                var pageResult = oldConfig.match(rPage);
                var backResult = oldConfig.match(rBackground);
                var numResult = oldConfig.match(rNum);
                var newtabResult = [];
                var ntResult1 = oldConfig.match(rNewtab1);
                var ntResult2 = oldConfig.match(rNewtab2);
                var customBgResult = oldConfig.match(rCustomBg);
                var locResult = oldConfig.match(rLocation);
                var searchResult = oldConfig.match(rSearch);

                if (searchResult) {
                    var GATE = {
                        '2':0,
                        '5':1,
                        '7':2,
                        '6':3,
                        '3':4
                    };
                    var len = searchResult.length;

                    for (var i = 0; i < len; i++) {
                        var sr = searchResult[i].match(rSearchEngine);

                        if (sr) {
                            var arr = sr[1].split('_');

                            if (arr[1] === '3' && arr[0].indexOf('sogou') >= 0) {
                                arr[0] = 'sogou'

                            } else if (arr[1] === '3' && arr[0].indexOf('sogou') < 0) {
                                arr[0] = 'baidu'
                            }
                        }

                        var idx = GATE[arr[1]];
                        searchState[idx] = arr[0]
                    }

                    store.setItem('searchState', JSON.stringify(searchState))
                }

                if (pageResult) {
                    var p = pageResult[1];

                    if (p == 'favor') {
                        page = 0

                    } else if (p == 'nav') {
                        page = 1
                    }

                    store.setItem('page', page)
                }

                if (backResult) {
                    background = BG[backResult[1]];
                    bgIdx = BGIDX[backResult[1]];
                    lastCustomBg = background;
                    store.setItem('bgidx', bgIdx);
                    store.setItem('lastCustomBg', lastCustomBg)
                }

                if (customBgResult) {
                    background = customBgResult[1];
                    store.setItem('background', background)
                }

                if (numResult) {
                    tileNum = parseInt(numResult[1]) || 0;
                    store.setItem('tileNum', tileNum)
                    startPageCmd.callCmd({cmd:'setGridCount', count:tileNum});
                }

                if (ntResult1) {
                    if (ntResult1[1] === 'true') {
                        newtabResult[1] = true

                    } else if (ntResult1[1] === 'false') {
                        newtabResult[1] = false
                    }

                    store.setItem('newtab1', newtabResult[1])
                }

                if (ntResult2) {
                    if (ntResult2[1] === 'true') {
                        newtabResult[2] = true

                    } else if (ntResult2[1] === 'false') {
                        newtabResult[2] = false
                    }

                    store.setItem('newtab2', newtabResult[2])
                }

                if (newtabResult[pingCode] != undefined) {
                    newtab = newtabResult[pingCode]

                } else {
                    newtab = NEWTAB[pingCode]
                }

                if (locResult) {
                    loc = locResult[1].split('_');

                    store.setItem('location', JSON.stringify(loc))
                }
            }

            // 如果没有设置背景，则将背景设置为第一个背景
            // 浏览器会从对应URL下载该图片，并保存在本地文件夹
            if (background) {
                ntp.background = background

            } else {
                ntp.background = 'http:\/\/download.ie.sogou.com\/img\/startup\/bg1.jpg'
            }

            store.setItem('background', ntp.background);
            ntp.pingCode = pingCode;
            ntp.searchEngine = searchEngine;
            ntp.searchState = searchState;
            ntp.location = loc;
            ntp.tileNum = tileNum;
            startPageCmd.callCmd({cmd:'setGridCount', count:ntp.tileNum});
            ntp.newtab = newtab;
            ntp.lastCustomBg = lastCustomBg;
            ntp.page = page;
            // Caveats
            // ntp.preset是被推荐网址冲洗后的数据
            ntp.preset = preset;
            ntp.bgIdx = bgIdx;
            ntp.PRESET = PRESET
        })();

        // 用户教育
        // 此版本用户教育模块已删除

        (function () {
            var MORE_STATE = ['more', 'more', 'more', 'more', 'more', '', ''],
                KLASS_STATE = ['three', 'two', 'two', 'two', 'two', 'one', 'one'];

            var $engine = $('#search_id');
            var $searchType = $('#search_s');
            var $query = $('#query');

            initSearchDisplay();
            initSearchForm();

            $('#search-bar .search-type li').click(function (e) {
                var idx = $(this).index();
                var searchType = $(this).attr('sp-data');

                $('#search-bar .search-type li').removeClass('on');
                $(this).addClass('on');

                setSearchDisplay(idx);
                setSearchForm(searchType)
            });

            // show change engine
            $('#widget-search .search-engine').on('click',function (e) {
                e.stopPropagation();
                $('.more-btn').stop(false,true).toggleClass('ul-unfold');
                $('.balloon').not($('#widget-search .search-engine ul')).hide();
//                $('#widget-search .search-engine ul').toggle()
                if($(this).find('.more-btn').css('display') != 'none'){
                    $('#widget-search .search-engine ul').stop(false,true).toggle('1000','swing');
                }
            });

            $('#widget-search .search-engine li').click(function (e) {
                e.stopPropagation();
                var engine = $(this).attr('sp-data');
                var idx = 0;

                $('#widget-search .search-type li').each(function (index) {
                    if ($(this).hasClass('on')) {
                        idx = index;
                        return false
                    }
                });

                ntp.searchState[idx] = engine;
                store.setItem('searchState', JSON.stringify(ntp.searchState));
                $engine.val(engine);
                $('#widget-search .search-engine').removeClass('sogou baidu taobao google').addClass(engine).attr('sp-data', engine);
                $('#widget-search .search-engine li').find('span').removeClass('search-selected');
                $(this).find('span').addClass('search-selected');
                $('.more-btn').toggleClass('ul-unfold');
                $('#widget-search .search-engine ul').hide()
            });

            $('#stb').click(function (e) {
                var klass = $searchType.val();
                var engine = $engine.val();
//                $('.balloon').not($sogoudailySetting).hide();
                $('.balloon').hide();
                if (klass === '2') {
                    sendPing();
                    doJSSearch(engine);

                    return false

                } else {
                    $('#sf').attr('action', 'http://so.ie.sogou.com/s/index.php?rand=1');

                    // hotfix for zhishi.sogou.com
                    if ($('#widget-search .search-type .on').attr('sp-data') === '3' && $('#widget-search .search-engine').attr('sp-data') === 'sogou') {
                        $engine.val('sogouzhishi')

                    } else if ($('#widget-search .search-type .on').attr('sp-data') === '3' && $('#widget-search .search-engine').attr('sp-data') === 'baidu') {
                        $engine.val('baiduzhidao')
                    }

                    if (ntp.newtab) {
                        $('#sf').attr('target', '_blank')

                    } else {
                        $('#sf').removeAttr('target')
                    }
                }

            });

            function setSearchForm(klass) {
                var engine = $('#widget-search .search-engine').attr('sp-data');
                $engine.val(engine);
                $searchType.val(klass)
            }

            function setSearchDisplay(index) {
                var klass = KLASS_STATE[index];
                var more = MORE_STATE[index];
                var engine = ntp.searchState[index] || 'sogou';

                // taobao
                if (index == 5) {
                    engine = 'taobao';
                }
                $('#widget-search .search-engine').removeClass().addClass(['search-engine', more, engine].join(' '));
                $('#widget-search .search-engine').attr('sp-data', engine);
                $('#widget-search .search-engine li').find('span').removeClass('search-selected');
                $('li[sp-data='+engine+']').find('span').addClass('search-selected')
                $('#widget-search .search-engine ul').removeClass().addClass(klass + ' balloon')
            }

            function initSearchDisplay() {
                var engine = ntp.searchState[0];
                var $engineLogo = $('#widget-search .search-engine');

                if (ntp.searchState[0] != undefined) {
                    $engineLogo.removeClass().addClass('search-engine more ' + engine);
                    $engineLogo.attr('sp-data', engine);
                    $('span.search-selected').removeClass('search-selected');
                    $('li[sp-data='+engine+']').find('span').addClass('search-selected');
                }
                $('#search-bar').show()
            }

            function initSearchForm() {
                var engine = ntp.searchState[0];

                if (engine != undefined) {
                    $engine.val(engine)
                }

                if (ntp.newtab) {
                    $('#sf').attr('target', '_blank')
                }
            }

            function sendPing() {
                var pingCode = '1_' + ntp.pingCode;
                var query = $query.val();
                var klass = $searchType.val();
                var code = [pingCode, '0', query, klass].join('\t');

                ntp.ping(code)
            }

            function doJSSearch(klass) {
                var ENGINES = {
                    google:'http://www.google.com.hk/search?hl=zh-CN&q=@',
                    sogou:'http://www.sogou.com/sogou?pid=AQktG&ie=utf8&query=@',
                    baidu:'http://www.baidu.com/baidu?word=@&tn=sogouie_dg'
                };
                var query = $query.val();
                var url = ENGINES[klass].replace('@', encodeURIComponent(query));
                ntp.openUrl(url)
            }
        })();

        // 九宫格
        var Tile = {
            timestamp:Date.now(),
            thumbPath:ntp.thumbnailPath,
            icoPath:ntp.iconPath,
            data:{},
            posArr:[],
            template:[
                '{{#sites}}',
                '{{#url}}',
                '<li class="tile-li {{size}} {{preset}} {{state}}" order="{{order}}">',
                '<a class="tile-a" href="{{url}}">',
                '{{#isdefault}}',
                '<img src="./img/tile_grid/default_img.png" alt="default" />',
                '{{/isdefault}}',
                '{{^isdefault}}',
                '{{#thumbnailUrl}}',
                '{{^preset}}',
                '<img src="', ntp.thumbnailPath,'/{{thumbnailUrl}}" alt="" draggable="false" />',
                '{{/preset}}',
                '{{#preset}}',
                '<img src="\img/preset/img/{{thumbnailUrl}}" alt="" />',
                '{{/preset}}',
                '{{/thumbnailUrl}}',
                '{{^thumbnailUrl}}',
                '<img class="img-loading" src="\img/tile_grid/loading.gif\" alt="" />',
                '{{/thumbnailUrl}}',
                '{{/isdefault}}',
                '<div class="tile-tips">',
                '<span class="tile-des">{{title}}</span>',
                '<span class="edit tile-edit"></span>',
                '<span class="del tile-clos"></span>',
                '</div>',
                '</a>',
                '{{#isdefault}}',
                '<span class="default-tips" style="display: block; opacity: 1;">{{title}}</span>',
                '{{/isdefault}}',
                '{{^isdefault}}',
                '{{^iswhitelist}}',
                '{{^preset}}',
                '<span class="default-tips" style="display: block; opacity: 1;">{{title}}</span>',
                '{{/preset}}',
                '{{/iswhitelist}}',
                '{{/isdefault}}',
                '{{/url}}',
                '{{^url}}',
                '<li class="tile-li {{size}} {{preset}} {{state}} add" order="{{order}}">',
                '<a class="tile-a" href="#"><img src="\img/tile_grid/add_normal_new.png\" alt="add" /></a>',
                '{{/url}}',
                '</li>',
                '{{/sites}}'
            ].join(''),
            init: function(){
                var self = this;
                startPageCmd.callCmd({cmd:"loadOftenURLs"}, function (arg) {
                    console.log('loadoften')
                    console.log(arg)
                    var MAX = 12;
                    self.data.sites = arg.slice(0, MAX);
                    console.log(self.data.sites)
                    var sites = self.data.sites;
                    var preSites = ntp.preset.sites;

                    // preset
                    for (var i = 0; i < MAX; i++) {
                        if (sites[i].url === '' && preSites[i] != undefined) {
                            sites[i] = preSites[i];

                        } else {
                            preSites[i] = undefined;
                        }
                    }

                    store.setItem('preset', JSON.stringify(ntp.preset));
                    if(!JSON.parse(store.getItem('preset')).ver){
                        ntp.preset.ver = "4.2.0.1";
                        store.setItem('preset', JSON.stringify(ntp.preset));
                    }
                    /*各种宫格预置数据替换*/
                    var presetConfStr = store.getItem('preset'),
                        presetConfObj = JSON.parse(presetConfStr).sites;
                    for(var key in presetConfObj){
                        if(presetConfObj[key] !== null){
                            if($.trim(presetConfObj[key].title) === "淘宝特卖"){
                                presetConfObj[key].title = "淘宝商城（天猫）";
                                presetConfObj[key].thumbnailUrl = "tmall.com.jpg";
                                presetConfObj[key].icon = "tmall.com.ico";
                                presetConfObj[key].url = "http://s.click.taobao.com/t?e=zGU34CA7K%2BPkqB05%2Bm7rfGGjlY60oHcc7bkKOQiRf%2B8UmyX6qN5gO54FYld3bfBedX4SgJbZ0au32NDdEwdCsKdKC6XlX7Pf%2BjN6r%2FUY6o7NPiRk3Q%3D%3D";
                            }
                            if($.trim(presetConfObj[key].title) === "搜狗游戏"){
                                presetConfObj[key].url = "http://wan.sogou.com/api/landingpage.do?source=0012000400000";
                            }
                        }
                    }
                    store.setItem('preset', JSON.stringify({"ver":"4.2.0.1","sites":presetConfObj}));

                    for (var i = 0; i < MAX; i++) {
                        var t = Math.floor(i / 4);
                        var l = i % 4;
                        sites[i].order = i;
                        sites[i].state = sites[i].pinned ? 'pinned' : 'unpinned';

                        if (sites[i].url == '') {
                            delete sites[i].url;
                        }
                    }

                    var html = Mustache.to_html(self.template, self.data);
                    $('#tile-grid').html(html);
                    self.setTileWidth();
                    self.initLayout();
                    self.bindDrag();
                    self.setPinBtn();
                    self.setDelBtn();
                    self.setEditBtn();
                    self.setAddBtn();
                    self.hideAllTiletips(0);
                    ICONPage.init();

                    $('.tile-a').live('click', function (e) {
                        e.preventDefault();
                        var url = this.href,
                            code = '1_' + ntp.pingCode,
                            pingback = [code, 'wp', url].join('\t');

                        ntp.openUrl(url);
                        ntp.ping(pingback);
                    });
                    /*add btn pingback*/
                    $('#tile-grid').delegate('.tile-des', 'click', function (e) {
                        var pingContent = ['click-area','tileTitle'].join('\t');
                        ntp.ping(pingContent);
                    });
                });

                ntp.initLayout = this.initLayout;
                $(window).resize(function () {
                    self.setTileWidth();
                    self.initLayout();
                });


            },
            setTileWidth: function(){ //统一tile-li的宽度，修复晃动1px bug
                var actCW = $('.con-wrap').width() - 4; //去除border、padding后，实际内容所能使用的宽度
                var actLW = Math.floor(actCW / 4);
                actLW = actLW-4 < 294 ? actLW : 296;//宫格图片显示尺寸限制
                $('.tile-li').width(actLW - 2);//li有1px的padding，.width()求的是实际内容值，故需-2，使得li宽度统一
                $('.tile-li').height(Math.floor((actLW - 4)*184/294));
                $('.tile-tips').width(actLW - 2 - parseInt($('.tile-tips').css('paddingLeft')));
                $('.default-tips').width($('.tile-tips').width());
//                $('#tile-grid').width(actLW * 4); //计算过li的宽度后，重新设定其ul的宽
                $('#tile-grid').css({
                    width:actLW * 4,
                    height:$('.tile-li').height() * 3 + 6
                }); //计算过li的宽度后，重新设定其ul的宽

                $('.con-wrap').css({
//                    width:Math.floor(curVisW*0.69)+'px',
                    top: ($(window).height()-$('.con-wrap').height())/2 > 18 ? ($(window).height()-$('.con-wrap').height())/2 : 18 + 'px',
                    left: ($(window).width()-$('.con-wrap').width())/2 + 'px'
                });
            },

            initLayout: function(){// 定位第二屏、第三屏内容位置
                var $this = $('.con-wrap'),
                    $btns = $('.ward-btn'),
                    curTileUlH = $('#tile-grid').height();

                $('#tile-grid .tile-li').each(function(idx,item){
                    var rowN = parseInt($(item).attr('order')/4),
                        colN = $(item).attr('order') % 4;
                    $(item).css({
                        top:(rowN * $(this).height() + (rowN+1)*2) +'px',
                        left:(colN * $(this).width() + (colN+1)*2) +'px'
                    })
                })
                $btns.css({
                    'height': curTileUlH,
                    'width': Math.floor(curTileUlH * 0.16),
                    'marginTop':(-curTileUlH)/2
                })

                $this.removeClass('spreso');
                if((screen.width == 1366 && screen.height == 768) || (screen.width == 1280 && screen.height == 720)){
                    $this.addClass('spreso');
                    $('.con-wrap-ws-nav').addClass('spreso');
                }

                this.posPageFooter();
            },

            posPageFooter: function(){
                setTimeout(function(){
                    var curOffsetTop = $('.page-foot-nav2').get(0).offsetTop + $('.con-wrap').get(0).offsetTop,
                        curOffsetLeft = $('#page-switch-tab').get(0).offsetLeft + $('.con-wrap').get(0).offsetLeft;
                    $('.page-footer').css({
                        top:curOffsetTop,
                        left:curOffsetLeft
                    })
                },0)
            },

            hideAllTiletips: function(param){
                $('#tile-grid').off('mouseover','.tile-li').off('mouseleave','.tile-li');
                $('#tile-grid').on('mouseover','.tile-li',function(e){
                    if(!param){
                        $(this).find('.tile-tips').css({
                            visibility:'visible',
                            bottom:'0'
                        })
                    }
                    else{
                        $(this).find('.tile-tips').css({
                            visibility:'hidden'/*,
                             bottom:'-26px'*/
                        })
                    }

                    $(this).find('.default-tips') && $(this).find('.default-tips').stop(false,true).fadeOut(0)
                }).on('mouseleave','.tile-li',function(e){
                        $(this).find('.tile-tips').css({
                            visibility:'hidden'
                        })
                        $(this).find('.default-tips') && $(this).find('.default-tips').stop(false,true).fadeIn(0)

                    })
            },

            bindDrag: function(){ //拖拽元素事件绑定
                var self = this;
                $('.tile-li').draggable({
                    revert:'invalid',
                    revertDuration:300,
                    zIndex:10,
                    opacity:0.8,
                    start:function (e, ui) {
                        $('.balloon').hide();
                        $('#sugmaindivname').hide();
                        self.hideAllTiletips(1);
                        $('.tile-li').css('zIndex','auto');
                        $('.tile-li').draggable('disable');
                        $(this).css('zIndex','10');
                        $('#page-list').css('zIndex','10');
                        ui.position.top = $(this).css('top');
                        ui.position.left = $(this).css('left');
                        ntp.dragStartPosition = ui.position;
                        ntp.recOrder = $(this).attr('order');
                    },
                    drag:function(e,ui){
                        self.hideAllTiletips(1);
                        $(this).trigger('mouseover');
                    },
                    stop:function(e,ui){
                        $('#page-list').css('zIndex','1');
                        if( $(this).attr('order') != ntp.recOrder ){
                            self.hideAllTiletips(1)
                        }
                        else{
                            $('.tile-li').draggable('enable');

                            self.hideAllTiletips(0);
                            $('.tile-li').removeClass('draggingover').css({
                                margin:0,
                                zIndex:'auto'
                            })
                        }
                    }
                });

                $('.tile-li').droppable({
                    hoverClass:'draghover',
                    over:function(e,ui){
                        $('.tile-li').draggable('disable');

                        self.setMoveShape(ui.draggable,$(this))
                        self.hideAllTiletips(1);
                    },
                    out:function(e,ui){
                        $(this).removeClass('draggingover').css({
                            margin:0,
                            zIndex:'auto'
                        })
                    },
                    drop:function (e, ui) {
                        $('.tile-li').draggable('disable');

                        self.hideAllTiletips(1);

                        ui.draggable.animate({
                            top:$(this).css('top'),
                            left:$(this).css('left'),
                            zIndex:'10',
                            opacity:'1'
                        },'normal','swing');

                        $(this).removeClass('draggingover').css('zIndex', '6').animate({
                            margin:0,
                            left:ntp.dragStartPosition.left,
                            top:ntp.dragStartPosition.top,
                            zIndex:'1',
                            opacity:'1'
                        },'normal','swing',function(){
                            self.hideAllTiletips(0);
                            $('.tile-li').draggable('enable');

                        });
                        var oOrder = ui.draggable.attr('order'),
                            tOrder = $(this).attr('order');

                        self.swapTilePos(oOrder, tOrder);
                        $(this).attr('order', oOrder);
                        ui.draggable.attr('order', tOrder);
                    }
                });
            },
            setMoveShape: function(elO,elT){ //根据源宫格所在位置，判断目标宫格偏移方向
                var idxO = parseInt(elO.attr('order')),
                    idxT = parseInt(elT.attr('order')),
                    lineO = parseInt(idxO/4),
                    lineT = parseInt(idxT/4),
                    tileOffset = 8;

                elT.css('zIndex','1').addClass('draggingover');
                if(lineO < lineT){//origin < target
                    if(idxT - idxO < 4){
                        elT.css({
                            marginTop:-tileOffset,
                            marginLeft:tileOffset
                        })
                    }else if(idxT - idxO > 4 && (idxT - idxO)%4 != 0){
                        elT.css({
                            marginTop:-tileOffset,
                            marginLeft:idxT%4 > idxO%4 ? -tileOffset : tileOffset
                        })
                    }else{
                        elT.css({
                            marginTop:-tileOffset,
                            marginLeft:0
                        })
                    }
                }else if(lineO > lineT){//origin > target

                    if(idxO - idxT < 4){
                        elT.css({
                            marginTop:+tileOffset,
                            marginLeft:-tileOffset
                        })
                    }else if(idxO - idxT > 4 && (idxO - idxT)%4 != 0){
                        elT.css({
                            marginTop:+tileOffset,
                            marginLeft:idxO%4 > idxT%4 ? tileOffset : -tileOffset
                        })
                    }else{
                        elT.css({
                            marginTop:+tileOffset,
                            marginLeft:0
                        })
                    }
                }else{ //origin = target
                    if(idxO < idxT){
                        elT.css({
                            marginTop:0,
                            marginLeft:-tileOffset
                        })
                    }else{
                        elT.css({
                            marginTop:0,
                            marginLeft:+tileOffset
                        })
                    }
                }
            },

            swapTilePos: function(o, t) { // origin, target
                if (this.getType(o) === 'preset') {
                    // all preset
                    if (this.getType(t) === 'preset') {
                        this.swapPresetPos(o, t)

                    } else {
                        this.swapSysPos(o, t, 0); // 第二个参数为空值
                        this.swapPresetPos(o, t)

                    }

                } else {
                    if (this.getType(t) === 'preset') {
                        this.swapSysPos(o, t, 1);
                        this.swapPresetPos(o, t)

                    } else {
                        this.swapSysPos(o, t)
                    }
                }
            },

            swapPresetPos: function(o, t) {//交换store中preset数据
                var preset = JSON.parse(store.getItem('preset'));
                var tmp = preset.sites[o];
                preset.sites[o] = preset.sites[t];
                preset.sites[t] = tmp;
                store.setItem('preset', JSON.stringify(preset))
            },

            getItemWithOrder: function(index) {
                var $ret = null;

                $('.tile-li').each(function () {
                    if ($(this).attr('order') == index) {
                        $ret = $(this).children('.tile-a')
                    }
                });

                return $ret
            },

            swapSysPos: function(o, t, id) {
                var oHref = this.getItemWithOrder(o).attr('href');
                var tHref = this.getItemWithOrder(t).attr('href');

                if (oHref === '#' || id == 0) {
                    oHref = ''
                }

                if (tHref === '#' || id == 1) {
                    tHref = ''
                }
                startPageCmd.callCmd({cmd:"swap", index1:parseInt(o), url1:oHref, index2:parseInt(t), url2:tHref}, function (arg) {});
            },

            getType: function(pos) {
                var ret = '';

                $('#tile-grid .tile-li').each(function () {
                    if ($(this).attr('order') == pos && $(this).hasClass('preset')) {
                        ret = 'preset';
                    }
                });

                return ret;
            },

            setDelBtn: function() {
                var self = this;
                $('#tile-grid').delegate('.del', 'click', function (e) {
                    var $tile = $(this).parents('li');
                    var $tileImg = $tile.find('img').eq(0);
                    var $tileTitle = $tile.find('.tile-des').eq(0);
                    var idx = parseInt($tile.attr('order'));
                    var $tileLink = $tile.find('a.tile-a');
                    startPageCmd.callCmd({cmd:'setGridCount', count:'12'});
                    if ($tile.hasClass('preset')) {
                        ntp.preset.sites[idx] = undefined;
                        store.setItem('preset', JSON.stringify(ntp.preset));
                        $tile.removeClass('preset');
                    }
                    /*del btn pingback*/
                    var pingContent = ['click-area','delTileBtn'].join('\t');
                    ntp.ping(pingContent);

                    startPageCmd.callCmd({cmd:'del', index:idx}, function (arg) {
                        if (arg[idx].url) {
                            var ts = $.now();
                            var site = arg[idx];
                            var thumb = 'img/tile_grid/loading.gif?v=' + ts;
                            if (site.thumbnailUrl) {
                                thumb = ntp.thumbnailPath + arg[idx].thumbnailUrl;
                            }

                            var $clone_a = $tileLink.clone(true);
                            $clone_a.css({
                                position:'absolute',
                                left:'0',
                                top:'0'
                            }).appendTo($tile);

                            $tile.find('.default-tips').remove();
                            $tileImg.attr('src', thumb);
                            $tileTitle.html(site.title);
                            $tileLink.attr('href', site.url);

                            if(!$.trim(site.thumbnailUrl)){//default img
                                $tileImg.attr('src', './img/tile_grid/default_img.png');
                                $('<span class="default-tips" style="display: block; opacity: 1;">'+ site.title +'</span>').insertAfter($tileLink);
                            }

                            $clone_a.animate({
                                marginLeft:'-120%',
                                marginTop:'-120%'
                            },300,'swing',function(){
                                $clone_a.stop(true,true).remove();
                            })

                        } else {
                            var $clone_a = $tileLink.clone(true);
                            $clone_a.css({
                                position:'absolute',
                                left:'0',
                                top:'0'
                            }).appendTo($tile);
                            $tile.find('.tile-tips').remove();
                            $tileLink.attr('href','javascript:void(0)').html('<img src="img/tile_grid/add_normal_new.png" alt="add" />')
                            $tile.addClass('add');
                            $tile.find('.default-tips').remove();

                            $clone_a.animate({
                                marginLeft:'-120%',
                                marginTop:'-120%'
                            },300,'swing',function(){
                                $clone_a.stop(false,true).remove();
                            })
                        }
                        $('#tile-grid li:hidden').each(function(){
                            var order = $(this).attr('order');
                            updateTile($(this), arg[order]);
                        });

                        SiteEdit.updateTileInfo();
                        self.setTileWidth();
                        self.bindDrag();

                    });

                    // 重置*最常访问*宫格
                    // url, thumb, title
                    // 参数为对应宫格(jQuery Object)和新的状态(Object)
                    function updateTile($tile, state) {
                        var ts = $.now();
                        var defaultThumbUrl = 'url(./img/tile_grid/loading.gif?v=' + ts + ')';
//                        var defaultIconUrl = './img/tile_grid/default_ico.png';

                        // 非空宫格
                        if (state.url) {
                            var thumbUrl = state.thumbnailUrl ? ('url(' + ntp.thumbnailPath + state.thumbnailUrl + '?v=' + ts + ')') : defaultThumbUrl;
//                            var iconUrl = state.icon ? (ntp.iconPath + state.icon + '?v=' + ts) : defaultIconUrl;
                            $('.thumb', $tile).css('background-image', thumbUrl);
//                            $('.ico img', $tile).attr('src', iconUrl);
                            $('.title', $tile).html(state.title);
                            $tile.attr('href', state.url);

                            // 空宫格
                        } else {
                            $tile.empty().html('<a class="tile-a" href="#"><img src="img/tile_grid/add_normal_new.png" alt="add" /></a>').addClass('add');
                            $tile.find('a').attr('href', '#')
                        }
                    }

                    return false;
                })
            },

            setPinBtn: function() {
                $('#tile-grid').delegate('.pin-btn', 'click', function (e) {
                    var $tile = $(this).parents('.tile');
                    var href = $tile.attr('href');
                    var order = $tile.attr('order');
                    $tile.removeClass('preset');

                    if ($tile.hasClass('pinned')) {
                        $tile.removeClass('pinned').addClass('unpinned');
                        var pingContent = ['unpin', order, href].join('\t');
                        ntp.ping(pingContent);
                        startPageCmd.callCmd({cmd:'unpin', index:parseInt(order), url:href}, function (arg) {
                        });

                    } else {
                        $tile.removeClass('unpinned').addClass('pinned');
                        var title = $tile.find('.title').text();
                        var pingContent = ['pin', order, href].join('\t');
                        ntp.ping(pingContent);
                        startPageCmd.callCmd({cmd:'pin', index:parseInt(order), url:href, isPresetURL:true, title:title}, function (arg) {
                        });
                    }

                    return false
                })
            },

            setEditBtn: function() {
                $('#tile-grid').delegate('.edit', 'click', function (e) {
                    var $tile = $(this).parents('li');
                    var idx = parseInt($tile.attr('order'));
                    var tileUrl = $tile.find('.tile-a').attr('href'),
                        tileTitle = $tile.find('.tile-des').text();
                    /*edit btn pingback*/
                    var pingContent = ['click-area','editTileBtn'].join('\t');
                    ntp.ping(pingContent);

                    startPageCmd.callCmd({cmd:'setGridCount', count:'12'});
//                    SiteEdit.editSite(tileUrl,tileTitle,idx);
                    SiteEdit.showOverlay(1,idx,$tile,tileUrl,tileTitle);

                    return false
                })
            },

            setAddBtn: function () {
                $('#tile-grid').delegate('.add', 'click', function (e) {
                    var $tile = $(this);
                    var idx = parseInt($tile.attr('order'));
                    /*add btn pingback*/
                    var pingContent = ['click-area','addTileBtn'].join('\t');
                    ntp.ping(pingContent);

                    startPageCmd.callCmd({cmd:'setGridCount', count:'12'});
//                    SiteEdit.addHotSite(idx);
                    SiteEdit.showOverlay(0,idx,$tile);

                    return false
                })
            }
        };

        Tile.init();

        // TODO 整理一下结构
        (function () {
            var bg = ntp.background;
            init();
            setTopNav();

            /*            $('#setting-popup .close').click(function (e) {
             $('#setting-popup').hide()
             });*/

            // web background
            $('.img-bg li:not(.custom)').click(function (e) {
                $('.img-bg li').removeClass('selebg');
                $(this).addClass('selebg');
                var bgUrl = $(this).attr('bgurl');
                var pingback = ['background-pic', bgUrl].join('\t');
                var idx = $(this).index();
                ntp.ping(pingback);
                if (idx === ntp.bgIdx) {
                    return false
                }
                ntp.bgIdx = idx;
                store.setItem('bgidx', idx);
                ntp.setWebBg(bgUrl);
            });

            // custom background
            $('#setting-popup .img-bg .custom, #setting-popup .img-bg .change').click(function (e) {
                $('#setting-popup .img-bg .web').removeClass('selebg');
                $(this).addClass('selebg');
                var bgUrl = $(this).attr('bgurl');
                var pingback = ['background-pic', bgUrl].join('\t');
                ntp.ping(pingback);

                startPageCmd.callCmd({cmd:"selectBackground"}, function (arg) {
                    if (arg.state === 'succeed') {
                        var ts = Date.now(),
                            imgUri = ntp.thumbnailPath + arg.url + "?ver=" + ts;
                        ntp.setLocalBg(imgUri);
                        store.setItem('lastCustomBg', imgUri);
                        ntp.bgIdx = 7;
                        store.setItem('bgidx', 7)
                    }
                    else if (arg.state === 'file_type_wrong') {
                        alert('您指定的文件格式有误，请重新选择!')
                    }
                });
            });

            // custom background once selected
            $('#setting-popup .img-bg .selected').click(function (e) {
                var bgUrl = $(this).find('img').eq(0).attr('src');
                var pingback = ['background-pic', bgUrl].join('\t');
                ntp.ping(pingback);

                if (ntp.bgIdx === 8) {
                    return false
                }

                ntp.bgIdx = 8;
                store.setItem('bgidx', 8);
                ntp.setLocalBg(bgUrl)
            });

            // pure color background
            // 此版纯色背景已删

            /*选择宫格数*/
            // 此版选择宫格数已删

            $('#open-in-newtab').mousedown(function (e) {
                var val = $(this).find('input').eq(0)[0].checked;
                var newtabCode = 'newtab' + ntp.pingCode;

                if (val) {
                    ntp.newtab = false;
                    $('#sf').removeAttr('target')

                } else {
                    ntp.newtab = true;
                    $('#sf').attr('target', '_blank')
                }

                store.setItem(newtabCode, ntp.newtab)
            });

            function init() {
                initBackground();
//                initCustomBtn();
                initNewtabBtn();
                initTileNum();
            }

            function initBackground() {
                var rWeb = /^http:\/\/.+\.jpg$/,
                    rColor = /^#.{6}$/;
                if (rWeb.test(bg)) {
                    ntp.setWebBg(bg)
                }/* else if (rColor.test(bg)) {
                 ntp.setColorBg(bg)
                 }*/
                else {
                    ntp.setLocalBg(bg)
                }
                var bgUrl = $('#setting-popup .img-bg .web').eq(ntp.bgIdx).attr('bgurl'),
                    curBg = ['background-pic', bgUrl].join('\t');
                ntp.ping(curBg);

            }

            function initCustomBtn() {
                if (ntp.lastCustomBg && ntp.bgIdx === 8) {
                    $('#setting-popup .img-bg .custom').hide();
                    $('#setting-popup .img-bg .selected img').attr('src', ntp.lastCustomBg);
                    $('#setting-popup .img-bg .selected').show()
                }
            }

            function initNewtabBtn() {
                if (ntp.newtab) {
                    $('#open-in-newtab input').attr('checked', 'checked')

                } else {
                    $('#open-in-newtab input').removeAttr('checked')
                }
            }

            function initTileNum() {
                var $tileCounter = $('#setting-popup .tile-num input');
                $tileCounter.removeAttr('checked');

                if (ntp.tileNum == 12) {
                    $tileCounter.eq(0).attr('checked', 'checked')

                } else if (ntp.tileNum == 24) {
                    $tileCounter.eq(1).attr('checked', 'checked')

                } else {
                    $tileCounter.eq(2).attr('checked', 'checked')
                }
            }

            function setTopNav() {
                $('#page-head-nav a').click(function (e) {
                    var ping = ['1_', ntp.pingCode, '\t0\t', $(this).attr('pname')].join('');
                    ntp.ping(ping)
                });

                $('#page-head-nav .feedback').click(function (e) {
                    var url = $(this).attr('href');
                    url = [url, '?type=favor_', ntp.pingCode, '&fver=4.1.0.2&sever=', window.SE_VERSION].join('');
                    startPageCmd.callCmd({cmd:"navigate", url:url, newTab:ntp.newtab, background:false});
                    e.preventDefault()
                });

                $('#page-head-nav .setting').click(function (e) {
                    $('.balloon').not($('#setting-popup')).hide();
                    $('#setting-popup .img-bg li').eq(ntp.bgIdx).addClass('selebg');
                    $('#setting-popup').stop(false,true).toggle('1000','swing');
                    e.stopPropagation();
                });

                $('#setting-popup').on('click', function (e) {
                    e.stopPropagation();
                });
            }

        })();

        // icon导航页面
        var ICONPage = {
            data:require('./sites-data'),
            template:'\
        <div class="ws-con-wrap">\
            {{#list}}\
            <div class="ws-con-item clearfix">\
                <div class="setvertical clearfix">\
                    <div class="ws-type">\
                         <a class="ws-type-link {{class}}" href="{{typeUrl}}" target="_blank">{{typeTitle}}</a>\
                    </div>\
                    <div class="ws-item-list">\
                        <nav class="ws-item-nav ws-item-nav-sp">\
                            {{#sitesFh}}\
                            <a class="ws-item-link" href="{{url}}" target="_blank" title="{{name}}">{{name}}</a>\
                            {{/sitesFh}}\
                        </nav>\
                        <nav class="ws-item-nav">\
                            {{#sitesSh}}\
                            <a class="ws-item-link" href="{{url}}" target="_blank" title="{{name}}">{{name}}</a>\
                            {{/sitesSh}}\
                        </nav>\
                    </div>\
                </div>\
            </div>\
            {{/list}}\
        </div>\
      ',
            init:function(){
                var iconpage = this,
                    html = Mustache.to_html(iconpage.template, iconpage.data),
                    $conWrap = $('.con-wrap');
                $('#icon-nav .wrap-nav').append(html);
                $('.ws-con-item a').click(function (e) {
                    e.preventDefault();
                    var url = $(this).attr('href'),
                        title = $(this).text();
                    var pingback = ['1_', ntp.pingCode, '\t', 'nav', '\t', url, '\t', title].join('');

                    ntp.ping(pingback);
                    ntp.openUrl(url);

                })
                iconpage.adjustWebsitesNav();

                $(window).resize(function(){
                    iconpage.adjustWebsitesNav();
                })
            },
            adjustWebsitesNav:function(){
                var curw = $('.con-wrap').width(),
                    curh = $('.con-wrap').height(),
                    curl = $('.con-wrap').css('left'),
                    curt = $('.con-wrap').css('top'),
                    conh = $('.sub-wrap').height();

                if(curw <= 720){
                    $('.ws-item-link').css('fontSize','13px');
                    $('.ws-type-link').css('fontSize','18px');
                    $('.setvertical').css('padding','0.6% 0 0')
                }
                else if(curw > 720 && curw < 994){
                    $('.ws-item-link').css('fontSize','14px');
                    $('.setvertical').css('padding','1.5% 0 0')
                }
                else{
                    $('.ws-item-link').css('fontSize','16px');
                    $('.ws-type-link').css('fontSize','24px');
                    $('.setvertical').css('padding','2.4% 0 0')
                }
                $('.wrap-nav').css('height',0.9*(conh-8));
                $('.ws-con-wrap').css('height',0.9*(conh-8));
                $('.con-wrap-ws-nav').css({
                    width:curw,
                    height:curh,
                    left:curl,
                    top:curt,
                    visibility:'visible'
                });
            }
        };

        // 页面切换
        (function () {
            var PAGE = {
                '-1':'sogoudaily',
                '0':'local_fav',
                '1':'local_nav'
            };

            var OFFSET = {
                '-1':'0%',
                '0':'-100%',
                '1':'-200%'
            };

            // 当前所在的tab页
            var cur_page = ntp.page == -1 ? 0 : ntp.page;
            var $tab = $('[name=page-switch]'),$actTab = $('[name=page-switch-tab]');
            $('li', $tab).removeClass('on');
            $('li[page=' + cur_page + ']', $tab).addClass('on');

            var $backwardBtn = $('#backward-btn');
            var $forwardBtn =  $('#foreward-btn');

            // 首末tab隐藏对应导航键
            cur_page == 0 && $backwardBtn.hide();
            cur_page == 1 && $forwardBtn.hide();

            var wrapperLeft = OFFSET[cur_page];
            $('#page-list').css('left', wrapperLeft);

            var $cur = $('.inner-page[page="' + cur_page + '"]');
            $('.inner-page').not($cur).css('visibility', 'hidden');
            $('#page-main').show();

            ntp.ping([PAGE[cur_page], ntp.pingCode].join('\t'));

            // 底部导航直接切换tab页
            // 真实tab切换
            $('li', $actTab).click(function (e) {
                var idx = $(this).index();
                $actTab.css('visibility','hidden');
                $tab.css('visibility','visible');
                $('li:eq('+idx+')',$tab).trigger('click');
            })

            // mask tab切换
            $('li', $tab).click(function (e) {
                /*if($(this).index() === $('li.on', $tab).index()){
                 return
                 }
                 else{*/
                $('li', $tab).removeClass('on');
                $(this).addClass('on');
                var cur = $(this).attr('page');

                $('.inner-page').css('visibility', 'visible');
                $('#page-list').stop(false,false).animate({
                    'left':OFFSET[cur]
                }, 300,'swing', function () {
                    $('.inner-page[page!="' + cur + '"]').css('visibility', 'hidden');
                });
                $backwardBtn.show();
                $forwardBtn.show();
                if (cur == 1) {
                    $forwardBtn.hide();

                } else{
                    $backwardBtn.hide();
                }

                store.setItem('page', cur);
                var switch_ping = [PAGE[cur], ntp.pingCode].join('\t');
                window.external.StartPageCall('pingback', switch_ping);
//                }

            });

            // 前翻
            $forwardBtn.on('click', function (e) {
                /*if ($('#page-list').is(':animated')){
                 return false;
                 }*/
//                var cur = parseInt($('.inner-page').filter(function(idx){return $(this).css('visibility') == 'visible'}).attr('page'));
                var cur = parseInt($('.on', $tab).attr('page')),
                    idx = $('.on', $tab).index() == 0 ? 1 : 0;
                $actTab.css('visibility','hidden');
                $tab.css('visibility','visible');
                $('li:eq('+idx+')',$tab).trigger('click');

                if (cur++ <= 1) {
                    $('.inner-page').css('visibility', 'visible');

                    $('#page-list').stop(false,false).animate({
                        'left':OFFSET[cur]
                    }, 300,'swing', function () {
                        $('.inner-page[page!="' + cur + '"]').css('visibility', 'hidden')
                    });

                    cur == 1 && $(this).hide();
                    $backwardBtn.show();
                    $('li', $tab).removeClass('on');
                    $('li[page="' + cur + '"]', $tab).addClass('on');
                    store.setItem('page', cur);
//                    ntp.ping([PAGE[cur], ntp.pingCode].join('\t'));
                }
            });

            // 后翻
            $backwardBtn.on('click', function (e) {
                /*if ($('#page-list').is(':animated')){
                 return false;
                 }*/
//                var cur = parseInt($('.inner-page').filter(function(){return $(this).css('visibility') == 'visible'}).attr('page'));
                var cur = parseInt($('.on', $tab).attr('page')),
                    idx = $('.on', $tab).index() == 0 ? 1 : 0;
                $actTab.css('visibility','hidden');
                $tab.css('visibility','visible');
                $('li:eq('+idx+')',$tab).trigger('click');

                if (cur-- >= 0) {
                    $('.inner-page').css('visibility', 'visible');

                    $('#page-list').stop(false,false).animate({
                        'left':OFFSET[cur]
                    }, 300,'swing', function () {
                        $('.inner-page[page!="' + cur + '"]').css('visibility', 'hidden');
                    });

                    cur == 0 && $(this).hide();
                    $forwardBtn.show();
                    $('li', $tab).removeClass('on');
                    $('li[page="' + cur + '"]', $tab).addClass('on');
                    store.setItem('page', cur);
//                    ntp.ping([PAGE[cur], ntp.pingCode].join('\t'));
                }
            });

            /*mouse wheel*/
            $('#page-main').on('mousewheel',function(e){
                var delta = event.wheelDelta || -event.detail,
                    cur = parseInt($('.on', $tab).attr('page'));
                if(delta >= 120){
                    if(cur == 0)return;
                    $backwardBtn.trigger('click');
                }
                else if(delta <= -120){
                    if(cur == 1)return;
                    $forwardBtn.trigger('click');
                }
            })

        })();
        ntp.logoUrl = 'http://data.ie.sogou.com/favor/icon2.php?url=';
        var gArr = {};
        //网址编辑
        var SiteEdit = {
            hsData: require('./hotsites'),
            template: '',
            hasBound: false,
            tiles: $('.tile-li'),
            layer: $('#we-overlay'),
            container: $('.we-wrap'),
            hsSearch: $('#hsSearch'),
            tabs: $('.op-btn-item'),
            tabsCon: $('.we-con-item'),
            clTabs: $('.hot-classify-li'),
            clTabsCon: $('#we-hot-sites'),
            manualTabs: $('.manual-op-btn'),
            manualTabsCon: $('.manual-list-area'),
            manualTalsUl: $('.manual-list-ul'),
            manualItem: $('.manual-list-item'),
            manualUrl: $('.we-con-url'),
            manualTitle: $('.we-con-title'),
            manualText: $('.we-con-text'),
            addBtn: $('.add-hot-btn'),
            closeBtn: $('.we-clos'),
            execBtn: $('.conf-btn-exec'),
            cancelBtn: $('.conf-btn-cancel'),
            curTileIdx: '',
            curTile: '',
            sTimer: null,
            hsWrap: $('.hot-sites-ul'),
            tileTmp: [
                '{{#site}}',
                '<li class="tile-li {{size}} {{preset}} {{state}}" order="{{order}}">',
                '<a class="tile-a" href="{{url}}">',
                '{{#isdefault}}',
                '<img src="./img/tile_grid/default_img.png" alt="default" />',
                '{{/isdefault}}',
                '{{^isdefault}}',
                '{{#thumbnailUrl}}',
                '<img src="', ntp.thumbnailPath,'/{{thumbnailUrl}}" alt="" />',
                '{{/thumbnailUrl}}',
                '{{^thumbnailUrl}}',
                '<img class="img-loading" src="\img/tile_grid/loading.gif\" alt="" />',
                '{{/thumbnailUrl}}',
                '{{/isdefault}}',
                '<div class="tile-tips">',
                '<span class="tile-des">{{title}}</span>',
                '<span class="edit tile-edit"></span>',
                '<span class="del tile-clos"></span>',
                '</div>',
                '</a>',
                '{{#isdefault}}',
                '<span class="default-tips" style="display: block; opacity: 1;">{{title}}</span>',
                '{{/isdefault}}',
                '{{^isdefault}}',
                '{{^iswhitelist}}',
                '{{^preset}}',
                '<span class="default-tips" style="display: block; opacity: 1;">{{title}}</span>',
                '{{/preset}}',
                '{{/iswhitelist}}',
                '{{/isdefault}}',
                '</li>',
                '{{/site}}'
            ].join(''),
            hsTmp : [
                '{{#hotsites}}',
                '<li class="hot-sites-li {{hasAdded}}" data-url="{{url}}" data-title="{{title}}">',
                '<img src="', ntp.logoUrl,'{{url}}" title="{{title}}" alt="{{title}}" onerror="this.src=','\'img/tile_grid/default_img.png\';this.parentNode.childNodes[4].className +=','\' errdes_show\'','" />',
                '<span class="sites-li-mask"></span>',
                '<span class="add-hot-btn">',
                '<p class="hot-sites-title">{{title}}</p>',
                '</span>',
                '<i></i>',
                '<p class="hot-sites-title-onerror">{{title}}</p>',
                '</li>',
                '{{/hotsites}}'
            ].join(''),
            mlTmp: [
                '{{#manuallist}}',
                '<li class="manual-list-item">',
                '<span class="manual-list-icon" style="background-image: url(','sbwk://favicon/{{url}}',')">',
                '</span>',
                '<a class="manual-list-a" href="{{url}}">{{title}}</a>',
                '</li>',
                '{{/manuallist}}'
            ].join(''),
            favStyle: {
                "fontFamily":"Microsoft Yahei",
                "fontSize":"12px",
                "lineHeight":"26px",
                "fontColor":"#7F7F7F",
                "embedBgColor":"#FFFFFF",
                "hoverBgColor":"#F4F4F4",
                "selectedBgColor":"#E5E5E5"
            },
            init: function(){
                //判断显示哪个tab页
                //注册事件
                var self = this;
                if(!this.hasBound){

                    this.switchTab();
                    this.switchClassify();
                    this.switchManual();
                    this.bindEvents();

                    this.hasBound = true;
                }

                //update source data
                this.updateTileInfo();
                this.updateSourceData();

                //init show
                this.clTabs.eq(0).trigger('click',0);
                this.manualTabs.eq(0).trigger('click',0);
                this.layer.fadeIn(300,'swing');
                this.manualUrl.focus();
                $(".nano").nanoScroller({"scroll":"top"});
            },
            updateTileInfo: function(){
                gArr = {};
                $('.tile-li').each(function(idx,item){
                    gArr[$(this).find('.tile-des').text()] = $(this).find('.tile-a').attr('href')
                });
                console.log('garr: ',gArr)
            },
            updateSourceData: function(){
                var localDataSub = this.hsData.hotSites[0];
                for(var key in localDataSub){
                    for(var subkey in localDataSub[key]){
                        localDataSub[key][subkey].hasAdded = (function(key,subkey){
                            for(var i in gArr){
                                if(gArr[i] === localDataSub[key][subkey].url){
                                    return "selected-li"
                                }
                            }
                        })(key,subkey);
                    }
                }
            },
            bindEvents: function(){
                //bind events
                //添加 确定 取消 关闭
                var self = this;
                this.hsSearch.focus(function(e){
                    e.preventDefault();
                    //判断是否在hs屏，不在则trigger做切换
                    if(!!$('.op-btn-item.cur').index()){//not hs
                        self.tabs.eq(0).trigger('click',0);
                    }
                    if(self.sTimer){
                        clearTimeout(self.sTimer);
                        self.sTimer = null;
                    }
                    self.sTimer = setTimeout(function(){
//                            lastVal = $('#hsSearch').val();
                        self.initSearch();
                    },400);

//                    self.initSearch();
                });
                this.execBtn.click(function(){
                    self.manualUrlCB();
                });
                this.closeBtn.click(function(){
                    self.setClose();
                });
                this.cancelBtn.click(function(){
                    self.setClose();
                })
                this.manualUrl.focus(function(){
                    $(this).hasClass('warn') && $(this).removeClass('warn').val('');

                });
//                this.manualUrl.keydown(function(e){
                $('.we-con-text input').keydown(function(e){
                    if(e.keyCode == 13){
                        self.manualUrlCB();
                    }
                });

                $('.we-j2m-btn').click(function(){
                    self.tabs.eq(1).trigger('click',1);
                });
            },
            //add hot site
            bindAddHot: function(){
                var self = this;
                $('.add-hot-btn').each(function(idx,item){
                    $(item).click(function(){
                        //todo change this tile's hasAdded flag to 'selected-li'
                        self.setExec($(this).parents('li').attr('data-url'),$(this).parents('li').attr('data-title'))
                    })
                });
            },
            //tab2 callback
            manualUrlCB: function(){
                var self = this;
                if(!$.trim(self.manualUrl.val()).length){
                    //todo 显示错误警告
                    self.manualUrl.blur();
                    self.manualUrl.addClass('warn').val('请输入网址');
                    setTimeout(function(){
                        self.manualUrl.removeClass('warn').val('');
                    },3000);
                    return
                }
                if(self.manualUrl.hasClass('warn')){
                    return
                }
                //符合规范 则走setExec
                self.setExec(self.manualUrl.val(),self.manualTitle.val());
            },
            //搜索本地数据
            searchLocalData: function(str){

                var self = this,
                    localData = JSON.stringify(this.hsData),
                    localDataSub = this.hsData.hotSites[0],
                    searchResultArr = [];
                if(localData.indexOf(str) > -1){
                    for(var key in localDataSub){
                        for(var subkey in localDataSub[key]){
                            if((localDataSub[key][subkey].title).indexOf(str) >-1 || (localDataSub[key][subkey].url).indexOf(str) >-1){
                                searchResultArr.push(localDataSub[key][subkey]);
                            }
                        }
                    }
                }
                console.log('result: ',searchResultArr);
                if(!searchResultArr.length){
                    this.hsWrap.html("<p class='we-search-nore'>未找到您搜索的网站</p><p class='we-search-nore we-search-nores'>您可以尝试：<span class='we-j2m-btn'>手动添加</span></p>");
                    $('.we-j2m-btn').click(function(){
                        self.tabs.eq(1).trigger('click',1);
                    });
                }
                else{
                    var newResultData = {"hotsites":searchResultArr};
                    var newSL = Mustache.to_html(this.hsTmp, newResultData);
                    this.hsWrap.html(newSL);
                    this.bindAddHot();
                }

                $(".nano").nanoScroller();
            },
            showOverlay: function(curtab,idx,tileObj,url,tit){
                this.tabs.removeClass('cur');
                this.tabsCon.removeClass('cur');
                this.tabs.eq(curtab).addClass('cur');
                this.tabsCon.eq(curtab).addClass('cur');
                if(url || tit){
                    this.manualUrl.val(url);
                    this.manualTitle.val(tit);
                }
                this.curTileIdx = idx;
                this.curTile = tileObj;
                this.init();
            },
            switchTab: function(){
                var self = this;
                this.tabs.each(function(idx,item){
                    $(item).click(function(a){
                        a = idx;
                        if($(this).hasClass('cur')){
                            return;
                        }
                        else{
                            self.tabs.removeClass('cur');
                            self.tabsCon.removeClass('cur');
                            $(this).addClass('cur');
                            self.tabsCon.eq(a).addClass('cur');
                            if(a == 1){
                                /*收藏夹事件注册*/
                                bindFavEvent();

                                $('#we-fav').parents('.manual-list-area').css('display') !== 'none' && $('#we-fav').get(0).callCmd({cmd:"setStyle",params:self.favStyle},function(arg){});
                            }
                            $(".nano").nanoScroller();
                        }
                    })
                })
            },
            switchClassify: function(){
                //切换后render template
                //通过选项卡下标来
                var self = this;
                this.clTabs.each(function(idx,item){
                    $(item).click(function(a){
                        a = idx;
                        /*if($(this).hasClass('cur')){
                         return;
                         }
                         else{*/
                        self.clTabs.removeClass('cur');
                        $(this).addClass('cur');

                        //todo
                        //render new sites data

                        var hsKey = Object.keys(self.hsData.hotSites[0])[a],
                            hsDa = self.hsData.hotSites[0][hsKey],
                            newHsda = {"hotsites":hsDa};
                        var newHs = Mustache.to_html(self.hsTmp, newHsda);
                        self.hsWrap.html(newHs);
                        self.bindAddHot();

                        $(".nano").nanoScroller({"scroll":"top"});
//                        }

                    })
                })
            },
            switchManual: function(){
                //切换后，调callCmd，得到回调arg，render template
                //对于idx == 2的情况，需要在容器内插入指定的embed
                var self = this;
                this.manualTabs.each(function(idx,item){
                    $(item).click(function(a){
                        a = idx;
                        if($(this).hasClass('cur')){
                            return;
                        }
                        else{
                            self.manualTabs.removeClass('cur');
//                        self.manualTabsCon.hide();
                            self.manualTabsCon.removeClass('cur');
                            $(this).addClass('cur');
                            self.manualTabsCon.eq(a).addClass('cur');
                            switch (a){
                                case 0:
                                    startPageCmd.callCmd({cmd:"loadOftenBarURLs"}, function(args) {
                                        var mlData = {"manuallist":args};
                                        var newMl = Mustache.to_html(self.mlTmp, mlData);
                                        self.manualTalsUl.eq(0).html(newMl);
                                        $(".nano").nanoScroller({"scroll":"top"});
                                        self.setSiteInfo();
                                    });
                                    break;
                                case 1:
                                    startPageCmd.callCmd({cmd:"loadOpenedTabURLs"}, function(args) {
                                        var mlData = {"manuallist":args};
                                        var newMl = Mustache.to_html(self.mlTmp, mlData);
                                        self.manualTalsUl.eq(1).html(newMl);
                                        $(".nano").nanoScroller({"scroll":"top"});
                                        self.setSiteInfo();
                                    });
                                    break;
                                case 2:
                                    //todo send css params to KJJ
                                    bindFavEvent();
                                    $('#we-fav').get(0).callCmd({cmd:"setStyle",params:self.favStyle},function(arg){});
                                    break;
                            }
                        }
                    })
                });

            },
            //单击或双击手动列表
            setSiteInfo: function(){
                var self = this;
                $('.manual-list-item').click(function(e){//single click
                    e.preventDefault();

                    $('.manual-list-item').removeClass('cur');
                    $(this).addClass('cur');
                    if(self.manualUrl.hasClass('warn')){
                        self.manualUrl.removeClass('warn').val('');
                    }
                    self.manualUrl.val($(this).find('.manual-list-a').attr('href'));
                    self.manualTitle.val($(this).find('.manual-list-a').text());

                });
                $('.manual-list-item').dblclick(function(e){//double click
                    e.preventDefault();

                    self.setExec($(this).find('.manual-list-a').attr('href'),$(this).find('.manual-list-a').text())
                    self.setClose();
                })
            },
            setExec: function(oUrl,oTit){//setstaticnew
                var self = this,
                    ourl = encodeURI(decodeURIComponent(oUrl)),otit = oTit;
                if(!otit){
                    otit = ourl;
                }
                startPageCmd.callCmd({cmd:"setstaticnew",index:this.curTileIdx,url:ourl,title:otit},function(args){
                    //todo render template
                    var data = { "site":args[self.curTileIdx]};
                    var $newObj = $(Mustache.to_html(self.tileTmp, data));
                    $newObj.attr({
                        'style': self.curTile.attr('style'),
                        'order': self.curTile.attr('order')
                    });
                    self.curTile.replaceWith($newObj);
//                    Tile.setTileWidth();
                    Tile.bindDrag();
                    self.setClose();

                });
            },
            setClose: function(){
                $('#we-fav').hide();
                this.hsSearch.val('');
                this.manualText.find('input[type=text]').val('');
                this.clTabs.removeClass('cur');
                $('#we-overlay').fadeOut(250,'swing',function(){
                    $('#we-fav').show();
                });
            },
            initSearch: function(){//$('#hsSearch').focus时候触发
                var self = this;
                this.hsSearch.off('keyup click');
                this.hsSearch.on('keyup click',function(e){

                    if(!$(this).val()){
                        self.clTabs.eq($('.hot-classify-li.cur').index()).trigger('click',$('.hot-classify-li.cur').index());
                    }
                    else{
                        self.searchLocalData($('#hsSearch').val());
                    }
                });
            }
        };

        /*deal with myfav sites*/
        function bindFavEvent(){
            $('#we-fav').get(0).addEventListener('selectItem', function(){
                selectItem(arguments)
            })
            $('#we-fav').get(0).addEventListener('doubleClickItem', function(){
                doubleClickItem(arguments)
            })
        }

        function selectItem(param){
            if(SiteEdit.manualUrl.hasClass('warn')){
                SiteEdit.manualUrl.removeClass('warn').val('');
            }
            SiteEdit.manualUrl.val(param[0].url);
            SiteEdit.manualTitle.val(param[0].name);
        }

        function doubleClickItem(param){
            SiteEdit.setExec(param[0].url,param[0].name);
        }

        // 天气预报
        //天气功能目前版本已删

        // 新闻资讯
        // 此版本暂时去掉

        setTimeout(function () {
//            $('.inner-page').nanoScroller();
            // auto focus
            $(function () {
                $('#query').focus();
                $('#page-main').keydown(function(e){//宫格、常用网址屏蔽tab键
                    if(e.keyCode == 9){
                        e.preventDefault();
                        return
                    }
                })
            })
        }, 50)
    });

    // 新闻热词
    // 热词模块在此版本已删
//    SiteEdit.init();
});


