
local MakePlayerCharacter = require "prefabs/player_common"


local assets = {

        Asset( "ANIM", "anim/player_basic.zip" ),
        Asset( "ANIM", "anim/player_idles_shiver.zip" ),
        Asset( "ANIM", "anim/player_actions.zip" ),
        Asset( "ANIM", "anim/player_actions_axe.zip" ),
        Asset( "ANIM", "anim/player_actions_pickaxe.zip" ),
        Asset( "ANIM", "anim/player_actions_shovel.zip" ),
        Asset( "ANIM", "anim/player_actions_blowdart.zip" ),
        Asset( "ANIM", "anim/player_actions_eat.zip" ),
        Asset( "ANIM", "anim/player_actions_item.zip" ),
        Asset( "ANIM", "anim/player_actions_uniqueitem.zip" ),
        Asset( "ANIM", "anim/player_actions_bugnet.zip" ),
        Asset( "ANIM", "anim/player_actions_fishing.zip" ),
        Asset( "ANIM", "anim/player_actions_boomerang.zip" ),
        Asset( "ANIM", "anim/player_bush_hat.zip" ),
        Asset( "ANIM", "anim/player_attacks.zip" ),
        Asset( "ANIM", "anim/player_idles.zip" ),
        Asset( "ANIM", "anim/player_rebirth.zip" ),
        Asset( "ANIM", "anim/player_jump.zip" ),
        Asset( "ANIM", "anim/player_amulet_resurrect.zip" ),
        Asset( "ANIM", "anim/player_teleport.zip" ),
        Asset( "ANIM", "anim/wilson_fx.zip" ),
        Asset( "ANIM", "anim/player_one_man_band.zip" ),
        Asset( "ANIM", "anim/shadow_hands.zip" ),
        Asset( "SOUND", "sound/sfx.fsb" ),
        Asset( "SOUND", "sound/wilson.fsb" ),
        Asset( "ANIM", "anim/beard.zip" ),

		-- Don't forget to include your character's custom assets!
        Asset( "ANIM", "anim/soa.zip" ),
}
local prefabs = {}

local fn = function(inst)
	
	-- choose which sounds this character will play
	inst.soundsname = "wolfgang"

	-- a minimap icon must be specified
	inst.MiniMapEntity:SetIcon( "wilson.png" )

	-- todo: Add an example special power here.
	inst.components.combat.damagemultiplier = 4 + (1.1*GetClock().numcycles)
	inst.components.locomotor.walkspeed = (TUNING.WILSON_WALK_SPEED * 1.05)
	inst.components.locomotor.runspeed = (TUNING.WILSON_RUN_SPEED * 1.20)
	inst.components.health:SetMaxHealth(300)
	--change to make more dark souls friendly. less health but with respawn
	inst.components.hunger:SetMax(300)
	
	
end


local Sanity = Class(function(self, inst)
    self.inst = inst
    self.max = 200
    self.current = self.max
	
	self.rate = .2
	self.sane = true
	self.fxtime = 0
	self.dapperness = 0
	self.inducedinsanity = nil
	self.night_drain_mult = 30
	self.neg_aura_mult = 1

	self.penalty = 0

	self.inst:StartUpdatingComponent(self)
	self:Recalc(0)
end)

-- The character select screen lines
-- note: these are lower-case character name
STRINGS.CHARACTER_TITLES.soa = "Knight of Sunlight"
STRINGS.CHARACTER_NAMES.soa = "Solaire of Astora"
STRINGS.CHARACTER_DESCRIPTIONS.soa = "*A mysterious, cheerful fellow who spends his time staring at the -OUCH!"
STRINGS.CHARACTER_QUOTES.soa = "\"I hope you are enjoying our 'Jolly Cooperation.'\""

-- strings! Any "soa" below would have to be replaced by the prefab name of your character.

	

-- You can also add any kind of custom dialogue that you would like. Don't forget to make
-- categores that don't exist yet using = {}
-- note: these are UPPER-CASE charcacter name


return MakePlayerCharacter("soa", prefabs, assets, fn)

