/*
 * Decompiled with CFR 0.152.
 */
package org.openide.util;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import org.openide.util.Lookup;

public final class NbPreferences {
    private static Provider PREFS_IMPL;

    private NbPreferences() {
    }

    public static Preferences forModule(Class clazz) {
        if (PREFS_IMPL == null) {
            PREFS_IMPL = NbPreferences.getPreferencesProvider();
        }
        return PREFS_IMPL.preferencesForModule(clazz);
    }

    public static Preferences root() {
        if (PREFS_IMPL == null) {
            PREFS_IMPL = NbPreferences.getPreferencesProvider();
        }
        return PREFS_IMPL.preferencesRoot();
    }

    private static Provider getPreferencesProvider() {
        Provider provider = (Provider)Lookup.getDefault().lookup(Provider.class);
        if (provider == null) {
            provider = new Provider(){

                @Override
                public Preferences preferencesForModule(Class clazz) {
                    return Preferences.userNodeForPackage(clazz);
                }

                @Override
                public Preferences preferencesRoot() {
                    return Preferences.userRoot();
                }
            };
            String string = System.getProperty("java.util.prefs.PreferencesFactory");
            if (!"org.netbeans.junit.internal.MemoryPreferencesFactory".equals(string)) {
                Logger logger = Logger.getLogger(NbPreferences.class.getName());
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                new Exception().printStackTrace(new PrintStream(byteArrayOutputStream));
                logger.log(string == null ? Level.WARNING : Level.FINE, "NetBeans implementation of Preferences not found: " + byteArrayOutputStream.toString());
            }
        }
        return provider;
    }

    public static interface Provider {
        public Preferences preferencesForModule(Class var1);

        public Preferences preferencesRoot();
    }
}

