/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.autoupdate.ui;

import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JTabbedPane;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.autoupdate.UpdateManager;
import org.netbeans.api.autoupdate.UpdateUnit;
import org.netbeans.modules.autoupdate.ui.AvailableTableModel;
import org.netbeans.modules.autoupdate.ui.Containers;
import org.netbeans.modules.autoupdate.ui.InstalledTableModel;
import org.netbeans.modules.autoupdate.ui.LocalDownloadSupport;
import org.netbeans.modules.autoupdate.ui.LocallyDownloadedTableModel;
import org.netbeans.modules.autoupdate.ui.SettingsTab;
import org.netbeans.modules.autoupdate.ui.UnitCategoryTableModel;
import org.netbeans.modules.autoupdate.ui.UnitDetails;
import org.netbeans.modules.autoupdate.ui.UnitTab;
import org.netbeans.modules.autoupdate.ui.UnitTable;
import org.netbeans.modules.autoupdate.ui.UpdateTableModel;
import org.netbeans.modules.autoupdate.ui.Utilities;
import org.netbeans.modules.autoupdate.ui.actions.AutoupdateCheckScheduler;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.util.Exceptions;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class PluginManagerUI
extends JPanel {
    private List<UpdateUnit> units = Collections.emptyList();
    private UnitTable installedTable;
    private UnitTable availableTable;
    private UnitTable updateTable;
    private UnitTable localTable;
    private JButton closeButton;
    public final RequestProcessor.Task initTask;
    private final Object initLock = new Object();
    private Object helpInstance = null;
    private static RequestProcessor.Task runningTask;
    private boolean wasSettings = false;
    public static final int INDEX_OF_UPDATES_TAB = 0;
    public static final int INDEX_OF_AVAILABLE_TAB = 1;
    public static final int INDEX_OF_DOWNLOAD_TAB = 2;
    public static final int INDEX_OF_INSTALLED_TAB = 3;
    public static final int INDEX_OF_SETTINGS_TAB = 4;
    public static final String[] TAB_NAMES;
    private int initialTabToSelect;
    private boolean detailView;
    public static final String DETAIL_VIEW_SELECTED_PROP = "plugin.manager.detail.view.selected";
    private JButton bClose;
    private JButton bHelp;
    private JPanel pProgress;
    private JTabbedPane tpTabs;

    public PluginManagerUI(JButton jButton) {
        this(jButton, null, true);
    }

    public PluginManagerUI(JButton jButton, Object object) {
        this(jButton, object, Boolean.getBoolean(DETAIL_VIEW_SELECTED_PROP));
    }

    public PluginManagerUI(JButton jButton, Object object, boolean bl) {
        this.detailView = bl;
        this.closeButton = jButton;
        int n = -1;
        for (int i = 0; i < TAB_NAMES.length; ++i) {
            if (!TAB_NAMES[i].equals(object)) continue;
            n = i;
            break;
        }
        if (n < 0 && null != object) {
            throw new IllegalArgumentException("Invalid tab name: " + object);
        }
        this.initialTabToSelect = n;
        this.initComponents();
        this.postInitComponents();
        this.initTask = Utilities.startAsWorkerThread(new Runnable(){

            @Override
            public void run() {
                PluginManagerUI.this.initialize();
            }
        });
    }

    boolean isDetailView() {
        return this.detailView;
    }

    void setDetailView(boolean bl) {
        this.detailView = bl;
    }

    private Window findWindowParent() {
        Container container = this;
        while (container != null) {
            if (!((container = container.getParent()) instanceof Window)) continue;
            return (Window)container;
        }
        return null;
    }

    void setWaitingState(boolean bl) {
        boolean bl2 = !bl;
        for (Component component : this.tpTabs.getComponents()) {
            if (!(component instanceof UnitTab)) continue;
            ((UnitTab)component).setWaitingState(bl);
        }
        this.bClose.setEnabled(true);
        this.bHelp.setEnabled(this.getHelpInstance() != null);
        Container container = this.getParent();
        JRootPane jRootPane = this.getRootPane();
        if (container != null) {
            container.setEnabled(bl2);
        }
        if (jRootPane != null) {
            if (bl2) {
                jRootPane.setCursor(null);
            } else {
                jRootPane.setCursor(Cursor.getPredefinedCursor(3));
            }
        }
    }

    @Override
    public void addNotify() {
        super.addNotify();
        final Window window = this.findWindowParent();
        if (window != null) {
            window.addWindowListener(new WindowAdapter(){

                @Override
                public void windowOpened(WindowEvent windowEvent) {
                    final 2 var2_2 = this;
                    PluginManagerUI.this.setWaitingState(true);
                    Utilities.startAsWorkerThread(PluginManagerUI.this, new Runnable(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void run() {
                            try {
                                PluginManagerUI.this.initTask.waitFinished();
                                window.removeWindowListener(var2_2);
                            }
                            finally {
                                PluginManagerUI.this.setWaitingState(false);
                            }
                        }
                    }, NbBundle.getMessage(PluginManagerUI.class, (String)"UnitTab_InitAndCheckingForUpdates"), Utilities.getTimeOfInitialization());
                }
            });
        }
        HelpCtx.setHelpIDString((JComponent)this, (String)PluginManagerUI.class.getName());
        this.tpTabs.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                HelpCtx.setHelpIDString((JComponent)PluginManagerUI.this, (String)PluginManagerUI.this.getHelpCtx().getHelpID());
            }
        });
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
        this.unitilialize();
    }

    public void close() {
        this.bClose.doClick();
    }

    private void initialize() {
        try {
            this.units = UpdateManager.getDefault().getUpdateUnits(Utilities.getUnitTypes());
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    PluginManagerUI.this.refreshUnits();
                    PluginManagerUI.this.setSelectedTab();
                }
            });
        }
        catch (InterruptedException interruptedException) {
            Exceptions.printStackTrace((Throwable)interruptedException);
        }
        catch (InvocationTargetException invocationTargetException) {
            Exceptions.printStackTrace((Throwable)invocationTargetException);
        }
    }

    private void unitilialize() {
        Utilities.startAsWorkerThread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                PluginManagerUI.this.initTask.waitFinished();
                AutoupdateCheckScheduler.runCheckAvailableUpdates(0);
                Object object = PluginManagerUI.this.initLock;
                synchronized (object) {
                    PluginManagerUI.this.units = null;
                    PluginManagerUI.this.installedTable = null;
                    PluginManagerUI.this.availableTable = null;
                    PluginManagerUI.this.updateTable = null;
                    PluginManagerUI.this.localTable = null;
                }
            }
        }, 10000);
    }

    void setProgressComponent(final JLabel jLabel, final JComponent jComponent) {
        if (SwingUtilities.isEventDispatchThread()) {
            this.setProgressComponentInAwt(jLabel, jComponent);
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    PluginManagerUI.this.setProgressComponentInAwt(jLabel, jComponent);
                }
            });
        }
    }

    private UnitTable createTabForModel(UnitCategoryTableModel unitCategoryTableModel) {
        UnitTable unitTable = new UnitTable(unitCategoryTableModel);
        this.selectFirstRow(unitTable);
        UnitTab unitTab = new UnitTab(unitTable, new UnitDetails(), this);
        this.tpTabs.add((Component)unitTab, unitCategoryTableModel.getTabIndex());
        this.decorateTabTitle(unitTable);
        return unitTable;
    }

    private void setProgressComponentInAwt(JLabel jLabel, JComponent jComponent) {
        assert (this.pProgress != null);
        assert (SwingUtilities.isEventDispatchThread()) : "Must be called in EQ.";
        jComponent.setMinimumSize(jComponent.getPreferredSize());
        this.pProgress.setVisible(true);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 0, 12);
        this.pProgress.add((Component)jComponent, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        this.pProgress.add((Component)jLabel, gridBagConstraints);
        this.revalidate();
    }

    void unsetProgressComponent(final JLabel jLabel, final JComponent jComponent) {
        if (SwingUtilities.isEventDispatchThread()) {
            this.unsetProgressComponentInAwt(jLabel, jComponent);
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    PluginManagerUI.this.unsetProgressComponentInAwt(jLabel, jComponent);
                }
            });
        }
    }

    private void setSelectedTab() {
        UnitTab unitTab;
        Component component;
        if (this.initialTabToSelect >= 0 && this.initialTabToSelect != this.tpTabs.getSelectedIndex() && this.initialTabToSelect < this.tpTabs.getComponentCount() && (component = this.tpTabs.getComponentAt(this.initialTabToSelect)) instanceof UnitTab && (unitTab = (UnitTab)component).getModel().isTabEnabled() && unitTab.getModel().canBePrimaryTab()) {
            this.tpTabs.setSelectedIndex(this.initialTabToSelect);
            this.initialTabToSelect = -1;
            return;
        }
        this.initialTabToSelect = -1;
        component = this.tpTabs.getSelectedComponent();
        if (component instanceof UnitTab && !(unitTab = (UnitTab)component).getModel().isTabEnabled()) {
            for (int i = 0; i < this.tpTabs.getComponentCount(); ++i) {
                component = this.tpTabs.getComponentAt(i);
                if (component instanceof UnitTab) {
                    unitTab = (UnitTab)component;
                    if (!unitTab.getModel().isTabEnabled() || !unitTab.getModel().canBePrimaryTab()) continue;
                    this.tpTabs.setSelectedIndex(i);
                    break;
                }
                this.tpTabs.setSelectedIndex(i);
                break;
            }
        }
    }

    private void unsetProgressComponentInAwt(JLabel jLabel, JComponent jComponent) {
        assert (this.pProgress != null);
        assert (SwingUtilities.isEventDispatchThread()) : "Must be called in EQ.";
        this.pProgress.remove(jLabel);
        this.pProgress.remove(jComponent);
        this.pProgress.setVisible(false);
        this.revalidate();
    }

    private void initComponents() {
        this.tpTabs = new JTabbedPane();
        this.pProgress = new JPanel();
        this.bClose = this.closeButton;
        this.bHelp = new JButton();
        this.tpTabs.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                PluginManagerUI.this.tpTabsStateChanged(changeEvent);
            }
        });
        this.pProgress.setLayout(new GridBagLayout());
        Mnemonics.setLocalizedText((AbstractButton)this.bClose, (String)NbBundle.getMessage(PluginManagerUI.class, (String)"UnitTab_bClose_Text"));
        Mnemonics.setLocalizedText((AbstractButton)this.bHelp, (String)NbBundle.getMessage(PluginManagerUI.class, (String)"PluginManagerUI.bHelp.text"));
        this.bHelp.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PluginManagerUI.this.bHelpActionPerformed(actionEvent);
            }
        });
        GroupLayout groupLayout = new GroupLayout(this);
        this.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, groupLayout.createSequentialGroup().addComponent(this.pProgress, -2, 562, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 157, Short.MAX_VALUE).addComponent(this.bClose).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.bHelp)).addComponent(this.tpTabs, -1, 864, Short.MAX_VALUE)).addContainerGap()));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addComponent(this.tpTabs, -1, 471, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.pProgress, -1, -1, Short.MAX_VALUE).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.bHelp).addComponent(this.bClose, -1, -1, Short.MAX_VALUE))).addContainerGap()));
        this.tpTabs.getAccessibleContext().setAccessibleName(NbBundle.getMessage(PluginManagerUI.class, (String)"ACN_Tabs"));
        this.tpTabs.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PluginManagerUI.class, (String)"ACD_Tabs"));
        this.getAccessibleContext().setAccessibleName(NbBundle.getMessage(PluginManagerUI.class, (String)"ACN_PluginManagerUI"));
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PluginManagerUI.class, (String)"ACD_PluginManagerUI"));
    }

    private void tpTabsStateChanged(ChangeEvent changeEvent) {
        Component component = ((JTabbedPane)changeEvent.getSource()).getSelectedComponent();
        if (component instanceof SettingsTab) {
            ((SettingsTab)component).getSettingsTableModel().refreshModel();
            this.wasSettings = true;
        } else {
            if (this.wasSettings) {
                final UnitCategoryTableModel unitCategoryTableModel = (UnitCategoryTableModel)this.availableTable.getModel();
                final Map<String, Boolean> map = UnitCategoryTableModel.captureState(unitCategoryTableModel.getUnits());
                ((SettingsTab)this.tpTabs.getComponentAt(4)).doLazyRefresh(new Runnable(){

                    @Override
                    public void run() {
                        UnitCategoryTableModel.restoreState(unitCategoryTableModel.getUnits(), map, false);
                    }
                });
            }
            this.wasSettings = false;
        }
    }

    private void bHelpActionPerformed(ActionEvent actionEvent) {
        try {
            Object object = this.getHelpInstance();
            if (object == null) {
                return;
            }
            Method method = object.getClass().getMethod("showHelp", HelpCtx.class);
            if (method != null) {
                method.invoke(object, this.getHelpCtx());
            }
        }
        catch (Exception exception) {
            Logger.getLogger(PluginManagerUI.class.getName()).log(Level.INFO, exception.getLocalizedMessage(), exception);
        }
    }

    private Object getHelpInstance() {
        if (this.helpInstance == null) {
            try {
                Class<?> clazz = Class.forName("org.netbeans.api.javahelp.Help", false, Thread.currentThread().getContextClassLoader());
                if (clazz == null) {
                    return null;
                }
                this.helpInstance = Lookup.getDefault().lookup(clazz);
            }
            catch (ClassNotFoundException classNotFoundException) {
                Logger.getLogger(PluginManagerUI.class.getName()).log(Level.FINE, "JavaHelp integration not found", classNotFoundException);
            }
        }
        return this.helpInstance;
    }

    private boolean isValidHelpID(String string) {
        boolean bl = true;
        try {
            Object object = this.getHelpInstance();
            if (object == null) {
                return bl;
            }
            Method method = object.getClass().getMethod("isValidID", String.class, Boolean.TYPE);
            if (method != null) {
                Object object2 = method.invoke(object, string, true);
                bl = object2 instanceof Boolean ? (Boolean)object2 : true;
            }
        }
        catch (Exception exception) {
            Logger.getLogger(PluginManagerUI.class.getName()).log(Level.INFO, exception.getLocalizedMessage(), exception);
        }
        return bl;
    }

    private HelpCtx getHelpCtx() {
        String string = PluginManagerUI.class.getName();
        Component component = this.tpTabs.getSelectedComponent();
        if (component instanceof UnitTab) {
            string = ((UnitTab)component).getHelpId();
        } else if (component instanceof SettingsTab) {
            string = SettingsTab.class.getName();
        }
        if (this.isValidHelpID(string)) {
            Logger.getLogger(PluginManagerUI.class.getName()).log(Level.FINE, "HelpId is " + string);
        } else {
            Logger.getLogger(PluginManagerUI.class.getName()).log(Level.INFO, string + " looks no valid HelpCtx. Is valid? " + this.isValidHelpID(string));
        }
        return new HelpCtx(string);
    }

    private void postInitComponents() {
        Containers.initNotify();
        this.updateTable = this.createTabForModel(new UpdateTableModel(this.units));
        this.availableTable = this.createTabForModel(new AvailableTableModel(this.units));
        this.localTable = this.createTabForModel(new LocallyDownloadedTableModel(new LocalDownloadSupport()));
        this.installedTable = this.createTabForModel(new InstalledTableModel(this.units));
        SettingsTab settingsTab = new SettingsTab(this);
        this.tpTabs.add((Component)settingsTab, 4);
        this.tpTabs.setTitleAt(4, settingsTab.getDisplayName());
        this.bHelp.setEnabled(this.getHelpInstance() != null);
    }

    void decorateTabTitle(UnitTable unitTable) {
        UnitCategoryTableModel unitCategoryTableModel = (UnitCategoryTableModel)unitTable.getModel();
        int n = unitCategoryTableModel.getTabIndex();
        this.tpTabs.setTitleAt(n, unitCategoryTableModel.getDecoratedTabTitle());
        this.tpTabs.setEnabledAt(n, unitCategoryTableModel.isTabEnabled());
        this.tpTabs.setToolTipTextAt(n, unitCategoryTableModel.getTabTooltipText());
    }

    void undecorateTabTitles() {
        this.tpTabs.setTitleAt(0, NbBundle.getMessage(PluginManagerUI.class, (String)"PluginManagerUI_UnitTab_Update_Title"));
        this.tpTabs.setTitleAt(1, NbBundle.getMessage(PluginManagerUI.class, (String)"PluginManagerUI_UnitTab_Available_Title"));
    }

    private int findRowWithFirstUnit(UnitCategoryTableModel unitCategoryTableModel) {
        for (int i = 0; i <= unitCategoryTableModel.getRowCount(); ++i) {
            if (unitCategoryTableModel.getUnitAtRow(i) == null) continue;
            return i;
        }
        return -1;
    }

    private void selectFirstRow(UnitTable unitTable) {
        UnitCategoryTableModel unitCategoryTableModel;
        int n;
        if (unitTable.getSelectedRow() == -1 && (n = this.findRowWithFirstUnit(unitCategoryTableModel = (UnitCategoryTableModel)unitTable.getModel())) != -1) {
            unitTable.getSelectionModel().setSelectionInterval(n, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void refreshUnits() {
        Object object = this.initLock;
        synchronized (object) {
            Component[] componentArray;
            if (this.units == null) {
                return;
            }
            this.units = UpdateManager.getDefault().getUpdateUnits(Utilities.getUnitTypes());
            InstalledTableModel installedTableModel = (InstalledTableModel)this.installedTable.getModel();
            UnitCategoryTableModel unitCategoryTableModel = (UnitCategoryTableModel)this.updateTable.getModel();
            UnitCategoryTableModel unitCategoryTableModel2 = (UnitCategoryTableModel)this.availableTable.getModel();
            LocallyDownloadedTableModel locallyDownloadedTableModel = (LocallyDownloadedTableModel)this.localTable.getModel();
            unitCategoryTableModel.setUnits(this.units);
            List list = UpdateManager.getDefault().getUpdateUnits(new UpdateManager.TYPE[]{UpdateManager.TYPE.FEATURE});
            if (this.isDetailView() && !list.isEmpty()) {
                installedTableModel.setUnits(this.units);
            } else {
                installedTableModel.setUnits(this.units, list);
            }
            unitCategoryTableModel2.setUnits(this.units);
            locallyDownloadedTableModel.setUnits(this.units);
            this.selectFirstRow(this.installedTable);
            this.selectFirstRow(this.updateTable);
            this.selectFirstRow(this.availableTable);
            this.selectFirstRow(this.localTable);
            this.decorateTabTitle(this.updateTable);
            this.decorateTabTitle(this.availableTable);
            this.decorateTabTitle(this.localTable);
            this.decorateTabTitle(this.installedTable);
            for (Component component : componentArray = this.tpTabs.getComponents()) {
                if (!(component instanceof UnitTab)) continue;
                UnitTab unitTab = (UnitTab)component;
                unitTab.refreshState();
            }
            this.setSelectedTab();
        }
    }

    static boolean canContinue(String string) {
        return NotifyDescriptor.YES_OPTION.equals(DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Confirmation((Object)string)));
    }

    public static void registerRunningTask(RequestProcessor.Task task) {
        assert (runningTask == null || runningTask.isFinished()) : "Only once task can be running. Already running : " + runningTask;
        runningTask = task;
    }

    public static void unregisterRunningTask() {
        runningTask = null;
    }

    public static RequestProcessor.Task getRunningTask() {
        return runningTask;
    }

    public void updateUnitsChanged() {
        this.refreshUnits();
    }

    public void tableStructureChanged() {
        this.installedTable.resortByDefault();
        ((UnitCategoryTableModel)this.installedTable.getModel()).fireTableStructureChanged();
        this.installedTable.setColumnsSize();
        this.installedTable.resetEnableRenderer();
        this.updateTable.resortByDefault();
        ((UnitCategoryTableModel)this.updateTable.getModel()).fireTableStructureChanged();
        this.updateTable.setColumnsSize();
        this.availableTable.resortByDefault();
        ((UnitCategoryTableModel)this.availableTable.getModel()).fireTableStructureChanged();
        this.availableTable.setColumnsSize();
    }

    public void buttonsChanged() {
        Component component = this.tpTabs.getSelectedComponent();
        if (component instanceof UnitTab) {
            ((UnitTab)component).refreshState();
        }
    }

    static {
        TAB_NAMES = new String[]{"update", "available", "local", "installed"};
    }
}

