/*
 * Decompiled with CFR 0.152.
 */
package org.openide.filesystems.annotations;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import javax.tools.Diagnostic;
import javax.tools.StandardLocation;
import org.openide.filesystems.annotations.LayerGenerationException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public final class LayerBuilder {
    private final Document doc;
    private final Element originatingElement;
    private final ProcessingEnvironment processingEnv;
    private final List<File> unwrittenFiles = new LinkedList<File>();

    LayerBuilder(Document document, Element element, ProcessingEnvironment processingEnvironment) {
        this.doc = document;
        this.originatingElement = element;
        this.processingEnv = processingEnvironment;
    }

    public File file(String string) {
        File file = new File(string, false);
        this.unwrittenFiles.add(file);
        return file;
    }

    public File folder(String string) {
        File file = new File(string, true);
        this.unwrittenFiles.add(file);
        return file;
    }

    void close() {
        for (File file : this.unwrittenFiles) {
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.WARNING, "layer file " + file.getPath() + " was never written");
        }
        this.unwrittenFiles.clear();
    }

    public File instanceFile(String string, String string2, Class clazz) throws IllegalArgumentException, LayerGenerationException {
        String string3;
        String[] stringArray = this.instantiableClassOrMethod(clazz);
        String string4 = stringArray[0];
        String string5 = stringArray[1];
        if (string2 == null) {
            string3 = string4.replace('.', '-');
            if (string5 != null) {
                string3 = string3 + "-" + string5;
            }
        } else {
            string3 = string2;
        }
        File file = this.file(string + "/" + string3 + ".instance");
        if (string5 != null) {
            file.methodvalue("instanceCreate", string4, string5);
        } else if (string2 != null) {
            file.stringvalue("instanceClass", string4);
        }
        return file;
    }

    public File instanceFile(String string, String string2) throws IllegalArgumentException, LayerGenerationException {
        String string3;
        String[] stringArray = this.instantiableClassOrMethod(null);
        String string4 = stringArray[0];
        String string5 = stringArray[1];
        if (string2 == null) {
            string3 = string4.replace('.', '-');
            if (string5 != null) {
                string3 = string3 + "-" + string5;
            }
        } else {
            string3 = string2;
        }
        return this.file(string + "/" + string3 + ".instance");
    }

    private String[] instantiableClassOrMethod(Class clazz) throws IllegalArgumentException, LayerGenerationException {
        if (this.originatingElement == null) {
            throw new IllegalArgumentException("Only applicable to builders with exactly one associated element");
        }
        DeclaredType declaredType = clazz != null ? this.processingEnv.getTypeUtils().getDeclaredType(this.processingEnv.getElementUtils().getTypeElement(clazz.getName().replace('$', '.')), new TypeMirror[0]) : null;
        switch (this.originatingElement.getKind()) {
            case CLASS: {
                String string = this.processingEnv.getElementUtils().getBinaryName((TypeElement)this.originatingElement).toString();
                if (this.originatingElement.getModifiers().contains((Object)Modifier.ABSTRACT)) {
                    throw new LayerGenerationException(string + " must not be abstract", this.originatingElement);
                }
                boolean bl = false;
                for (ExecutableElement executableElement : ElementFilter.constructorsIn(this.originatingElement.getEnclosedElements())) {
                    if (!executableElement.getParameters().isEmpty()) continue;
                    bl = true;
                    break;
                }
                if (!bl) {
                    throw new LayerGenerationException(string + " must have a no-argument constructor", this.originatingElement);
                }
                if (declaredType != null && !this.processingEnv.getTypeUtils().isAssignable(this.originatingElement.asType(), declaredType)) {
                    throw new LayerGenerationException(string + " is not assignable to " + declaredType, this.originatingElement);
                }
                if (!this.originatingElement.getModifiers().contains((Object)Modifier.PUBLIC)) {
                    throw new LayerGenerationException(string + " is not public", this.originatingElement);
                }
                return new String[]{string, null};
            }
            case METHOD: {
                String string = this.processingEnv.getElementUtils().getBinaryName((TypeElement)this.originatingElement.getEnclosingElement()).toString();
                String string2 = this.originatingElement.getSimpleName().toString();
                if (!this.originatingElement.getModifiers().contains((Object)Modifier.STATIC)) {
                    throw new LayerGenerationException(string + "." + string2 + " must be static", this.originatingElement);
                }
                if (!((ExecutableElement)this.originatingElement).getParameters().isEmpty()) {
                    throw new LayerGenerationException(string + "." + string2 + " must not take arguments", this.originatingElement);
                }
                if (declaredType != null && !this.processingEnv.getTypeUtils().isAssignable(((ExecutableElement)this.originatingElement).getReturnType(), declaredType)) {
                    throw new LayerGenerationException(string + "." + string2 + " is not assignable to " + declaredType, this.originatingElement);
                }
                return new String[]{string, string2};
            }
        }
        throw new IllegalArgumentException("Annotated element is not loadable as an instance: " + this.originatingElement);
    }

    public File shadowFile(String string, String string2, String string3) {
        if (string3 == null) {
            string3 = string.replaceFirst("^.+/", "").replaceFirst("\\.[^./]+$", "");
        }
        return this.file(string2 + "/" + string3 + ".shadow").stringvalue("originalFile", string);
    }

    public final class File {
        private final String path;
        private final boolean folder;
        private final Map<String, String[]> attrs = new LinkedHashMap<String, String[]>();
        private String contents;
        private String url;

        File(String string, boolean bl) {
            this.path = string;
            this.folder = bl;
        }

        public String getPath() {
            return this.path;
        }

        public File contents(String string) {
            if (this.contents != null || this.url != null || string == null || this.folder) {
                throw new IllegalArgumentException();
            }
            this.contents = string;
            return this;
        }

        public File url(String string) {
            if (this.contents != null || this.url != null || string == null || this.folder) {
                throw new IllegalArgumentException();
            }
            this.url = string;
            return this;
        }

        public File stringvalue(String string, String string2) {
            this.attrs.put(string, new String[]{"stringvalue", string2});
            return this;
        }

        public File bytevalue(String string, byte by) {
            this.attrs.put(string, new String[]{"bytevalue", Byte.toString(by)});
            return this;
        }

        public File shortvalue(String string, short s) {
            this.attrs.put(string, new String[]{"shortvalue", Short.toString(s)});
            return this;
        }

        public File intvalue(String string, int n) {
            this.attrs.put(string, new String[]{"intvalue", Integer.toString(n)});
            return this;
        }

        public File longvalue(String string, long l) {
            this.attrs.put(string, new String[]{"longvalue", Long.toString(l)});
            return this;
        }

        public File floatvalue(String string, float f) {
            this.attrs.put(string, new String[]{"floatvalue", Float.toString(f)});
            return this;
        }

        public File doublevalue(String string, double d) {
            this.attrs.put(string, new String[]{"doublevalue", Double.toString(d)});
            return this;
        }

        public File boolvalue(String string, boolean bl) {
            this.attrs.put(string, new String[]{"boolvalue", Boolean.toString(bl)});
            return this;
        }

        public File charvalue(String string, char c) {
            this.attrs.put(string, new String[]{"charvalue", Character.toString(c)});
            return this;
        }

        public File urlvalue(String string, URI uRI) throws LayerGenerationException {
            if (uRI.isOpaque()) {
                throw new LayerGenerationException("Cannot use an opaque URI: " + uRI, LayerBuilder.this.originatingElement);
            }
            this.attrs.put(string, new String[]{"urlvalue", uRI.toString()});
            return this;
        }

        public File urlvalue(String string, String string2) throws LayerGenerationException {
            try {
                return this.urlvalue(string, URI.create(string2));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new LayerGenerationException(illegalArgumentException.getLocalizedMessage(), LayerBuilder.this.originatingElement);
            }
        }

        public File methodvalue(String string, String string2, String string3) {
            this.attrs.put(string, new String[]{"methodvalue", string2 + "." + string3});
            return this;
        }

        public File newvalue(String string, String string2) {
            this.attrs.put(string, new String[]{"newvalue", string2});
            return this;
        }

        public File instanceAttribute(String string, Class clazz) throws IllegalArgumentException, LayerGenerationException {
            String[] stringArray = LayerBuilder.this.instantiableClassOrMethod(clazz);
            if (stringArray[1] == null) {
                this.newvalue(string, stringArray[0]);
            } else {
                this.methodvalue(string, stringArray[0], stringArray[1]);
            }
            return this;
        }

        public File bundlevalue(String string, String string2, String string3) {
            this.attrs.put(string, new String[]{"bundlevalue", string2 + "#" + string3});
            return this;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public File bundlevalue(String string, String string2) throws LayerGenerationException {
            String string3 = "(?:\\p{javaJavaIdentifierStart}\\p{javaJavaIdentifierPart}*)";
            Matcher matcher = Pattern.compile("((?:" + string3 + "\\.)+[^\\s.#]+)?#(\\S+)").matcher(string2);
            if (matcher.matches()) {
                Object object;
                String string4 = matcher.group(1);
                String string5 = matcher.group(2);
                if (string4 == null) {
                    for (object = LayerBuilder.this.originatingElement; object != null && object.getKind() != ElementKind.PACKAGE; object = object.getEnclosingElement()) {
                    }
                    if (object == null) {
                        throw new LayerGenerationException("No reference element to determine package in '" + string2 + "'", LayerBuilder.this.originatingElement);
                    }
                    string4 = ((PackageElement)object).getQualifiedName() + ".Bundle";
                }
                if (LayerBuilder.this.processingEnv != null) {
                    object = string4.replace('.', '/') + ".properties";
                    try {
                        InputStream inputStream;
                        try {
                            inputStream = LayerBuilder.this.processingEnv.getFiler().getResource(StandardLocation.SOURCE_PATH, "", (CharSequence)object).openInputStream();
                        }
                        catch (FileNotFoundException fileNotFoundException) {
                            try {
                                inputStream = LayerBuilder.this.processingEnv.getFiler().getResource(StandardLocation.CLASS_OUTPUT, "", (CharSequence)object).openInputStream();
                            }
                            catch (IOException iOException) {
                                throw fileNotFoundException;
                            }
                        }
                        try {
                            Properties properties = new Properties();
                            properties.load(inputStream);
                            if (properties.getProperty(string5) == null) {
                                throw new LayerGenerationException("No key '" + string5 + "' found in " + (String)object, LayerBuilder.this.originatingElement);
                            }
                        }
                        finally {
                            inputStream.close();
                        }
                    }
                    catch (IOException iOException) {
                        throw new LayerGenerationException("Could not open " + (String)object + ": " + iOException, LayerBuilder.this.originatingElement);
                    }
                }
                this.bundlevalue(string, string4, string5);
            } else {
                this.stringvalue(string, string2);
            }
            return this;
        }

        public File serialvalue(String string, byte[] byArray) {
            StringBuilder stringBuilder = new StringBuilder(byArray.length * 2);
            for (int n : byArray) {
                if (n >= 0 && n < 16) {
                    stringBuilder.append('0');
                }
                stringBuilder.append(Integer.toHexString(n < 0 ? n + 256 : n));
            }
            this.attrs.put(string, new String[]{"serialvalue", stringBuilder.toString().toUpperCase(Locale.ENGLISH)});
            return this;
        }

        public File position(int n) {
            if (n != Integer.MAX_VALUE) {
                this.intvalue("position", n);
            }
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public LayerBuilder write() {
            void var4_8;
            Object object;
            LayerBuilder.this.unwrittenFiles.remove(this);
            org.w3c.dom.Element element = LayerBuilder.this.doc.getDocumentElement();
            String[] stringArray = this.path.split("/");
            for (String object22 : Arrays.asList(stringArray).subList(0, stringArray.length - 1)) {
                object = this.find(element, object22, "file|folder");
                if (object != null) {
                    if (!object.getNodeName().equals("folder")) {
                        throw new IllegalArgumentException(this.path);
                    }
                    element = object;
                    continue;
                }
                element = (org.w3c.dom.Element)element.appendChild(LayerBuilder.this.doc.createElement("folder"));
                element.setAttribute("name", object22);
            }
            String string = stringArray[stringArray.length - 1];
            org.w3c.dom.Element element2 = this.find(element, string, "file|folder");
            if (this.folder) {
                if (element2 == null) {
                    org.w3c.dom.Element element3 = (org.w3c.dom.Element)element.appendChild(LayerBuilder.this.doc.createElement("folder"));
                }
            } else {
                if (element2 != null) {
                    element.removeChild(element2);
                }
                org.w3c.dom.Element element4 = (org.w3c.dom.Element)element.appendChild(LayerBuilder.this.doc.createElement("file"));
            }
            var4_8.setAttribute("name", string);
            object = var4_8.getChildNodes();
            int n = 0;
            while (n < object.getLength()) {
                Map.Entry<String, String[]> entry = object.item(n);
                if (entry.getNodeType() == 8) {
                    var4_8.removeChild((Node)((Object)entry));
                    continue;
                }
                ++n;
            }
            if (LayerBuilder.this.originatingElement != null) {
                String string2;
                switch (LayerBuilder.this.originatingElement.getKind()) {
                    case METHOD: 
                    case CONSTRUCTOR: 
                    case ENUM_CONSTANT: 
                    case FIELD: 
                    case INSTANCE_INIT: 
                    case STATIC_INIT: {
                        string2 = LayerBuilder.this.originatingElement.getEnclosingElement() + "." + LayerBuilder.this.originatingElement;
                        break;
                    }
                    default: {
                        string2 = LayerBuilder.this.originatingElement.toString();
                    }
                }
                var4_8.appendChild(LayerBuilder.this.doc.createComment(string2));
            }
            for (Map.Entry<String, String[]> entry : this.attrs.entrySet()) {
                org.w3c.dom.Element element5 = this.find((org.w3c.dom.Element)var4_8, (String)entry.getKey(), "attr");
                if (element5 != null) {
                    var4_8.removeChild(element5);
                }
                org.w3c.dom.Element element6 = (org.w3c.dom.Element)var4_8.appendChild(LayerBuilder.this.doc.createElement("attr"));
                element6.setAttribute("name", (String)entry.getKey());
                element6.setAttribute(((String[])entry.getValue())[0], ((String[])entry.getValue())[1]);
            }
            if (this.url != null) {
                var4_8.setAttribute("url", this.url);
            } else if (this.contents != null) {
                var4_8.appendChild(LayerBuilder.this.doc.createCDATASection(this.contents));
            }
            return LayerBuilder.this;
        }

        private org.w3c.dom.Element find(org.w3c.dom.Element element, String string, String string2) {
            NodeList nodeList = element.getChildNodes();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                org.w3c.dom.Element element2;
                Node node = nodeList.item(i);
                if (node.getNodeType() != 1 || !(element2 = (org.w3c.dom.Element)node).getAttribute("name").equals(string) || !element2.getNodeName().matches(string2)) continue;
                return element2;
            }
            return null;
        }
    }
}

