/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.ui.components;

import java.awt.Component;
import java.awt.event.ItemEvent;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.JSeparator;
import javax.swing.SwingUtilities;

public class JExtendedComboBox
extends JComboBox {
    private DefaultComboBoxModel model = new DefaultComboBoxModel();
    private boolean closingWithSeparator = false;
    private int lastSelectedIndex = 0;

    public JExtendedComboBox() {
        this.setModel((ComboBoxModel)this.model);
        this.setRenderer(new ExtendedComboListRenderer());
    }

    public void setModel(ComboBoxModel comboBoxModel) {
        if (!(comboBoxModel instanceof DefaultComboBoxModel)) {
            throw new RuntimeException("Only DefaultComboBoxModel is supported for this component");
        }
        this.model = (DefaultComboBoxModel)comboBoxModel;
        super.setModel(this.model);
    }

    @Override
    public void firePopupMenuWillBecomeInvisible() {
        if (this.getSelectedItem() instanceof JSeparator) {
            this.closingWithSeparator = true;
        }
        super.firePopupMenuWillBecomeInvisible();
    }

    @Override
    protected void fireItemStateChanged(ItemEvent itemEvent) {
        switch (itemEvent.getStateChange()) {
            case 1: {
                if (!(itemEvent.getItem() instanceof JSeparator)) break;
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        JExtendedComboBox.this.selectNextItem();
                    }
                });
                break;
            }
            case 2: {
                if (itemEvent.getItem() instanceof JSeparator) break;
                this.lastSelectedIndex = this.model.getIndexOf(itemEvent.getItem());
            }
        }
        super.fireItemStateChanged(itemEvent);
    }

    private void selectNextItem() {
        int n = this.getSelectedIndex();
        if (this.closingWithSeparator) {
            this.setSelectedIndex(this.lastSelectedIndex);
            this.closingWithSeparator = false;
        } else if (n > this.lastSelectedIndex) {
            this.setSelectedIndex(n + 1);
        } else {
            this.setSelectedIndex(n - 1);
        }
    }

    private class ExtendedComboListRenderer
    extends DefaultListCellRenderer {
        private ExtendedComboListRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            if (object != null && object instanceof JSeparator) {
                return (JSeparator)object;
            }
            return super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
        }
    }
}

