/*
 * Decompiled with CFR 0.152.
 */
package org.openide;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FocusTraversalPolicy;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.MediaTracker;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Collections;
import java.util.EventListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.WizardValidationException;
import org.openide.awt.HtmlBrowser;
import org.openide.awt.Mnemonics;
import org.openide.util.Exceptions;
import org.openide.util.HelpCtx;
import org.openide.util.ImageUtilities;
import org.openide.util.Mutex;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.Utilities;
import org.openide.util.WeakListeners;

public class WizardDescriptor
extends DialogDescriptor {
    public static final Object NEXT_OPTION = new String("NEXT_OPTION");
    public static final Object FINISH_OPTION = OK_OPTION;
    public static final Object PREVIOUS_OPTION = new String("PREVIOUS_OPTION");
    private static final ActionListener CLOSE_PREVENTER = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
        }

        public String toString() {
            return "CLOSE_PREVENTER";
        }
    };
    public static final String PROP_AUTO_WIZARD_STYLE = "WizardPanel_autoWizardStyle";
    public static final String PROP_HELP_DISPLAYED = "WizardPanel_helpDisplayed";
    public static final String PROP_CONTENT_DISPLAYED = "WizardPanel_contentDisplayed";
    public static final String PROP_CONTENT_NUMBERED = "WizardPanel_contentNumbered";
    public static final String PROP_CONTENT_SELECTED_INDEX = "WizardPanel_contentSelectedIndex";
    public static final String PROP_CONTENT_DATA = "WizardPanel_contentData";
    public static final String PROP_CONTENT_BACK_COLOR = "WizardPanel_contentBackColor";
    public static final String PROP_CONTENT_FOREGROUND_COLOR = "WizardPanel_contentForegroundColor";
    public static final String PROP_IMAGE = "WizardPanel_image";
    public static final String PROP_IMAGE_ALIGNMENT = "WizardPanel_imageAlignment";
    public static final String PROP_LEFT_DIMENSION = "WizardPanel_leftDimension";
    public static final String PROP_HELP_URL = "WizardPanel_helpURL";
    public static final String PROP_ERROR_MESSAGE = "WizardPanel_errorMessage";
    public static final String PROP_WARNING_MESSAGE = "WizardPanel_warningMessage";
    public static final String PROP_INFO_MESSAGE = "WizardPanel_infoMessage";
    private static Logger err = Logger.getLogger(WizardDescriptor.class.getName());
    private final JButton nextButton = new JButton();
    private final JButton finishButton = new JButton();
    private final JButton cancelButton = new JButton();
    private final JButton previousButton = new JButton();
    private FinishAction finishOption;
    private Set newObjects = Collections.EMPTY_SET;
    private Component waitingComponent;
    private boolean changeStateInProgress = false;
    private boolean currentPanelWasChangedWhileStoreSettings = false;
    private boolean autoWizardStyle = false;
    private boolean init = false;
    private WizardPanel wizardPanel;
    private Image image;
    private String[] contentData = new String[0];
    private int contentSelectedIndex = -1;
    private Color contentBackColor;
    private Color contentForegroundColor;
    private URL helpURL;
    private PropL propListener;
    private String imageAlignment = "North";
    private SettingsAndIterator<?> data;
    private ChangeListener weakChangeListener;
    private PropertyChangeListener weakPropertyChangeListener;
    private ActionListener weakNextButtonListener;
    private ActionListener weakPreviousButtonListener;
    private ActionListener weakFinishButtonListener;
    private ActionListener weakCancelButtonListener;
    private Listener baseListener;
    private MessageFormat titleFormat;
    private Map<String, Object> properties;
    ResourceBundle bundle = NbBundle.getBundle(WizardDescriptor.class);
    static final RequestProcessor ASYNCHRONOUS_JOBS_RP = new RequestProcessor("wizard-descriptor-asynchronous-jobs", 1, true);
    private RequestProcessor.Task backgroundValidationTask;
    private boolean validationRuns;
    private ProgressHandle handle;
    private static final String PROGRESS_BAR_DISPLAY_NAME = NbBundle.getMessage(WizardDescriptor.class, (String)"CTL_InstantiateProgress_Title");
    private ActionListener escapeActionListener;
    private static final Set<String> logged = new HashSet<String>();

    public <Data> WizardDescriptor(Panel<Data>[] panelArray, Data Data) {
        this(new SettingsAndIterator<Data>(new ArrayIterator<Data>(panelArray), Data));
    }

    public WizardDescriptor(Panel<WizardDescriptor>[] panelArray) {
        this(SettingsAndIterator.create(new ArrayIterator<WizardDescriptor>(panelArray)));
    }

    public <Data> WizardDescriptor(Iterator<Data> iterator, Data Data) {
        this(new SettingsAndIterator<Data>(iterator, Data));
    }

    protected WizardDescriptor() {
        this(SettingsAndIterator.empty());
    }

    private <Data> WizardDescriptor(SettingsAndIterator<Data> settingsAndIterator) {
        super((Object)"", "", true, -1, null, CLOSE_PREVENTER);
        ResourceBundle resourceBundle = NbBundle.getBundle((String)"org.openide.Bundle");
        Mnemonics.setLocalizedText((AbstractButton)this.nextButton, (String)resourceBundle.getString("CTL_NEXT"));
        Mnemonics.setLocalizedText((AbstractButton)this.previousButton, (String)resourceBundle.getString("CTL_PREVIOUS"));
        Mnemonics.setLocalizedText((AbstractButton)this.finishButton, (String)resourceBundle.getString("CTL_FINISH"));
        this.finishButton.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("ACSD_FINISH"));
        Mnemonics.setLocalizedText((AbstractButton)this.cancelButton, (String)resourceBundle.getString("CTL_CANCEL"));
        this.cancelButton.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("ACSD_CANCEL"));
        this.finishButton.setDefaultCapable(true);
        this.nextButton.setDefaultCapable(true);
        this.previousButton.setDefaultCapable(false);
        this.cancelButton.setDefaultCapable(false);
        this.data = settingsAndIterator;
        this.baseListener = new Listener();
        this.weakNextButtonListener = (ActionListener)WeakListeners.create(ActionListener.class, (EventListener)this.baseListener, (Object)this.nextButton);
        this.weakPreviousButtonListener = (ActionListener)WeakListeners.create(ActionListener.class, (EventListener)this.baseListener, (Object)this.previousButton);
        this.weakFinishButtonListener = (ActionListener)WeakListeners.create(ActionListener.class, (EventListener)this.baseListener, (Object)this.finishButton);
        this.weakCancelButtonListener = (ActionListener)WeakListeners.create(ActionListener.class, (EventListener)this.baseListener, (Object)this.cancelButton);
        this.nextButton.addActionListener(this.weakNextButtonListener);
        this.previousButton.addActionListener(this.weakPreviousButtonListener);
        this.finishButton.addActionListener(this.weakFinishButtonListener);
        this.cancelButton.addActionListener(this.weakCancelButtonListener);
        this.finishOption = new FinishAction();
        super.setOptions(new Object[]{this.previousButton, this.nextButton, this.finishButton, this.cancelButton});
        super.setClosingOptions(new Object[]{this.finishOption, this.cancelButton});
        this.createNotificationLineSupport();
        this.weakChangeListener = WeakListeners.change((ChangeListener)this.baseListener, settingsAndIterator.getIterator(this));
        settingsAndIterator.getIterator(this).addChangeListener(this.weakChangeListener);
        this.callInitialize();
    }

    public WizardDescriptor(Iterator<WizardDescriptor> iterator) {
        this(SettingsAndIterator.create(iterator));
    }

    @Override
    protected void initialize() {
        super.initialize();
        this.updateState();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                final Window window = SwingUtilities.getWindowAncestor((Component)WizardDescriptor.this.getMessage());
                if (window != null) {
                    window.addWindowListener(new WindowListener(){

                        @Override
                        public void windowActivated(WindowEvent windowEvent) {
                        }

                        @Override
                        public void windowClosed(WindowEvent windowEvent) {
                        }

                        @Override
                        public void windowClosing(WindowEvent windowEvent) {
                            if (!WizardDescriptor.this.changeStateInProgress) {
                                if (WizardDescriptor.this.getValue() == null || NEXT_OPTION.equals(WizardDescriptor.this.getValue())) {
                                    WizardDescriptor.this.setValue(NotifyDescriptor.CLOSED_OPTION);
                                }
                                window.setVisible(false);
                                window.dispose();
                            }
                        }

                        @Override
                        public void windowDeactivated(WindowEvent windowEvent) {
                        }

                        @Override
                        public void windowDeiconified(WindowEvent windowEvent) {
                        }

                        @Override
                        public void windowIconified(WindowEvent windowEvent) {
                        }

                        @Override
                        public void windowOpened(WindowEvent windowEvent) {
                        }
                    });
                }
            }
        });
        this.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if ("valid".equals(propertyChangeEvent.getPropertyName())) {
                    if (!WizardDescriptor.this.isValid()) {
                        WizardDescriptor.this.nextButton.setEnabled(false);
                        WizardDescriptor.this.finishButton.setEnabled(false);
                    } else {
                        WizardDescriptor.this.updateState();
                    }
                }
            }
        });
    }

    @Deprecated
    public final synchronized void setPanels(Iterator iterator) {
        if (this.data.getIterator(this) != null) {
            this.data.getIterator(this).removeChangeListener(this.weakChangeListener);
        }
        this.data = this.data.clone(iterator);
        this.weakChangeListener = WeakListeners.change((ChangeListener)this.baseListener, this.data.getIterator(this));
        this.data.getIterator(this).addChangeListener(this.weakChangeListener);
        this.init = false;
        this.updateState();
    }

    public final synchronized <Data> void setPanelsAndSettings(Iterator<Data> iterator, Data Data) {
        if (this.data.getIterator(this) != null) {
            this.data.getIterator(this).removeChangeListener(this.weakChangeListener);
        }
        this.data = new SettingsAndIterator<Data>(iterator, Data);
        this.weakChangeListener = WeakListeners.change((ChangeListener)this.baseListener, this.data.getIterator(this));
        this.data.getIterator(this).addChangeListener(this.weakChangeListener);
        this.init = false;
        this.updateState();
    }

    @Override
    public void setOptions(Object[] objectArray) {
        super.setOptions(this.convertOptions(objectArray));
    }

    @Override
    public void setAdditionalOptions(Object[] objectArray) {
        super.setAdditionalOptions(this.convertOptions(objectArray));
    }

    @Override
    public void setClosingOptions(Object[] objectArray) {
        super.setClosingOptions(this.convertOptions(objectArray));
    }

    private Object[] convertOptions(Object[] objectArray) {
        Object[] objectArray2 = (Object[])objectArray.clone();
        for (int i = objectArray2.length - 1; i >= 0; --i) {
            if (objectArray2[i] == NEXT_OPTION) {
                objectArray2[i] = this.nextButton;
            }
            if (objectArray2[i] == PREVIOUS_OPTION) {
                objectArray2[i] = this.previousButton;
            }
            if (objectArray2[i] == FINISH_OPTION) {
                objectArray2[i] = this.finishButton;
            }
            if (objectArray2[i] != CANCEL_OPTION) continue;
            objectArray2[i] = this.cancelButton;
        }
        return objectArray2;
    }

    @Override
    public Object getValue() {
        return this.backConvertOption(super.getValue());
    }

    private Object backConvertOption(Object object) {
        if (object == this.nextButton) {
            return NEXT_OPTION;
        }
        if (object == this.previousButton) {
            return PREVIOUS_OPTION;
        }
        if (object == this.finishButton) {
            return FINISH_OPTION;
        }
        if (object == this.cancelButton) {
            return CANCEL_OPTION;
        }
        return object;
    }

    public void setTitleFormat(MessageFormat messageFormat) {
        this.titleFormat = messageFormat;
        if (this.init) {
            this.updateState();
        }
    }

    public synchronized MessageFormat getTitleFormat() {
        if (this.titleFormat == null) {
            this.titleFormat = new MessageFormat(NbBundle.getMessage(WizardDescriptor.class, (String)"CTL_WizardName"));
        }
        return this.titleFormat;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putProperty(final String string, final Object object) {
        Object object2;
        WizardDescriptor wizardDescriptor = this;
        synchronized (wizardDescriptor) {
            if (this.properties == null) {
                this.properties = new HashMap<String, Object>(7);
            }
            object2 = this.properties.get(string);
            this.properties.put(string, object);
        }
        this.firePropertyChange(string, object2, object);
        if (this.propListener != null) {
            Mutex.EVENT.readAccess(new Runnable(){

                @Override
                public void run() {
                    WizardDescriptor.this.propListener.propertyChange(new PropertyChangeEvent(this, string, null, null));
                }
            });
        }
        if (PROP_ERROR_MESSAGE.equals(string)) {
            if (this.init && OK_OPTION.equals(this.getValue())) {
                return;
            }
            if (this.wizardPanel != null) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        if (WizardDescriptor.this.nextButton.isEnabled() || WizardDescriptor.this.finishButton.isEnabled()) {
                            WizardDescriptor.this.wizardPanel.setMessage(2, (String)(object == null ? "" : object));
                        } else {
                            WizardDescriptor.this.wizardPanel.setMessage(1, (String)(object == null ? "" : object));
                        }
                    }
                });
            }
        }
        if ((PROP_WARNING_MESSAGE.equals(string) || PROP_INFO_MESSAGE.equals(string)) && this.wizardPanel != null) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (WizardDescriptor.PROP_WARNING_MESSAGE.equals(string)) {
                        WizardDescriptor.this.wizardPanel.setMessage(2, (String)(object == null ? "" : object));
                    } else {
                        WizardDescriptor.this.wizardPanel.setMessage(3, (String)(object == null ? "" : object));
                    }
                }
            });
        }
    }

    public synchronized Object getProperty(String string) {
        return this.properties == null ? null : this.properties.get(string);
    }

    public synchronized Map<String, Object> getProperties() {
        return this.properties == null ? Collections.emptyMap() : new HashMap<String, Object>(this.properties);
    }

    @Override
    public void setHelpCtx(HelpCtx helpCtx) {
        if (this.wizardPanel != null && helpCtx != null) {
            HelpCtx.setHelpIDString((JComponent)this.wizardPanel, (String)helpCtx.getHelpID());
        }
        super.setHelpCtx(helpCtx);
    }

    public Set getInstantiatedObjects() {
        if (!FINISH_OPTION.equals(this.getValue())) {
            throw new IllegalStateException();
        }
        return this.newObjects;
    }

    @Override
    void clearMessages() {
        this.putProperty(PROP_ERROR_MESSAGE, null);
    }

    @Override
    void setErrorMessage(String string) {
        this.putProperty(PROP_ERROR_MESSAGE, string);
    }

    @Override
    void setInformationMessage(String string) {
        this.putProperty(PROP_INFO_MESSAGE, string);
    }

    @Override
    void setWarningMessage(String string) {
        this.putProperty(PROP_WARNING_MESSAGE, string);
    }

    protected synchronized void updateState() {
        if (SwingUtilities.isEventDispatchThread()) {
            this.updateStateOpen(this.data);
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    WizardDescriptor.this.updateStateOpen(WizardDescriptor.this.data);
                }
            });
        }
    }

    private static void checkComponent(Panel<?> panel) {
        String string = panel.getClass().getName();
        if (panel instanceof Component && logged.add(string)) {
            Logger.getLogger(WizardDescriptor.class.getName()).warning(string + " is both a " + "WizardDescriptor.Panel and a Component.  This is illegal " + "because Component.isValid() conflicts with " + "Panel.isValid().  See umbrella issue 154624 and " + "issues 150223, 134601, 99680 and " + "many others for why this is a Bad Thing.");
        }
    }

    private <A> void updateStateOpen(SettingsAndIterator<A> settingsAndIterator) {
        Object object;
        Panel<A> panel = settingsAndIterator.getIterator(this).current();
        WizardDescriptor.checkComponent(panel);
        if (((SettingsAndIterator)settingsAndIterator).current != panel) {
            if (((SettingsAndIterator)settingsAndIterator).current != null) {
                ((SettingsAndIterator)settingsAndIterator).current.removeChangeListener(this.weakChangeListener);
                ((SettingsAndIterator)settingsAndIterator).current.storeSettings(settingsAndIterator.getSettings(this));
            }
            panel = settingsAndIterator.getIterator(this).current();
            WizardDescriptor.checkComponent(panel);
            settingsAndIterator.getIterator(this).removeChangeListener(this.weakChangeListener);
            this.weakChangeListener = WeakListeners.change((ChangeListener)this.baseListener, panel);
            settingsAndIterator.getIterator(this).addChangeListener(this.weakChangeListener);
            panel.addChangeListener(this.weakChangeListener);
            ((SettingsAndIterator)settingsAndIterator).current = panel;
            panel.readSettings(settingsAndIterator.getSettings(this));
        }
        boolean bl = settingsAndIterator.getIterator(this).hasNext();
        boolean bl2 = settingsAndIterator.getIterator(this).hasPrevious();
        boolean bl3 = panel.isValid() && !this.validationRuns;
        this.nextButton.setEnabled(bl && bl3);
        this.previousButton.setEnabled(bl2);
        this.cancelButton.setEnabled(true);
        if (((SettingsAndIterator)settingsAndIterator).current instanceof FinishablePanel) {
            if (((FinishablePanel)((SettingsAndIterator)settingsAndIterator).current).isFinishPanel()) {
                this.finishButton.setEnabled(bl3);
            } else {
                this.finishButton.setEnabled(bl3 && !bl);
            }
        } else {
            this.finishButton.setEnabled(bl3 && (!bl || ((SettingsAndIterator)settingsAndIterator).current instanceof FinishPanel));
        }
        this.setHelpCtx(panel.getHelp());
        assert (SwingUtilities.isEventDispatchThread()) : "getComponent() must be called in EQ only.";
        Component component = panel.getComponent();
        if (component == null || component instanceof Window) {
            throw new IllegalStateException("Wizard panel " + panel + " gave a strange component " + component);
        }
        if (!this.init) {
            if (component instanceof JComponent) {
                this.autoWizardStyle = this.getBooleanProperty((JComponent)component, PROP_AUTO_WIZARD_STYLE);
                if (this.autoWizardStyle) {
                    this.wizardPanel = new WizardPanel(this.getBooleanProperty((JComponent)component, PROP_CONTENT_DISPLAYED), this.getBooleanProperty((JComponent)component, PROP_HELP_DISPLAYED), this.getBooleanProperty((JComponent)component, PROP_CONTENT_NUMBERED), this.getLeftDimension((JComponent)component));
                    this.initBundleProperties();
                }
            }
            if (this.propListener == null) {
                this.propListener = new PropL();
            }
            this.init = true;
        }
        if (this.wizardPanel != null) {
            object = this.wizardPanel.getRightComponent();
            if (object != null) {
                ((Component)object).removePropertyChangeListener(this.weakPropertyChangeListener);
            }
            if (component instanceof JComponent) {
                this.setPanelProperties((JComponent)component);
                this.wizardPanel.setContent(this.contentData);
                this.wizardPanel.setSelectedIndex(this.contentSelectedIndex);
                this.wizardPanel.setContentBackColor(this.contentBackColor);
                this.wizardPanel.setContentForegroundColor(this.contentForegroundColor);
                this.wizardPanel.setImage(this.image);
                this.wizardPanel.setImageAlignment(this.imageAlignment);
                this.wizardPanel.setHelpURL(this.helpURL);
                this.updateButtonAccessibleDescription();
                this.weakPropertyChangeListener = WeakListeners.propertyChange((PropertyChangeListener)this.propListener, (Object)component);
                component.addPropertyChangeListener(this.weakPropertyChangeListener);
            }
            if (this.wizardPanel.getRightComponent() != component) {
                this.wizardPanel.setRightComponent(component);
                if (this.wizardPanel != this.getMessage()) {
                    this.setMessage(this.wizardPanel);
                } else {
                    this.firePropertyChange("message", null, this.wizardPanel);
                }
            }
        } else if (component != this.getMessage()) {
            this.setMessage(component);
        }
        object = component.getName();
        if (object == null) {
            object = "";
        }
        Object[] objectArray = new Object[]{object, settingsAndIterator.getIterator(this).name()};
        MessageFormat messageFormat = this.getTitleFormat();
        if (this.autoWizardStyle) {
            this.wizardPanel.setPanelName(messageFormat.format(objectArray));
        } else {
            this.setTitle(messageFormat.format(objectArray));
        }
        Component component2 = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
        if (component2 != null && !component2.isEnabled() && this.wizardPanel != null) {
            this.wizardPanel.requestFocus();
        }
    }

    boolean isForwardEnabled() {
        return this.data.getIterator(this).current().isValid() && !this.validationRuns;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateStateWithFeedback() {
        try {
            this.showWaitCursor();
            this.updateState();
        }
        finally {
            this.showNormalCursor();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void goToNextStep(Dimension dimension) {
        try {
            Window window;
            this.showWaitCursor();
            boolean bl = false;
            Font font = (Font)UIManager.getDefaults().get("controlFont");
            Integer n = (Integer)UIManager.get("nbDefaultFontSize");
            if (n == null) {
                n = new Integer(11);
            }
            if (font != null && font.getSize() > n && (window = SwingUtilities.getWindowAncestor((Component)this.getMessage())) != null) {
                this.updateState();
                bl = true;
                this.resizeWizard(window, dimension);
            }
            if (!bl) {
                this.updateState();
            }
            if (this.wizardPanel != null) {
                this.wizardPanel.requestFocus();
            }
        }
        finally {
            this.showNormalCursor();
        }
    }

    private void resizeWizard(Window window, Dimension dimension) {
        assert (SwingUtilities.isEventDispatchThread()) : "getComponent() must be called in EQ only.";
        Dimension dimension2 = this.data.getIterator(this).current().getComponent().getPreferredSize();
        if (dimension2.width > dimension.width || dimension2.height > dimension.height) {
            Rectangle rectangle;
            Rectangle rectangle2 = window.getBounds();
            int n = Math.max(rectangle2.width + (dimension2.width - dimension.width), rectangle2.width);
            int n2 = Math.max(rectangle2.height + (dimension2.height - dimension.height), rectangle2.height);
            Rectangle rectangle3 = Utilities.getUsableScreenBounds();
            if (rectangle2.x + n > rectangle3.width || rectangle2.y + n2 > rectangle3.height) {
                n = Math.min(rectangle3.width, n);
                n2 = Math.min(rectangle3.height, n2);
                rectangle = Utilities.findCenterBounds((Dimension)new Dimension(n, n2));
            } else {
                rectangle = new Rectangle(rectangle2.x, rectangle2.y, n, n2);
            }
            window.setBounds(rectangle);
            window.invalidate();
            window.validate();
            window.repaint();
        }
    }

    private void showWaitCursor() {
        if (this.wizardPanel == null || this.wizardPanel.getRootPane() == null) {
            return;
        }
        if (this.wizardPanel != null) {
            KeyStroke keyStroke = KeyStroke.getKeyStroke(27, 0);
            this.escapeActionListener = this.wizardPanel.getRootPane().getActionForKeyStroke(keyStroke);
            this.wizardPanel.getRootPane().unregisterKeyboardAction(keyStroke);
        }
        this.waitingComponent = this.wizardPanel.getRootPane().getContentPane();
        this.waitingComponent.setCursor(Cursor.getPredefinedCursor(3));
        this.changeStateInProgress = true;
    }

    private void showNormalCursor() {
        if (this.waitingComponent == null) {
            return;
        }
        Window window = SwingUtilities.getWindowAncestor((Component)this.getMessage());
        if (window != null) {
            window.setEnabled(true);
        }
        if (this.wizardPanel != null) {
            if (this.escapeActionListener != null && this.wizardPanel.getRootPane() != null) {
                this.wizardPanel.getRootPane().registerKeyboardAction(this.escapeActionListener, "Escape", KeyStroke.getKeyStroke(27, 0), 1);
            }
            this.wizardPanel.setProgressComponent(null, null);
        }
        this.waitingComponent.setCursor(null);
        this.waitingComponent = null;
        this.changeStateInProgress = false;
    }

    private boolean getBooleanProperty(JComponent jComponent, String string) {
        Object object = this.getProperty(string);
        if (object instanceof Boolean) {
            return (Boolean)object;
        }
        object = jComponent.getClientProperty(string);
        if (object instanceof Boolean) {
            return (Boolean)object;
        }
        return false;
    }

    private Dimension getLeftDimension(JComponent jComponent) {
        Object object = jComponent.getClientProperty(PROP_LEFT_DIMENSION);
        Dimension dimension = object instanceof Dimension ? (Dimension)object : new Dimension(198, 233);
        return dimension;
    }

    private void setPanelProperties(JComponent jComponent) {
        Object object = this.getProperty(PROP_CONTENT_SELECTED_INDEX);
        if (object instanceof Integer) {
            this.contentSelectedIndex = (Integer)object;
        } else {
            object = jComponent.getClientProperty(PROP_CONTENT_SELECTED_INDEX);
            if (object instanceof Integer) {
                this.contentSelectedIndex = (Integer)object;
            }
        }
        object = this.getProperty(PROP_CONTENT_DATA);
        if (object instanceof String[]) {
            this.contentData = (String[])object;
        } else {
            object = jComponent.getClientProperty(PROP_CONTENT_DATA);
            if (object instanceof String[]) {
                this.contentData = (String[])object;
            }
        }
        object = this.getProperty(PROP_IMAGE);
        if (object instanceof Image) {
            this.image = (Image)object;
        } else if ((this.properties == null || !this.properties.containsKey(PROP_IMAGE)) && (object = jComponent.getClientProperty(PROP_IMAGE)) instanceof Image) {
            this.image = (Image)object;
        }
        object = this.getProperty(PROP_IMAGE_ALIGNMENT);
        if (object instanceof String) {
            this.imageAlignment = (String)object;
        } else {
            object = jComponent.getClientProperty(PROP_IMAGE_ALIGNMENT);
            if (object instanceof String) {
                this.imageAlignment = (String)object;
            }
        }
        object = this.getProperty(PROP_CONTENT_BACK_COLOR);
        if (object instanceof Color) {
            this.contentBackColor = (Color)object;
        } else {
            object = jComponent.getClientProperty(PROP_CONTENT_BACK_COLOR);
            if (object instanceof Color) {
                this.contentBackColor = (Color)object;
            }
        }
        object = this.getProperty(PROP_CONTENT_FOREGROUND_COLOR);
        if (object instanceof Color) {
            this.contentForegroundColor = (Color)object;
        } else {
            object = jComponent.getClientProperty(PROP_CONTENT_FOREGROUND_COLOR);
            if (object instanceof Color) {
                this.contentForegroundColor = (Color)object;
            }
        }
        object = jComponent.getClientProperty(PROP_HELP_URL);
        if (object instanceof URL) {
            this.helpURL = (URL)object;
        } else if (object == null) {
            this.helpURL = null;
        }
    }

    private void initBundleProperties() {
        this.contentBackColor = new Color(this.getIntFromBundle("INT_WizardBackRed"), this.getIntFromBundle("INT_WizardBackGreen"), this.getIntFromBundle("INT_WizardBackBlue"));
        this.contentForegroundColor = new Color(this.getIntFromBundle("INT_WizardForegroundRed"), this.getIntFromBundle("INT_WizardForegroundGreen"), this.getIntFromBundle("INT_WizardForegroundBlue"));
        this.imageAlignment = this.bundle.getString("STRING_WizardImageAlignment");
    }

    @Override
    public void setValue(Object object) {
        this.setValueOpen(object, this.data);
    }

    private <A> void setValueOpen(Object object, SettingsAndIterator<A> settingsAndIterator) {
        Object object2 = this.backConvertOption(object);
        Object object3 = this.getValue();
        this.setValueWithoutPCH(object2);
        if (CLOSED_OPTION.equals(object2)) {
            try {
                this.resetWizard();
            }
            catch (RuntimeException runtimeException) {
                err.log(Level.INFO, null, runtimeException);
            }
        } else if ((FINISH_OPTION.equals(object2) || NEXT_OPTION.equals(object2)) && ((SettingsAndIterator)settingsAndIterator).current != null) {
            Panel panel = ((SettingsAndIterator)settingsAndIterator).current;
            ((SettingsAndIterator)settingsAndIterator).current.storeSettings(settingsAndIterator.getSettings(this));
            if (!panel.equals(((SettingsAndIterator)settingsAndIterator).current)) {
                this.currentPanelWasChangedWhileStoreSettings = true;
            }
        }
        this.firePropertyChange("value", object3, object2);
    }

    private void resetWizard() {
        this.resetWizardOpen(this.data);
    }

    private <A> void resetWizardOpen(SettingsAndIterator<A> settingsAndIterator) {
        if (((SettingsAndIterator)settingsAndIterator).current != null) {
            ((SettingsAndIterator)settingsAndIterator).current.storeSettings(settingsAndIterator.getSettings(this));
            ((SettingsAndIterator)settingsAndIterator).current.removeChangeListener(this.weakChangeListener);
            ((SettingsAndIterator)settingsAndIterator).current = null;
            if (this.wizardPanel != null) {
                this.wizardPanel.resetPreferredSize();
            }
        }
        this.callUninitialize();
        settingsAndIterator.getIterator(this).removeChangeListener(this.weakChangeListener);
    }

    private int getIntFromBundle(String string) {
        return Integer.parseInt(this.bundle.getString(string));
    }

    private static Image getDefaultImage() {
        return ImageUtilities.loadImage((String)"org/netbeans/modules/dialogs/defaultWizard.gif", (boolean)true);
    }

    private void updateButtonAccessibleDescription() {
        assert (SwingUtilities.isEventDispatchThread()) : "Call only in AWT queue.";
        String string = this.contentData != null && this.contentSelectedIndex > 0 && this.contentSelectedIndex - 1 < this.contentData.length ? this.contentData[this.contentSelectedIndex - 1] : "";
        try {
            this.previousButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(WizardDescriptor.class, (String)"ACSD_PREVIOUS", (Object)new Integer(this.contentSelectedIndex), (Object)string));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            err.log(Level.INFO, illegalArgumentException.getLocalizedMessage() + " while setting ACSD_PREVIOUS with params " + string + ", " + this.contentSelectedIndex, illegalArgumentException);
        }
        string = this.contentData != null && this.contentSelectedIndex < this.contentData.length - 1 && this.contentSelectedIndex + 1 >= 0 ? this.contentData[this.contentSelectedIndex + 1] : "";
        try {
            this.nextButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(WizardDescriptor.class, (String)"ACSD_NEXT", (Object)new Integer(this.contentSelectedIndex + 2), (Object)string));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            err.log(Level.INFO, illegalArgumentException.getLocalizedMessage() + " while setting ACSD_NEXT with params " + string + ", " + (this.contentSelectedIndex + 2), illegalArgumentException);
        }
    }

    private void lazyValidate(final Panel panel, final Runnable runnable) {
        Runnable runnable2 = new Runnable(){

            @Override
            public void run() {
                block7: {
                    err.log(Level.FINE, "validationPeformer entry.");
                    ValidatingPanel validatingPanel = (ValidatingPanel)panel;
                    try {
                        if (WizardDescriptor.this.currentPanelWasChangedWhileStoreSettings) {
                            err.log(Level.FINE, "validationPeformer interupt because currentPanelWasChangedWhileStoreSettings");
                            WizardDescriptor.this.currentPanelWasChangedWhileStoreSettings = false;
                        } else {
                            validatingPanel.validate();
                            err.log(Level.FINE, "validation passed successfully.");
                        }
                        WizardDescriptor.this.validationRuns = false;
                        if (SwingUtilities.isEventDispatchThread()) {
                            err.log(Level.FINE, "Runs onValidPerformer directly in EDT.");
                            runnable.run();
                        } else {
                            err.log(Level.FINE, "invokeLater onValidPerformer.");
                            SwingUtilities.invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    err.log(Level.FINE, "Runs onValidPerformer from invokeLater.");
                                    runnable.run();
                                }
                            });
                        }
                    }
                    catch (WizardValidationException wizardValidationException) {
                        JComponent jComponent;
                        WizardDescriptor.this.validationRuns = false;
                        err.log(Level.FINE, "validation failed", wizardValidationException);
                        WizardDescriptor.this.updateState();
                        if (WizardDescriptor.this.wizardPanel != null) {
                            WizardDescriptor.this.wizardPanel.setMessage(1, wizardValidationException.getLocalizedMessage());
                        }
                        if ((jComponent = wizardValidationException.getSource()) == null || !jComponent.isFocusable()) break block7;
                        jComponent.requestFocus();
                    }
                }
            }
        };
        if (panel instanceof AsynchronousValidatingPanel) {
            AsynchronousValidatingPanel asynchronousValidatingPanel = (AsynchronousValidatingPanel)panel;
            this.validationRuns = true;
            asynchronousValidatingPanel.prepareValidation();
            err.log(Level.FINE, "Do ASYNCHRONOUS_JOBS_RP.post(validationPeformer).");
            this.updateStateWithFeedback();
            this.backgroundValidationTask = ASYNCHRONOUS_JOBS_RP.post(runnable2);
        } else if (panel instanceof ValidatingPanel) {
            this.validationRuns = true;
            err.log(Level.FINE, "Runs validationPeformer.");
            runnable2.run();
        } else {
            err.log(Level.FINE, "Runs onValidPerformer.");
            runnable.run();
        }
    }

    private void callInitialize() {
        assert (this.data.getIterator(this) != null);
        if (this.data.getIterator(this) instanceof InstantiatingIterator) {
            ((InstantiatingIterator)this.data.getIterator(this)).initialize(this);
        }
        this.newObjects = Collections.EMPTY_SET;
    }

    private void callUninitialize() {
        assert (this.data.getIterator(this) != null);
        if (this.data.getIterator(this) instanceof InstantiatingIterator) {
            ((InstantiatingIterator)this.data.getIterator(this)).uninitialize(this);
        }
    }

    private void callInstantiate() throws IOException {
        this.callInstantiateOpen(this.data);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <A> void callInstantiateOpen(SettingsAndIterator<A> settingsAndIterator) throws IOException {
        Iterator<A> iterator = settingsAndIterator.getIterator(this);
        assert (iterator != null);
        err.log(Level.FINE, "Is AsynchronousInstantiatingIterator? " + (iterator instanceof AsynchronousInstantiatingIterator));
        err.log(Level.FINE, "Is ProgressInstantiatingIterator? " + (iterator instanceof ProgressInstantiatingIterator));
        if (iterator instanceof ProgressInstantiatingIterator) {
            this.handle = ProgressHandleFactory.createHandle((String)PROGRESS_BAR_DISPLAY_NAME);
            JComponent jComponent = ProgressHandleFactory.createProgressComponent((ProgressHandle)this.handle);
            if (this.wizardPanel != null) {
                this.wizardPanel.setProgressComponent(jComponent, ProgressHandleFactory.createDetailLabelComponent((ProgressHandle)this.handle));
            }
            err.log(Level.FINE, "Show progressPanel controlled by iterator later.");
        } else if (iterator instanceof AsynchronousInstantiatingIterator) {
            this.handle = ProgressHandleFactory.createHandle((String)PROGRESS_BAR_DISPLAY_NAME);
            JComponent jComponent = ProgressHandleFactory.createProgressComponent((ProgressHandle)this.handle);
            if (this.wizardPanel != null) {
                this.wizardPanel.setProgressComponent(jComponent, ProgressHandleFactory.createMainLabelComponent((ProgressHandle)this.handle));
            }
            this.handle.start();
            err.log(Level.FINE, "Show progressPanel later.");
        }
        iterator.current().storeSettings(settingsAndIterator.getSettings(this));
        if (iterator instanceof InstantiatingIterator) {
            this.showWaitCursor();
            try {
                assert (!(iterator instanceof AsynchronousInstantiatingIterator) || !SwingUtilities.isEventDispatchThread()) : "Cannot invoked within EDT if AsynchronousInstantiatingIterator!";
                if (iterator instanceof ProgressInstantiatingIterator) {
                    assert (this.handle != null) : "ProgressHandle must be not null.";
                    err.log(Level.FINE, "Calls instantiate(ProgressHandle) on iterator: " + iterator.getClass().getName());
                    this.newObjects = ((ProgressInstantiatingIterator)iterator).instantiate(this.handle);
                } else {
                    err.log(Level.FINE, "Calls instantiate() on iterator: " + iterator.getClass().getName());
                    this.newObjects = ((InstantiatingIterator)iterator).instantiate();
                }
            }
            finally {
                this.showNormalCursor();
            }
        }
    }

    private static Font doDeriveFont(Font font, int n) {
        if (Utilities.isMac()) {
            return new Font(font.getName(), n, font.getSize());
        }
        return font.deriveFont(n);
    }

    final void doNextClick() {
        if (this.nextButton.isEnabled()) {
            this.nextButton.doClick();
        }
    }

    final void doPreviousClick() {
        if (this.previousButton.isEnabled()) {
            this.previousButton.doClick();
        }
    }

    final void doFinishClick() {
        if (this.finishButton.isEnabled()) {
            this.finishButton.doClick();
        }
    }

    final void doCancelClick() {
        if (this.cancelButton.isEnabled()) {
            this.cancelButton.doClick();
        }
    }

    final boolean isNextEnabled() {
        return this.nextButton.isEnabled();
    }

    final boolean isFinishEnabled() {
        return this.finishButton.isEnabled();
    }

    private static final class EmptyPanel
    implements Panel<Void>,
    Iterator<Void> {
        private EmptyPanel() {
        }

        @Override
        public Component getComponent() {
            return new JPanel();
        }

        @Override
        public HelpCtx getHelp() {
            return HelpCtx.DEFAULT_HELP;
        }

        @Override
        public void readSettings(Void void_) {
        }

        @Override
        public void storeSettings(Void void_) {
        }

        @Override
        public boolean isValid() {
            return true;
        }

        @Override
        public void addChangeListener(ChangeListener changeListener) {
        }

        @Override
        public void removeChangeListener(ChangeListener changeListener) {
        }

        @Override
        public Panel<Void> current() {
            return this;
        }

        @Override
        public String name() {
            return "";
        }

        @Override
        public boolean hasNext() {
            return false;
        }

        @Override
        public boolean hasPrevious() {
            return false;
        }

        @Override
        public void nextPanel() {
        }

        @Override
        public void previousPanel() {
        }
    }

    private static final class SettingsAndIterator<Data> {
        private final Iterator<Data> panels;
        private final Data settings;
        private final boolean useThis;
        private Panel<Data> current;

        public SettingsAndIterator(Iterator<Data> iterator, Data Data) {
            this(iterator, Data, false);
        }

        public SettingsAndIterator(Iterator<Data> iterator, Data Data, boolean bl) {
            this.panels = iterator;
            this.settings = Data;
            this.useThis = bl;
        }

        public static SettingsAndIterator<WizardDescriptor> create(Iterator<WizardDescriptor> iterator) {
            return new SettingsAndIterator<Object>(iterator, null, true);
        }

        public static SettingsAndIterator<Void> empty() {
            return new SettingsAndIterator<Void>(new EmptyPanel(), null);
        }

        public Iterator<Data> getIterator(WizardDescriptor wizardDescriptor) {
            return this.panels;
        }

        public Data getSettings(WizardDescriptor wizardDescriptor) {
            return (Data)(this.useThis ? wizardDescriptor : this.settings);
        }

        public SettingsAndIterator<Data> clone(Iterator<Data> iterator) {
            SettingsAndIterator<Data> settingsAndIterator = new SettingsAndIterator<Data>(iterator, this.settings, this.useThis);
            return settingsAndIterator;
        }
    }

    private static final class FixedHeightLabel
    extends JLabel {
        private static final int ESTIMATED_HEIGHT = 16;

        @Override
        public Dimension getPreferredSize() {
            Dimension dimension = super.getPreferredSize();
            assert (16 == ImageUtilities.loadImage((String)"org/netbeans/modules/dialogs/warning.gif").getHeight(null)) : "Use only 16px icon.";
            dimension.height = Math.max(16, dimension.height);
            return dimension;
        }
    }

    static class FinishAction {
        ActionListener listner;

        FinishAction() {
        }

        public void addActionListener(ActionListener actionListener) {
            this.listner = actionListener;
        }

        public void removeActionListener(ActionListener actionListener) {
            this.listner = null;
        }

        public void fireActionPerformed() {
            if (this.listner != null) {
                this.listner.actionPerformed(new ActionEvent(this, 0, ""));
            }
        }
    }

    private static class BoundedHtmlBrowser
    extends HtmlBrowser {
        Dimension dim;

        public BoundedHtmlBrowser(Dimension dimension) {
            super(false, false);
            this.dim = dimension;
        }

        public Dimension getPreferredSize() {
            return this.dim;
        }
    }

    private static class WizardPanel
    extends JPanel {
        private JPanel rightPanel = new JPanel(new BorderLayout());
        private JLabel panelName = new JLabel("Step");
        private JList contentList;
        private Component rightComponent;
        private ImagedPanel contentPanel;
        private JPanel contentLabelPanel;
        private WrappedCellRenderer cellRenderer;
        private JTabbedPane tabbedPane;
        private HtmlBrowser htmlBrowser;
        private Dimension cachedDimension;
        private JLabel label;
        private JPanel progressBarPanel;
        private int selectedIndex;
        private JLabel m_lblMessage;
        private Color nbErrorForeground;
        private Color nbWarningForeground;
        private Color nbInfoForeground;
        private static final int MSG_TYPE_ERROR = 1;
        private static final int MSG_TYPE_WARNING = 2;
        private static final int MSG_TYPE_INFO = 3;

        public WizardPanel(boolean bl, boolean bl2, boolean bl3, Dimension dimension) {
            super(new BorderLayout());
            this.initComponents(bl, bl2, bl3, dimension);
            this.setOpaque(false);
            this.resetPreferredSize();
        }

        private void initComponents(boolean bl, boolean bl2, boolean bl3, Dimension dimension) {
            JComponent jComponent;
            if (bl) {
                this.createContentPanel(bl3, dimension);
                if (!bl2) {
                    this.add((Component)this.contentPanel, "West");
                }
            }
            if (bl2) {
                this.htmlBrowser = new BoundedHtmlBrowser(dimension);
                this.htmlBrowser.setPreferredSize(dimension);
                if (!bl) {
                    this.add((Component)this.htmlBrowser, "West");
                }
            }
            if (bl2 && bl) {
                this.tabbedPane = new JTabbedPane(3);
                this.tabbedPane.addTab(NbBundle.getMessage(WizardDescriptor.class, (String)"CTL_ContentName"), this.contentPanel);
                this.tabbedPane.addTab(NbBundle.getMessage(WizardDescriptor.class, (String)"CTL_HelpName"), (Component)this.htmlBrowser);
                this.tabbedPane.setEnabledAt(1, false);
                this.tabbedPane.setOpaque(false);
                this.add((Component)this.tabbedPane, "West");
            }
            this.panelName.setBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, this.panelName.getForeground()));
            this.panelName.setFont(WizardDescriptor.doDeriveFont(this.panelName.getFont(), 1));
            JPanel jPanel = new JPanel(new BorderLayout());
            jPanel.add((Component)this.panelName, "North");
            jPanel.setBorder(BorderFactory.createEmptyBorder(12, 12, 12, 11));
            this.rightPanel.setBorder(BorderFactory.createEmptyBorder(0, 12, 11, 11));
            this.panelName.setLabelFor(jPanel);
            this.nbErrorForeground = UIManager.getColor("nb.errorForeground");
            if (this.nbErrorForeground == null) {
                this.nbErrorForeground = new Color(255, 0, 0);
            }
            this.nbWarningForeground = UIManager.getColor("nb.warningForeground");
            if (this.nbWarningForeground == null) {
                this.nbWarningForeground = new Color(51, 51, 51);
            }
            this.nbInfoForeground = UIManager.getColor("nb.warningForeground");
            if (this.nbInfoForeground == null) {
                this.nbInfoForeground = UIManager.getColor("Label.foreground");
            }
            JPanel jPanel2 = new JPanel(new BorderLayout());
            jPanel2.setBorder(BorderFactory.createEmptyBorder(0, 12, 12, 11));
            this.m_lblMessage = new FixedHeightLabel();
            this.m_lblMessage.setForeground(this.nbErrorForeground);
            jPanel2.add((Component)this.m_lblMessage, "Center");
            this.progressBarPanel = new JPanel(new BorderLayout());
            this.progressBarPanel.setVisible(false);
            if (bl) {
                this.progressBarPanel.setOpaque(false);
                this.progressBarPanel.setBorder(BorderFactory.createEmptyBorder(0, 4, 7, 4));
                this.contentPanel.add((Component)this.progressBarPanel, "South");
            } else {
                this.progressBarPanel.add((Component)new JLabel(), "North");
                jComponent = new JProgressBar();
                ((JProgressBar)jComponent).setOrientation(0);
                jComponent.setAlignmentX(0.5f);
                jComponent.setAlignmentY(0.5f);
                ((JProgressBar)jComponent).setString("0");
                this.progressBarPanel.add((Component)jComponent, "Center");
                this.progressBarPanel.setBorder(BorderFactory.createEmptyBorder(4, 0, 0, 0));
                jPanel2.add((Component)this.progressBarPanel, "South");
            }
            jComponent = new JPanel(new BorderLayout());
            jComponent.add((Component)jPanel, "North");
            jComponent.add((Component)this.rightPanel, "Center");
            jComponent.add((Component)jPanel2, "South");
            this.add((Component)jComponent, "Center");
            if (this.getBorder() == null || "GTK".equals(UIManager.getLookAndFeel().getID())) {
                JSeparator jSeparator = new JSeparator();
                jSeparator.setForeground(Color.darkGray);
                this.add((Component)jSeparator, "South");
            }
        }

        public void setMessage(int n, String string) {
            if (string != null && string.trim().length() > 0) {
                switch (n) {
                    case 1: {
                        this.prepareMessage(this.m_lblMessage, ImageUtilities.loadImageIcon((String)"org/netbeans/modules/dialogs/error.gif", (boolean)false), this.nbErrorForeground);
                        break;
                    }
                    case 2: {
                        this.prepareMessage(this.m_lblMessage, ImageUtilities.loadImageIcon((String)"org/netbeans/modules/dialogs/warning.gif", (boolean)false), this.nbWarningForeground);
                        break;
                    }
                    case 3: {
                        this.prepareMessage(this.m_lblMessage, ImageUtilities.loadImageIcon((String)"org/netbeans/modules/dialogs/info.png", (boolean)false), this.nbInfoForeground);
                        break;
                    }
                }
                this.m_lblMessage.setToolTipText(string);
            } else {
                this.prepareMessage(this.m_lblMessage, null, null);
                this.m_lblMessage.setToolTipText(null);
            }
            this.m_lblMessage.setText(string);
        }

        private void prepareMessage(JLabel jLabel, ImageIcon imageIcon, Color color) {
            jLabel.setIcon(imageIcon);
            jLabel.setForeground(color);
        }

        private void setProgressComponent(JComponent jComponent, final JLabel jLabel) {
            if (jComponent == null) {
                this.progressBarPanel.removeAll();
                this.progressBarPanel.setVisible(false);
            } else {
                if (jLabel != null) {
                    jLabel.setText(PROGRESS_BAR_DISPLAY_NAME);
                    jLabel.addPropertyChangeListener("text", new PropertyChangeListener(){

                        @Override
                        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                            jLabel.putClientProperty("ToolTipText", propertyChangeEvent.getNewValue().toString());
                        }
                    });
                    jLabel.setToolTipText(PROGRESS_BAR_DISPLAY_NAME);
                    this.progressBarPanel.add((Component)jLabel, "North");
                }
                this.progressBarPanel.add((Component)jComponent, "Center");
                this.progressBarPanel.setVisible(true);
            }
        }

        private void createContentPanel(boolean bl, Dimension dimension) {
            this.contentList = new JList();
            this.cellRenderer = new WrappedCellRenderer(bl, dimension.width);
            this.cellRenderer.setOpaque(false);
            this.contentList.setCellRenderer(this.cellRenderer);
            this.contentList.setOpaque(false);
            this.contentList.setEnabled(false);
            this.contentList.getAccessibleContext().setAccessibleDescription("");
            JScrollPane jScrollPane = new JScrollPane(this.contentList);
            jScrollPane.setHorizontalScrollBarPolicy(31);
            jScrollPane.getViewport().setOpaque(false);
            jScrollPane.setBorder(BorderFactory.createEmptyBorder());
            jScrollPane.setOpaque(false);
            jScrollPane.setViewportBorder(BorderFactory.createEmptyBorder());
            this.label = new JLabel(NbBundle.getMessage(WizardDescriptor.class, (String)"CTL_ContentName"));
            this.label.setForeground(Color.white);
            this.label.setBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, this.label.getForeground()));
            this.label.setFont(WizardDescriptor.doDeriveFont(this.label.getFont(), 1));
            this.contentLabelPanel = new JPanel(new BorderLayout());
            this.contentLabelPanel.setBorder(BorderFactory.createEmptyBorder(12, 12, 11, 11));
            this.contentLabelPanel.setOpaque(false);
            this.contentLabelPanel.add((Component)this.label, "North");
            this.contentPanel = new ImagedPanel(null);
            this.contentPanel.add((Component)this.contentLabelPanel, "North");
            this.contentPanel.add((Component)jScrollPane, "Center");
            this.contentPanel.setPreferredSize(dimension);
            this.label.setLabelFor(this.contentList);
        }

        public void setContent(final String[] stringArray) {
            final JList jList = this.contentList;
            if (jList == null) {
                return;
            }
            Mutex.EVENT.writeAccess(new Runnable(){

                @Override
                public void run() {
                    jList.setListData(stringArray);
                    jList.revalidate();
                    jList.repaint();
                    WizardPanel.this.contentLabelPanel.setVisible(stringArray.length > 0);
                }
            });
        }

        public void setSelectedIndex(final int n) {
            this.selectedIndex = n;
            if (this.cellRenderer != null) {
                this.cellRenderer.setSelectedIndex(n);
                final JList jList = this.contentList;
                if (jList == null) {
                    return;
                }
                Mutex.EVENT.readAccess(new Runnable(){

                    @Override
                    public void run() {
                        jList.ensureIndexIsVisible(n);
                        jList.setFixedCellWidth(0);
                        jList.setFixedCellWidth(-1);
                    }
                });
            }
        }

        public void setContentBackColor(Color color) {
            if (this.contentPanel != null) {
                this.contentPanel.setBackground(color);
            }
        }

        public void setContentForegroundColor(Color color) {
            if (this.cellRenderer == null) {
                return;
            }
            this.cellRenderer.setForegroundColor(color);
            this.label.setForeground(color);
            this.label.setBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, this.label.getForeground()));
        }

        public void setImage(Image image) {
            if (this.contentPanel != null) {
                this.contentPanel.setImage(image);
            }
        }

        public void setImageAlignment(String string) {
            if (this.contentPanel != null) {
                this.contentPanel.setImageAlignment(string);
            }
        }

        public void setRightComponent(Component component) {
            if (this.rightComponent != null) {
                this.rightPanel.remove(this.rightComponent);
            }
            this.rightComponent = component;
            this.rightPanel.add(this.rightComponent, "Center");
        }

        public Component getRightComponent() {
            return this.rightComponent;
        }

        public void setPanelName(String string) {
            this.panelName.setText(string);
        }

        public void setHelpURL(URL uRL) {
            if (this.htmlBrowser == null) {
                return;
            }
            if (uRL != null) {
                if (!uRL.equals(this.htmlBrowser.getDocumentURL())) {
                    this.htmlBrowser.setURL(uRL);
                }
                if (this.tabbedPane != null) {
                    this.tabbedPane.setEnabledAt(this.tabbedPane.indexOfComponent((Component)this.htmlBrowser), true);
                }
            } else if (this.tabbedPane != null) {
                this.tabbedPane.setSelectedComponent(this.contentPanel);
                this.tabbedPane.setEnabledAt(this.tabbedPane.indexOfComponent((Component)this.htmlBrowser), false);
            }
        }

        public void resetPreferredSize() {
            this.cachedDimension = new Dimension(600, 365);
        }

        @Override
        public Dimension getPreferredSize() {
            Dimension dimension = super.getPreferredSize();
            if (dimension.height > this.cachedDimension.height) {
                this.cachedDimension.height = dimension.height;
            }
            if (dimension.width > this.cachedDimension.width) {
                this.cachedDimension.width = dimension.width;
            }
            return this.cachedDimension;
        }

        @Override
        public void requestFocus() {
            if (this.rightComponent != null && this.rightComponent.isDisplayable()) {
                JComponent jComponent = (JComponent)this.rightComponent;
                Container container = jComponent.getFocusCycleRootAncestor();
                FocusTraversalPolicy focusTraversalPolicy = container.getFocusTraversalPolicy();
                Component component = focusTraversalPolicy.getComponentAfter(container, jComponent);
                if (component != null) {
                    component.requestFocus();
                } else {
                    jComponent.requestFocus();
                }
            } else {
                super.requestFocus();
            }
        }

        @Override
        @Deprecated
        public boolean requestDefaultFocus() {
            if (this.rightComponent instanceof JComponent) {
                return ((JComponent)this.rightComponent).requestDefaultFocus();
            }
            return super.requestDefaultFocus();
        }

        @Override
        public AccessibleContext getAccessibleContext() {
            if (this.accessibleContext == null) {
                this.accessibleContext = new AccessibleWizardPanel();
            }
            return this.accessibleContext;
        }

        private class AccessibleWizardPanel
        extends JPanel.AccessibleJPanel {
            AccessibleWizardPanel() {
                super(WizardPanel.this);
            }

            @Override
            public String getAccessibleDescription() {
                if (this.accessibleDescription != null) {
                    return this.accessibleDescription;
                }
                if (WizardPanel.this.rightComponent instanceof Accessible) {
                    if (WizardPanel.this.rightComponent.getAccessibleContext().getAccessibleDescription() == null) {
                        return null;
                    }
                    return NbBundle.getMessage(WizardDescriptor.class, (String)"ACSD_WizardPanel", (Object)new Integer(WizardPanel.this.selectedIndex + 1), (Object)WizardPanel.this.panelName.getText(), (Object)WizardPanel.this.rightComponent.getAccessibleContext().getAccessibleDescription());
                }
                return super.getAccessibleDescription();
            }
        }
    }

    private static class WrappedCellRenderer
    extends JPanel
    implements ListCellRenderer {
        JTextArea ta = new JTextArea();
        JLabel numberLabel;
        int selected = -1;
        boolean contentNumbered;
        int taWidth;

        private WrappedCellRenderer(boolean bl, int n) {
            super(new BorderLayout());
            this.contentNumbered = bl;
            this.ta.setOpaque(false);
            this.ta.setEditable(false);
            this.ta.setLineWrap(true);
            this.ta.setWrapStyleWord(true);
            this.ta.setFont(UIManager.getFont("Label.font"));
            this.ta.getAccessibleContext().setAccessibleDescription("");
            this.ta.setBorder(BorderFactory.createEmptyBorder());
            this.taWidth = n - 12 - 12;
            this.numberLabel = new JLabel(){

                @Override
                protected void paintComponent(Graphics graphics) {
                    super.paintComponent(graphics);
                    if (!WrappedCellRenderer.this.contentNumbered) {
                        Rectangle rectangle = graphics.getClipBounds();
                        graphics.fillOval(rectangle.x, rectangle.y, 7, 7);
                    }
                }
            };
            this.numberLabel.setLabelFor(this.ta);
            this.numberLabel.setHorizontalAlignment(2);
            this.numberLabel.setVerticalAlignment(1);
            this.numberLabel.setFont(this.ta.getFont());
            this.numberLabel.setOpaque(false);
            this.numberLabel.setPreferredSize(new Dimension(25, 0));
            this.add((Component)this.numberLabel, "West");
            this.taWidth -= 25;
            Insets insets = this.ta.getInsets();
            this.ta.setSize(this.taWidth, insets.top + insets.bottom + 1);
            this.add((Component)this.ta, "Center");
            this.setBorder(BorderFactory.createEmptyBorder(0, 12, 0, 12));
            this.setOpaque(false);
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            if (n == this.selected) {
                this.numberLabel.setFont(WizardDescriptor.doDeriveFont(this.numberLabel.getFont(), 1));
                this.ta.setFont(WizardDescriptor.doDeriveFont(this.ta.getFont(), 1));
            } else {
                this.numberLabel.setFont(WizardDescriptor.doDeriveFont(this.numberLabel.getFont(), 0));
                this.ta.setFont(WizardDescriptor.doDeriveFont(this.ta.getFont(), 0));
            }
            if (this.contentNumbered) {
                this.numberLabel.setText(Integer.toString(n + 1) + ".");
            }
            Insets insets = this.ta.getInsets();
            this.ta.setSize(this.taWidth, insets.top + insets.bottom + 1);
            this.ta.setText((String)object);
            return this;
        }

        private void setSelectedIndex(int n) {
            this.selected = n;
        }

        private void setForegroundColor(Color color) {
            if (this.numberLabel != null) {
                this.numberLabel.setForeground(color);
                this.numberLabel.setBackground(color);
            }
            this.ta.setForeground(color);
        }
    }

    private static class ImagedPanel
    extends JComponent
    implements Accessible,
    Runnable {
        Image image;
        Image tempImage;
        Image image2Load;
        boolean isDefault = false;
        boolean loadPending = false;
        boolean north = true;
        private final Object IMAGE_LOCK = new Object();

        public ImagedPanel(Image image) {
            this.setImage(image);
            this.setLayout(new BorderLayout());
            this.setOpaque(true);
        }

        @Override
        protected void paintComponent(Graphics graphics) {
            graphics.setColor(this.getBackground());
            graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
            if (this.image != null) {
                graphics.drawImage(this.image, 0, this.north ? 0 : this.getHeight() - this.image.getHeight(null), this);
            } else if (this.image2Load != null) {
                this.loadImageInBackground(this.image2Load);
                this.image2Load = null;
            }
        }

        public void setImageAlignment(String string) {
            this.north = "North".equals(string);
        }

        public void setImage(Image image) {
            if (image != null) {
                this.loadImage(image);
                this.isDefault = false;
                return;
            }
            if (!this.isDefault) {
                this.loadImage(WizardDescriptor.getDefaultImage());
                this.isDefault = true;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void loadImage(Image image) {
            MediaTracker mediaTracker = new MediaTracker(this);
            mediaTracker.addImage(image, 0);
            if (mediaTracker.checkID(0)) {
                this.image = image;
                if (this.isShowing()) {
                    this.repaint();
                }
                return;
            }
            if (this.isShowing()) {
                this.loadImageInBackground(image);
            } else {
                Object object = this.IMAGE_LOCK;
                synchronized (object) {
                    this.image = null;
                }
                this.image2Load = image;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void loadImageInBackground(Image image) {
            Object object = this.IMAGE_LOCK;
            synchronized (object) {
                this.tempImage = image;
                if (this.loadPending) {
                    return;
                }
                this.loadPending = true;
            }
            RequestProcessor.getDefault().post((Runnable)this, 30);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Image image;
            Object object = this.IMAGE_LOCK;
            synchronized (object) {
                image = this.tempImage;
                this.tempImage = null;
                this.loadPending = false;
            }
            object = new ImageIcon(image);
            boolean bl = false;
            Object object2 = this.IMAGE_LOCK;
            synchronized (object2) {
                if (!this.loadPending) {
                    this.image = ((ImageIcon)object).getImage();
                    bl = true;
                }
            }
            if (bl) {
                this.repaint();
            }
        }
    }

    private class PropL
    implements PropertyChangeListener {
        PropL() {
        }

        @Override
        public void propertyChange(final PropertyChangeEvent propertyChangeEvent) {
            if (WizardDescriptor.this.wizardPanel == null) {
                return;
            }
            if (!SwingUtilities.isEventDispatchThread()) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        PropL.this.propertyChange(propertyChangeEvent);
                    }
                });
                return;
            }
            String string = propertyChangeEvent.getPropertyName();
            WizardDescriptor.this.setPanelProperties((JComponent)WizardDescriptor.this.wizardPanel.getRightComponent());
            if (WizardDescriptor.PROP_CONTENT_DATA.equals(string)) {
                WizardDescriptor.this.wizardPanel.setContent(WizardDescriptor.this.contentData);
                WizardDescriptor.this.updateButtonAccessibleDescription();
            } else if (WizardDescriptor.PROP_CONTENT_SELECTED_INDEX.equals(string)) {
                WizardDescriptor.this.wizardPanel.setSelectedIndex(WizardDescriptor.this.contentSelectedIndex);
                WizardDescriptor.this.updateButtonAccessibleDescription();
            } else if (WizardDescriptor.PROP_CONTENT_BACK_COLOR.equals(string)) {
                WizardDescriptor.this.wizardPanel.setContentBackColor(WizardDescriptor.this.contentBackColor);
            } else if (WizardDescriptor.PROP_CONTENT_FOREGROUND_COLOR.equals(string)) {
                WizardDescriptor.this.wizardPanel.setContentForegroundColor(WizardDescriptor.this.contentForegroundColor);
            } else if (WizardDescriptor.PROP_IMAGE.equals(string)) {
                WizardDescriptor.this.wizardPanel.setImage(WizardDescriptor.this.image);
            } else if (WizardDescriptor.PROP_IMAGE_ALIGNMENT.equals(string)) {
                WizardDescriptor.this.wizardPanel.setImageAlignment(WizardDescriptor.this.imageAlignment);
            } else if (WizardDescriptor.PROP_HELP_URL.equals(string)) {
                WizardDescriptor.this.wizardPanel.setHelpURL(WizardDescriptor.this.helpURL);
            }
        }
    }

    private final class Listener
    implements ChangeListener,
    ActionListener {
        Listener() {
        }

        @Override
        public void stateChanged(ChangeEvent changeEvent) {
            WizardDescriptor.this.updateState();
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Object object;
            final Iterator iterator = WizardDescriptor.this.data.getIterator(WizardDescriptor.this);
            if (WizardDescriptor.this.wizardPanel != null) {
                WizardDescriptor.this.wizardPanel.setMessage(1, "");
            }
            Object object2 = actionEvent.getSource();
            err.log(Level.FINE, "actionPerformed entry. Source: " + object2);
            if (object2 == WizardDescriptor.this.nextButton) {
                assert (SwingUtilities.isEventDispatchThread()) : "getComponent() must be called in EQ only.";
                object = iterator.current().getComponent().getSize();
                Runnable runnable = new Runnable((Dimension)object){
                    final /* synthetic */ Dimension val$previousSize;
                    {
                        this.val$previousSize = dimension;
                    }

                    @Override
                    public void run() {
                        err.log(Level.FINE, "onValidPerformer on next button entry.");
                        iterator.nextPanel();
                        try {
                            WizardDescriptor.this.goToNextStep(this.val$previousSize);
                        }
                        catch (IllegalStateException illegalStateException) {
                            iterator.previousPanel();
                            String string = illegalStateException.getMessage();
                            if (string != null) {
                                DialogDisplayer.getDefault().notify(new NotifyDescriptor.Message(string));
                            } else {
                                Exceptions.printStackTrace((Throwable)illegalStateException);
                            }
                            WizardDescriptor.this.updateState();
                        }
                        err.log(Level.FINE, "onValidPerformer on next button exit.");
                    }
                };
                WizardDescriptor.this.lazyValidate(iterator.current(), runnable);
            }
            if (actionEvent.getSource() == WizardDescriptor.this.previousButton) {
                iterator.previousPanel();
                WizardDescriptor.this.updateStateWithFeedback();
            }
            if (actionEvent.getSource() == WizardDescriptor.this.finishButton) {
                object = new Runnable(){

                    @Override
                    public void run() {
                        err.log(Level.FINE, "onValidPerformer on finish button entry.");
                        WizardDescriptor.this.previousButton.setEnabled(false);
                        WizardDescriptor.this.nextButton.setEnabled(false);
                        WizardDescriptor.this.finishButton.setEnabled(false);
                        WizardDescriptor.this.cancelButton.setEnabled(false);
                        Runnable runnable = new Runnable(){

                            @Override
                            public void run() {
                                err.log(Level.FINE, "performFinish entry.");
                                Object object = WizardDescriptor.this.getValue();
                                try {
                                    WizardDescriptor.this.callInstantiate();
                                    WizardDescriptor.this.setValueWithoutPCH(NotifyDescriptor.OK_OPTION);
                                    WizardDescriptor.this.resetWizard();
                                }
                                catch (IOException iOException) {
                                    err.log(Level.INFO, null, iOException);
                                    WizardDescriptor.this.setValueWithoutPCH(NEXT_OPTION);
                                    WizardDescriptor.this.updateStateWithFeedback();
                                    WizardDescriptor.this.putProperty(WizardDescriptor.PROP_ERROR_MESSAGE, iOException.getLocalizedMessage());
                                    return;
                                }
                                catch (RuntimeException runtimeException) {
                                    err.log(Level.WARNING, null, runtimeException);
                                    WizardDescriptor.this.setValueWithoutPCH(NEXT_OPTION);
                                    WizardDescriptor.this.updateStateWithFeedback();
                                    WizardDescriptor.this.putProperty(WizardDescriptor.PROP_ERROR_MESSAGE, runtimeException.getLocalizedMessage());
                                    return;
                                }
                                WizardDescriptor.this.firePropertyChange("value", object, NotifyDescriptor.OK_OPTION);
                                SwingUtilities.invokeLater(new Runnable(){

                                    @Override
                                    public void run() {
                                        err.log(Level.FINE, "WD.finishOption.fireActionPerformed()");
                                        WizardDescriptor.this.finishOption.fireActionPerformed();
                                        err.log(Level.FINE, "Set value to OK_OPTION.");
                                        WizardDescriptor.this.setValue(NotifyDescriptor.OK_OPTION);
                                    }
                                });
                                err.log(Level.FINE, "performFinish exit.");
                            }
                        };
                        if (iterator instanceof AsynchronousInstantiatingIterator) {
                            err.log(Level.FINE, "Do ASYNCHRONOUS_JOBS_RP.post(performFinish).");
                            ASYNCHRONOUS_JOBS_RP.post(runnable);
                        } else {
                            err.log(Level.FINE, "Run performFinish.");
                            runnable.run();
                        }
                        err.log(Level.FINE, "onValidPerformer on finish button exit.");
                    }
                };
                WizardDescriptor.this.lazyValidate(iterator.current(), (Runnable)object);
            }
            if (actionEvent.getSource() == WizardDescriptor.this.cancelButton) {
                if (WizardDescriptor.this.backgroundValidationTask != null) {
                    WizardDescriptor.this.backgroundValidationTask.cancel();
                }
                object = WizardDescriptor.this.getValue();
                WizardDescriptor.this.setValueWithoutPCH(NotifyDescriptor.CANCEL_OPTION);
                if (Arrays.asList(WizardDescriptor.this.getClosingOptions()).contains(WizardDescriptor.this.cancelButton)) {
                    try {
                        WizardDescriptor.this.resetWizard();
                    }
                    catch (RuntimeException runtimeException) {
                        err.log(Level.INFO, null, runtimeException);
                    }
                }
                WizardDescriptor.this.firePropertyChange("value", object, NotifyDescriptor.CANCEL_OPTION);
            }
        }
    }

    public static class ArrayIterator<Data>
    implements Iterator<Data> {
        private Panel<Data>[] panels;
        private int index;

        public ArrayIterator() {
            this.panels = this.initializePanels();
            this.index = 0;
        }

        public ArrayIterator(Panel<Data>[] panelArray) {
            this.panels = panelArray;
            this.index = 0;
        }

        public ArrayIterator(List<Panel<Data>> list) {
            this.panels = list.toArray(new Panel[list.size()]);
            this.index = 0;
        }

        protected Panel<Data>[] initializePanels() {
            return new Panel[0];
        }

        @Override
        public Panel<Data> current() {
            return this.panels[this.index];
        }

        @Override
        public String name() {
            return NbBundle.getMessage(WizardDescriptor.class, (String)"CTL_ArrayIteratorName", (Object)(this.index + 1), (Object)this.panels.length);
        }

        @Override
        public boolean hasNext() {
            return this.index < this.panels.length - 1;
        }

        @Override
        public boolean hasPrevious() {
            return this.index > 0;
        }

        @Override
        public synchronized void nextPanel() {
            if (this.index + 1 == this.panels.length) {
                throw new NoSuchElementException();
            }
            ++this.index;
        }

        @Override
        public synchronized void previousPanel() {
            if (this.index == 0) {
                throw new NoSuchElementException();
            }
            --this.index;
        }

        @Override
        public void addChangeListener(ChangeListener changeListener) {
        }

        @Override
        public void removeChangeListener(ChangeListener changeListener) {
        }

        protected void reset() {
            this.index = 0;
        }
    }

    public static interface ProgressInstantiatingIterator<Data>
    extends AsynchronousInstantiatingIterator<Data> {
        public Set instantiate(ProgressHandle var1) throws IOException;
    }

    public static interface AsynchronousInstantiatingIterator<Data>
    extends InstantiatingIterator<Data> {
        @Override
        public Set instantiate() throws IOException;
    }

    public static interface InstantiatingIterator<Data>
    extends Iterator<Data> {
        public Set instantiate() throws IOException;

        public void initialize(WizardDescriptor var1);

        public void uninitialize(WizardDescriptor var1);
    }

    public static interface FinishablePanel<Data>
    extends Panel<Data> {
        public boolean isFinishPanel();
    }

    public static interface AsynchronousValidatingPanel<Data>
    extends ValidatingPanel<Data> {
        public void prepareValidation();

        @Override
        public void validate() throws WizardValidationException;
    }

    public static interface ValidatingPanel<Data>
    extends Panel<Data> {
        public void validate() throws WizardValidationException;
    }

    @Deprecated
    public static interface FinishPanel<Data>
    extends Panel<Data> {
    }

    public static interface Panel<Data> {
        public Component getComponent();

        public HelpCtx getHelp();

        public void readSettings(Data var1);

        public void storeSettings(Data var1);

        public boolean isValid();

        public void addChangeListener(ChangeListener var1);

        public void removeChangeListener(ChangeListener var1);
    }

    public static interface Iterator<Data> {
        public Panel<Data> current();

        public String name();

        public boolean hasNext();

        public boolean hasPrevious();

        public void nextPanel();

        public void previousPanel();

        public void addChangeListener(ChangeListener var1);

        public void removeChangeListener(ChangeListener var1);
    }
}

