/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javahelp;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.List;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.help.SearchHit;
import javax.help.SearchTOCItem;
import javax.help.search.SearchEngine;
import javax.help.search.SearchEvent;
import javax.help.search.SearchItem;
import javax.help.search.SearchListener;
import javax.help.search.SearchQuery;
import org.netbeans.api.javahelp.Help;
import org.netbeans.modules.javahelp.JavaHelp;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

class JavaHelpQuery
implements Comparator<SearchTOCItem> {
    private static JavaHelpQuery theInstance;
    private SearchEngine engine;

    private JavaHelpQuery() {
    }

    public static JavaHelpQuery getDefault() {
        if (null == theInstance) {
            theInstance = new JavaHelpQuery();
        }
        return theInstance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<SearchTOCItem> search(String string) {
        JavaHelpQuery javaHelpQuery = this;
        synchronized (javaHelpQuery) {
            if (null == this.engine) {
                this.engine = this.createSearchEngine();
            }
            ArrayList<SearchTOCItem> arrayList = new ArrayList<SearchTOCItem>();
            Thread thread = new Thread(this.createSearch(string, arrayList));
            thread.start();
            try {
                thread.join(60000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            return arrayList;
        }
    }

    private Runnable createSearch(final String string, final List<SearchTOCItem> list) {
        Runnable runnable = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                if (null == JavaHelpQuery.this.engine) {
                    return;
                }
                final Object object = new Object();
                SearchQuery searchQuery = JavaHelpQuery.this.engine.createQuery();
                searchQuery.addSearchListener(new SearchListener(){

                    @Override
                    public void itemsFound(SearchEvent searchEvent) {
                        JavaHelpQuery.this.addItemsToList(searchEvent.getSearchItems(), list);
                    }

                    @Override
                    public void searchStarted(SearchEvent searchEvent) {
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void searchFinished(SearchEvent searchEvent) {
                        Object object2 = object;
                        synchronized (object2) {
                            object.notifyAll();
                        }
                    }
                });
                searchQuery.start(string, Locale.getDefault());
                Object object2 = object;
                synchronized (object2) {
                    try {
                        object.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                Collections.sort(list, JavaHelpQuery.this);
            }
        };
        return runnable;
    }

    private void addItemsToList(Enumeration enumeration, List<SearchTOCItem> list) {
        if (null == enumeration) {
            return;
        }
        while (enumeration.hasMoreElements()) {
            URL uRL;
            SearchItem searchItem = (SearchItem)enumeration.nextElement();
            try {
                uRL = new URL(searchItem.getBase(), searchItem.getFilename());
            }
            catch (MalformedURLException malformedURLException) {
                Logger.getLogger(JavaHelpQuery.class.getName()).log(Level.FINE, "Invalid URL in SearchItem: " + searchItem.getTitle(), malformedURLException);
                continue;
            }
            boolean bl = false;
            for (SearchTOCItem searchTOCItem : list) {
                URL uRL2 = searchTOCItem.getURL();
                if (uRL2 == null || uRL == null || !uRL.sameFile(uRL2)) continue;
                searchTOCItem.addSearchHit(new SearchHit(searchItem.getConfidence(), searchItem.getBegin(), searchItem.getEnd()));
                bl = true;
                break;
            }
            if (bl) continue;
            SearchTOCItem searchTOCItem = new SearchTOCItem(searchItem);
            list.add(searchTOCItem);
        }
    }

    @Override
    public int compare(SearchTOCItem searchTOCItem, SearchTOCItem searchTOCItem2) {
        int n = searchTOCItem2.hitCount() - searchTOCItem.hitCount();
        if (0 == n) {
            double d;
            double d2 = searchTOCItem.getConfidence();
            if (d2 < (d = searchTOCItem2.getConfidence())) {
                n = -11;
            } else if (d2 > d) {
                n = 1;
            }
        }
        return n;
    }

    private SearchEngine createSearchEngine() {
        JavaHelp javaHelp;
        SearchEngine searchEngine = null;
        Help help = (Help)Lookup.getDefault().lookup(Help.class);
        if (help != null && help instanceof JavaHelp && null == (searchEngine = (javaHelp = (JavaHelp)help).createSearchEngine())) {
            Logger.getLogger(JavaHelpQuery.class.getName()).log(Level.INFO, NbBundle.getMessage(JavaHelpQuery.class, (String)"Err_CreateJavaHelpSearchEngine"));
            searchEngine = new DummySearchEngine();
        }
        return searchEngine;
    }

    private static class DummySearchQuery
    extends SearchQuery {
        private List<SearchListener> listeners = new ArrayList<SearchListener>(1);

        public DummySearchQuery(DummySearchEngine dummySearchEngine) {
            super(dummySearchEngine);
        }

        @Override
        public void addSearchListener(SearchListener searchListener) {
            this.listeners.add(searchListener);
        }

        @Override
        public void removeSearchListener(SearchListener searchListener) {
            this.listeners.remove(searchListener);
        }

        @Override
        public void start(String string, Locale locale) throws IllegalArgumentException, IllegalStateException {
            SearchEvent searchEvent = new SearchEvent(this, "", false);
            for (SearchListener searchListener : this.listeners) {
                searchListener.searchStarted(searchEvent);
                searchListener.searchFinished(searchEvent);
            }
        }

        @Override
        public void stop() throws IllegalStateException {
        }

        @Override
        public boolean isActive() {
            return false;
        }
    }

    private static class DummySearchEngine
    extends SearchEngine {
        private DummySearchEngine() {
        }

        @Override
        public SearchQuery createQuery() throws IllegalStateException {
            return new DummySearchQuery(this);
        }
    }
}

