/*
 * Decompiled with CFR 0.152.
 */
package sun.rmi.transport.proxy;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import sun.rmi.runtime.Log;
import sun.rmi.transport.proxy.HttpReceiveSocket;
import sun.rmi.transport.proxy.RMIMasterSocketFactory;
import sun.rmi.transport.proxy.WrappedSocket;

class HttpAwareServerSocket
extends ServerSocket {
    public HttpAwareServerSocket(int n) throws IOException {
        super(n);
    }

    public HttpAwareServerSocket(int n, int n2) throws IOException {
        super(n, n2);
    }

    public Socket accept() throws IOException {
        Socket socket = super.accept();
        BufferedInputStream bufferedInputStream = new BufferedInputStream(socket.getInputStream());
        RMIMasterSocketFactory.proxyLog.log(Log.BRIEF, "socket accepted (checking for POST)");
        bufferedInputStream.mark(4);
        boolean bl = bufferedInputStream.read() == 80 && bufferedInputStream.read() == 79 && bufferedInputStream.read() == 83 && bufferedInputStream.read() == 84;
        bufferedInputStream.reset();
        if (RMIMasterSocketFactory.proxyLog.isLoggable(Log.BRIEF)) {
            RMIMasterSocketFactory.proxyLog.log(Log.BRIEF, bl ? "POST found, HTTP socket returned" : "POST not found, direct socket returned");
        }
        if (bl) {
            return new HttpReceiveSocket(socket, bufferedInputStream, null);
        }
        return new WrappedSocket(socket, bufferedInputStream, null);
    }

    public String toString() {
        return "HttpAware" + super.toString();
    }
}

