/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.util.jar.pack;

import com.sun.java.util.jar.pack.Attribute;
import com.sun.java.util.jar.pack.Code;
import com.sun.java.util.jar.pack.ConstantPool;
import com.sun.java.util.jar.pack.Constants;
import com.sun.java.util.jar.pack.Package;
import com.sun.java.util.jar.pack.Utils;
import java.io.DataInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Map;

class ClassReader
implements Constants {
    int verbose;
    Package pkg;
    Package.Class cls;
    long inPos;
    DataInputStream in;
    Map attrDefs;
    Map attrCommands;
    String unknownAttrCommand = "error";

    ClassReader(Package.Class clazz, InputStream inputStream) throws IOException {
        this.pkg = clazz.getPackage();
        this.cls = clazz;
        this.verbose = this.pkg.verbose;
        this.in = new DataInputStream(new FilterInputStream(inputStream){

            public int read(byte[] byArray, int n, int n2) throws IOException {
                int n3 = super.read(byArray, n, n2);
                if (n3 >= 0) {
                    ClassReader.this.inPos += (long)n3;
                }
                return n3;
            }

            public int read() throws IOException {
                int n = super.read();
                if (n >= 0) {
                    ++ClassReader.this.inPos;
                }
                return n;
            }

            public long skip(long l) throws IOException {
                long l2 = super.skip(l);
                if (l2 >= 0L) {
                    ClassReader.this.inPos += l2;
                }
                return l2;
            }
        });
    }

    public void setAttrDefs(Map map) {
        this.attrDefs = map;
    }

    public void setAttrCommands(Map map) {
        this.attrCommands = map;
    }

    private void skip(int n, String string) throws IOException {
        long l;
        long l2;
        Utils.log.warning("skipping " + n + " bytes of " + string);
        for (l = 0L; l < (long)n; l += l2) {
            l2 = this.in.skip((long)n - l);
            assert (l2 > 0L);
        }
        assert (l == (long)n);
    }

    private int readUnsignedShort() throws IOException {
        return this.in.readUnsignedShort();
    }

    private int readInt() throws IOException {
        return this.in.readInt();
    }

    private ConstantPool.Entry readRef() throws IOException {
        int n = this.in.readUnsignedShort();
        return n == 0 ? null : this.cls.cpMap[n];
    }

    private ConstantPool.Entry readRef(byte by) throws IOException {
        ConstantPool.Entry entry = this.readRef();
        assert (entry != null);
        assert (entry.tagMatches(by));
        return entry;
    }

    private ConstantPool.Entry readRefOrNull(byte by) throws IOException {
        ConstantPool.Entry entry = this.readRef();
        assert (entry == null || entry.tagMatches(by));
        return entry;
    }

    private ConstantPool.Utf8Entry readUtf8Ref() throws IOException {
        return (ConstantPool.Utf8Entry)this.readRef((byte)1);
    }

    private ConstantPool.ClassEntry readClassRef() throws IOException {
        return (ConstantPool.ClassEntry)this.readRef((byte)7);
    }

    private ConstantPool.ClassEntry readClassRefOrNull() throws IOException {
        return (ConstantPool.ClassEntry)this.readRefOrNull((byte)7);
    }

    private ConstantPool.SignatureEntry readSignatureRef() throws IOException {
        ConstantPool.Entry entry = this.readRef((byte)1);
        return ConstantPool.getSignatureEntry(entry.stringValue());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void read() throws IOException {
        boolean bl = false;
        try {
            this.readMagicNumbers();
            this.readConstantPool();
            this.readHeader();
            this.readMembers(false);
            this.readMembers(true);
            this.readAttributes(0, this.cls);
            this.cls.finishReading();
            assert (0 >= this.in.read(new byte[1]));
            bl = true;
        }
        finally {
            if (!bl && this.verbose > 0) {
                Utils.log.warning("Erroneous data at input offset " + this.inPos + " of " + this.cls.file);
            }
        }
    }

    void readMagicNumbers() throws IOException {
        this.cls.magic = this.in.readInt();
        if (this.cls.magic != -889275714) {
            throw new Attribute.FormatException("Bad magic number in class file " + Integer.toHexString(this.cls.magic), 0, "magic-number", "pass");
        }
        this.cls.minver = (short)this.readUnsignedShort();
        this.cls.majver = (short)this.readUnsignedShort();
        String string = this.checkVersion(this.cls.majver, this.cls.minver);
        if (string != null) {
            throw new Attribute.FormatException("classfile version too " + string + ": " + this.cls.majver + "." + this.cls.minver + " in " + this.cls.file, 0, "version", "pass");
        }
    }

    private String checkVersion(int n, int n2) {
        if (n < this.pkg.min_class_majver || n == this.pkg.min_class_majver && n2 < this.pkg.min_class_minver) {
            return "small";
        }
        if (n > this.pkg.max_class_majver || n == this.pkg.max_class_majver && n2 > this.pkg.max_class_minver) {
            return "large";
        }
        return null;
    }

    void readConstantPool() throws IOException {
        int n;
        int n2;
        int n3 = this.in.readUnsignedShort();
        int[] nArray = new int[n3 * 4];
        int n4 = 0;
        ConstantPool.Entry[] entryArray = new ConstantPool.Entry[n3];
        entryArray[0] = null;
        block15: for (n2 = 1; n2 < n3; ++n2) {
            n = this.in.readByte();
            switch (n) {
                case 1: {
                    entryArray[n2] = ConstantPool.getUtf8Entry(this.in.readUTF());
                    continue block15;
                }
                case 3: {
                    Number number = new Integer(this.in.readInt());
                    entryArray[n2] = ConstantPool.getLiteralEntry(number);
                    continue block15;
                }
                case 4: {
                    Number number = new Float(this.in.readFloat());
                    entryArray[n2] = ConstantPool.getLiteralEntry(number);
                    continue block15;
                }
                case 5: {
                    Number number = new Long(this.in.readLong());
                    entryArray[n2] = ConstantPool.getLiteralEntry(number);
                    entryArray[++n2] = null;
                    continue block15;
                }
                case 6: {
                    Number number = new Double(this.in.readDouble());
                    entryArray[n2] = ConstantPool.getLiteralEntry(number);
                    entryArray[++n2] = null;
                    continue block15;
                }
                case 7: 
                case 8: {
                    nArray[n4++] = n2;
                    nArray[n4++] = n;
                    nArray[n4++] = this.in.readUnsignedShort();
                    nArray[n4++] = -1;
                    continue block15;
                }
                case 9: 
                case 10: 
                case 11: 
                case 12: {
                    nArray[n4++] = n2;
                    nArray[n4++] = n;
                    nArray[n4++] = this.in.readUnsignedShort();
                    nArray[n4++] = this.in.readUnsignedShort();
                    continue block15;
                }
                default: {
                    throw new IOException("Bad constant pool tag " + n);
                }
            }
        }
        while (n4 > 0) {
            if (this.verbose > 3) {
                Utils.log.fine("CP fixups [" + n4 / 4 + "]");
            }
            n2 = n4;
            n4 = 0;
            n = 0;
            block17: while (n < n2) {
                int n5 = nArray[n++];
                int n6 = nArray[n++];
                int n7 = nArray[n++];
                int n8 = nArray[n++];
                if (this.verbose > 3) {
                    Utils.log.fine("  cp[" + n5 + "] = " + ConstantPool.tagName(n6) + "{" + n7 + "," + n8 + "}");
                }
                if (entryArray[n7] == null || n8 >= 0 && entryArray[n8] == null) {
                    nArray[n4++] = n5;
                    nArray[n4++] = n6;
                    nArray[n4++] = n7;
                    nArray[n4++] = n8;
                    continue;
                }
                switch (n6) {
                    case 7: {
                        entryArray[n5] = ConstantPool.getClassEntry(entryArray[n7].stringValue());
                        continue block17;
                    }
                    case 8: {
                        entryArray[n5] = ConstantPool.getStringEntry(entryArray[n7].stringValue());
                        continue block17;
                    }
                    case 9: 
                    case 10: 
                    case 11: {
                        ConstantPool.ClassEntry classEntry = (ConstantPool.ClassEntry)entryArray[n7];
                        ConstantPool.DescriptorEntry descriptorEntry = (ConstantPool.DescriptorEntry)entryArray[n8];
                        entryArray[n5] = ConstantPool.getMemberEntry((byte)n6, classEntry, descriptorEntry);
                        continue block17;
                    }
                    case 12: {
                        ConstantPool.Utf8Entry utf8Entry = (ConstantPool.Utf8Entry)entryArray[n7];
                        ConstantPool.Utf8Entry utf8Entry2 = (ConstantPool.Utf8Entry)entryArray[n8];
                        entryArray[n5] = ConstantPool.getDescriptorEntry(utf8Entry, utf8Entry2);
                        continue block17;
                    }
                }
                assert (false);
            }
            assert (n4 < n2);
        }
        this.cls.cpMap = entryArray;
    }

    void readHeader() throws IOException {
        this.cls.flags = this.readUnsignedShort();
        this.cls.thisClass = this.readClassRef();
        this.cls.superClass = this.readClassRefOrNull();
        int n = this.readUnsignedShort();
        this.cls.interfaces = new ConstantPool.ClassEntry[n];
        for (int i = 0; i < n; ++i) {
            this.cls.interfaces[i] = this.readClassRef();
        }
    }

    void readMembers(boolean bl) throws IOException {
        int n = this.readUnsignedShort();
        for (int i = 0; i < n; ++i) {
            this.readMember(bl);
        }
    }

    void readMember(boolean bl) throws IOException {
        Package.Class.Member member;
        int n = this.readUnsignedShort();
        ConstantPool.Utf8Entry utf8Entry = this.readUtf8Ref();
        ConstantPool.SignatureEntry signatureEntry = this.readSignatureRef();
        ConstantPool.DescriptorEntry descriptorEntry = ConstantPool.getDescriptorEntry(utf8Entry, signatureEntry);
        if (!bl) {
            Package.Class clazz = this.cls;
            clazz.getClass();
            member = new Package.Class.Field(clazz, n, descriptorEntry);
        } else {
            Package.Class clazz = this.cls;
            clazz.getClass();
            member = new Package.Class.Method(clazz, n, descriptorEntry);
        }
        this.readAttributes(!bl ? 1 : 2, member);
    }

    void readAttributes(int n, Attribute.Holder holder) throws IOException {
        int n2 = this.readUnsignedShort();
        if (n2 == 0) {
            return;
        }
        if (this.verbose > 3) {
            Utils.log.fine("readAttributes " + holder + " [" + n2 + "]");
        }
        for (int i = 0; i < n2; ++i) {
            boolean bl;
            Object object;
            String string = this.readUtf8Ref().stringValue();
            int n3 = this.readInt();
            if (this.attrCommands != null) {
                object = Attribute.keyForLookup(n, string);
                String string2 = (String)this.attrCommands.get(object);
                if (string2 == "pass") {
                    String string3 = "passing attribute bitwise in " + holder;
                    throw new Attribute.FormatException(string3, n, string, string2);
                }
                if (string2 == "error") {
                    String string4 = "attribute not allowed in " + holder;
                    throw new Attribute.FormatException(string4, n, string, string2);
                }
                if (string2 == "strip") {
                    this.skip(n3, string + " attribute in " + holder);
                    continue;
                }
            }
            object = Attribute.lookup(Package.attrDefs, n, string);
            if (this.verbose > 4 && object != null) {
                Utils.log.fine("pkg_attribute_lookup " + string + " = " + object);
            }
            if (object == null) {
                object = Attribute.lookup(this.attrDefs, n, string);
                if (this.verbose > 4 && object != null) {
                    Utils.log.fine("this " + string + " = " + object);
                }
            }
            if (object == null) {
                object = Attribute.lookup(null, n, string);
                if (this.verbose > 4 && object != null) {
                    Utils.log.fine("null_attribute_lookup " + string + " = " + object);
                }
            }
            if (object == null && n3 == 0) {
                object = Attribute.find(n, string, "");
            }
            boolean bl2 = bl = n == 3 && (string.equals("StackMap") || string.equals("StackMapX"));
            if (bl) {
                Code code = (Code)holder;
                if (code.max_stack >= 65536 || code.max_locals >= 65536 || code.getLength() >= 65536 || string.endsWith("X")) {
                    object = null;
                }
            }
            if (object == null) {
                if (bl) {
                    String string5 = "unsupported StackMap variant in " + holder;
                    throw new Attribute.FormatException(string5, n, string, "pass");
                }
                if (this.unknownAttrCommand == "strip") {
                    this.skip(n3, "unknown " + string + " attribute in " + holder);
                    continue;
                }
                String string6 = "unknown in " + holder;
                throw new Attribute.FormatException(string6, n, string, this.unknownAttrCommand);
            }
            if (((Attribute)object).layout() == Package.attrCodeEmpty || ((Attribute)object).layout() == Package.attrInnerClassesEmpty) {
                long l = this.inPos;
                if (((Attribute)object).name() == "Code") {
                    Package.Class.Method method = (Package.Class.Method)holder;
                    method.code = new Code(method);
                    this.readCode(method.code);
                } else {
                    assert (holder == this.cls);
                    this.readInnerClasses(this.cls);
                }
                assert ((long)n3 == this.inPos - l);
            } else if (n3 > 0) {
                byte[] byArray = new byte[n3];
                this.in.readFully(byArray);
                object = ((Attribute)object).addContent(byArray);
            }
            holder.addAttribute((Attribute)object);
            if (this.verbose <= 2) continue;
            Utils.log.fine("read " + object);
        }
    }

    void readCode(Code code) throws IOException {
        code.max_stack = this.readUnsignedShort();
        code.max_locals = this.readUnsignedShort();
        code.bytes = new byte[this.readInt()];
        this.in.readFully(code.bytes);
        int n = this.readUnsignedShort();
        code.setHandlerCount(n);
        for (int i = 0; i < n; ++i) {
            code.handler_start[i] = this.readUnsignedShort();
            code.handler_end[i] = this.readUnsignedShort();
            code.handler_catch[i] = this.readUnsignedShort();
            code.handler_class[i] = this.readClassRefOrNull();
        }
        this.readAttributes(3, code);
    }

    void readInnerClasses(Package.Class clazz) throws IOException {
        int n = this.readUnsignedShort();
        ArrayList<Package.InnerClass> arrayList = new ArrayList<Package.InnerClass>(n);
        for (int i = 0; i < n; ++i) {
            Package.InnerClass innerClass = new Package.InnerClass(this.readClassRef(), this.readClassRefOrNull(), (ConstantPool.Utf8Entry)this.readRefOrNull((byte)1), this.readUnsignedShort());
            arrayList.add(innerClass);
        }
        clazz.innerClasses = arrayList;
    }
}

