/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.ui.notifications;

import java.awt.event.ActionListener;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.CharConversionException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import org.netbeans.core.ui.notifications.NotificationImpl;
import org.openide.awt.Notification;
import org.openide.awt.NotificationDisplayer;
import org.openide.util.Lookup;
import org.openide.util.Parameters;
import org.openide.xml.XMLUtil;

public final class NotificationDisplayerImpl
extends NotificationDisplayer {
    static final String PROP_NOTIFICATION_ADDED = "notificationAdded";
    static final String PROP_NOTIFICATION_REMOVED = "notificationRemoved";
    private final List<NotificationImpl> model = new LinkedList<NotificationImpl>();
    private final PropertyChangeSupport propSupport = new PropertyChangeSupport((Object)this);

    static NotificationDisplayerImpl getInstance() {
        return (NotificationDisplayerImpl)((Object)Lookup.getDefault().lookup(NotificationDisplayer.class));
    }

    public Notification notify(String string, Icon icon, String string2, ActionListener actionListener, NotificationDisplayer.Priority priority) {
        Parameters.notNull((CharSequence)"detailsText", (Object)string2);
        NotificationImpl notificationImpl = this.createNotification(string, icon, priority);
        notificationImpl.setDetails(string2, actionListener);
        this.add(notificationImpl);
        return notificationImpl;
    }

    public Notification notify(String string, Icon icon, JComponent jComponent, JComponent jComponent2, NotificationDisplayer.Priority priority) {
        Parameters.notNull((CharSequence)"balloonDetails", (Object)jComponent);
        Parameters.notNull((CharSequence)"popupDetails", (Object)jComponent2);
        NotificationImpl notificationImpl = this.createNotification(string, icon, priority);
        notificationImpl.setDetails(jComponent, jComponent2);
        this.add(notificationImpl);
        return notificationImpl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void add(NotificationImpl notificationImpl) {
        List<NotificationImpl> list = this.model;
        synchronized (list) {
            this.model.add(notificationImpl);
            Collections.sort(this.model);
        }
        this.firePropertyChange(PROP_NOTIFICATION_ADDED, notificationImpl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void remove(NotificationImpl notificationImpl) {
        List<NotificationImpl> list = this.model;
        synchronized (list) {
            if (!this.model.contains(notificationImpl)) {
                return;
            }
            this.model.remove(notificationImpl);
        }
        this.firePropertyChange(PROP_NOTIFICATION_REMOVED, notificationImpl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int size() {
        List<NotificationImpl> list = this.model;
        synchronized (list) {
            return this.model.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<NotificationImpl> getNotifications() {
        ArrayList<NotificationImpl> arrayList = null;
        List<NotificationImpl> list = this.model;
        synchronized (list) {
            arrayList = new ArrayList<NotificationImpl>(this.model);
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    NotificationImpl getTopNotification() {
        NotificationImpl notificationImpl = null;
        List<NotificationImpl> list = this.model;
        synchronized (list) {
            if (!this.model.isEmpty()) {
                notificationImpl = this.model.get(0);
            }
        }
        return notificationImpl;
    }

    void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.propSupport.addPropertyChangeListener(propertyChangeListener);
    }

    void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.propSupport.removePropertyChangeListener(propertyChangeListener);
    }

    private void firePropertyChange(final String string, final NotificationImpl notificationImpl) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                if (NotificationDisplayerImpl.PROP_NOTIFICATION_ADDED.equals(string)) {
                    notificationImpl.initDecorations();
                }
                NotificationDisplayerImpl.this.propSupport.firePropertyChange(string, null, notificationImpl);
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            runnable.run();
        } else {
            SwingUtilities.invokeLater(runnable);
        }
    }

    private NotificationImpl createNotification(String string, Icon icon, NotificationDisplayer.Priority priority) {
        Parameters.notNull((CharSequence)"title", (Object)string);
        Parameters.notNull((CharSequence)"icon", (Object)icon);
        Parameters.notNull((CharSequence)"priority", (Object)priority);
        try {
            string = XMLUtil.toElementContent((String)string);
        }
        catch (CharConversionException charConversionException) {
            throw new IllegalArgumentException(charConversionException);
        }
        return new NotificationImpl(string, icon, priority);
    }
}

