/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.utils;

import org.netbeans.lib.profiler.utils.Wildcards;

public class MethodNameFormatter {
    private static final String BOOLEAN_TEXT = "boolean";
    private static final String CHAR_TEXT = "char";
    private static final String BYTE_TEXT = "byte";
    private static final String SHORT_TEXT = "short";
    private static final String INT_TEXT = "int";
    private static final String LONG_TEXT = "long";
    private static final String FLOAT_TEXT = "float";
    private static final String DOUBLE_TEXT = "double";
    private static final String VOID_TEXT = "void";
    private static final char BOOLEAN_CODE = 'Z';
    private static final char CHAR_CODE = 'C';
    private static final char BYTE_CODE = 'B';
    private static final char SHORT_CODE = 'S';
    private static final char INT_CODE = 'I';
    private static final char LONG_CODE = 'J';
    private static final char FLOAT_CODE = 'F';
    private static final char DOUBLE_CODE = 'D';
    private static final char VOID_CODE = 'V';
    private String className;
    private String methodName;
    private String params;
    private String returnType;

    public MethodNameFormatter(String string, String string2, String string3) {
        StringBuffer stringBuffer = new StringBuffer();
        this.className = string != null ? string.replace('/', '.') : "<unknown class>";
        if (string2 == null) {
            this.params = "";
            this.returnType = "";
        } else {
            this.methodName = "".equals(string2) ? "<init>" : string2;
            if ("<clinit>".equals(this.methodName) || Wildcards.isMethodWildcard(this.methodName)) {
                this.params = "";
                this.returnType = "";
            } else {
                char c;
                int n;
                int n2 = string3.lastIndexOf(41) + 1;
                if (n2 > 0 && !"<init>".equals(this.methodName)) {
                    this.returnType = string3.substring(n2);
                    n = 0;
                    while (this.returnType.charAt(n) == '[') {
                        stringBuffer.append("[]");
                        ++n;
                    }
                    if ((c = this.returnType.charAt(n++)) == 'Z') {
                        this.returnType = BOOLEAN_TEXT + stringBuffer.toString();
                    } else if (c == 'C') {
                        this.returnType = CHAR_TEXT + stringBuffer.toString();
                    } else if (c == 'B') {
                        this.returnType = BYTE_TEXT + stringBuffer.toString();
                    } else if (c == 'S') {
                        this.returnType = SHORT_TEXT + stringBuffer.toString();
                    } else if (c == 'I') {
                        this.returnType = INT_TEXT + stringBuffer.toString();
                    } else if (c == 'J') {
                        this.returnType = LONG_TEXT + stringBuffer.toString();
                    } else if (c == 'F') {
                        this.returnType = FLOAT_TEXT + stringBuffer.toString();
                    } else if (c == 'D') {
                        this.returnType = DOUBLE_TEXT + stringBuffer.toString();
                    } else if (c == 'V') {
                        this.returnType = VOID_TEXT + stringBuffer.toString();
                    } else {
                        this.returnType = this.returnType.substring(n, this.returnType.length() - 1);
                        if (this.returnType.startsWith("java/lang/") && this.returnType.indexOf(47, 10) == -1) {
                            this.returnType = this.returnType.substring(10);
                        }
                        this.returnType = this.returnType.replace('$', '.');
                        this.returnType = this.returnType.replace('/', '.') + stringBuffer.toString();
                    }
                } else {
                    this.returnType = "";
                }
                n2 = string3.indexOf(40) + 1;
                int n3 = string3.lastIndexOf(41);
                if (n3 > 0) {
                    String string4 = string3.substring(n2, n3);
                    StringBuffer stringBuffer2 = new StringBuffer();
                    stringBuffer.setLength(0);
                    n = 0;
                    while (n < string4.length()) {
                        while (string4.charAt(n) == '[') {
                            stringBuffer.append("[]");
                            ++n;
                        }
                        if ((c = string4.charAt(n++)) == 'Z') {
                            stringBuffer2.append(BOOLEAN_TEXT);
                        } else if (c == 'C') {
                            stringBuffer2.append(CHAR_TEXT);
                        } else if (c == 'B') {
                            stringBuffer2.append(BYTE_TEXT);
                        } else if (c == 'S') {
                            stringBuffer2.append(SHORT_TEXT);
                        } else if (c == 'I') {
                            stringBuffer2.append(INT_TEXT);
                        } else if (c == 'J') {
                            stringBuffer2.append(LONG_TEXT);
                        } else if (c == 'F') {
                            stringBuffer2.append(FLOAT_TEXT);
                        } else if (c == 'D') {
                            stringBuffer2.append(DOUBLE_TEXT);
                        } else {
                            int n4 = n;
                            while (string4.charAt(n) != ';') {
                                ++n;
                            }
                            String string5 = string4.substring(n4, n);
                            if (string5.startsWith("java/lang/") && string5.indexOf(47, 10) == -1) {
                                string5 = string5.substring(10);
                            }
                            string5 = string5.replace('$', '.');
                            string5 = string5.replace('/', '.');
                            stringBuffer2.append(string5);
                            ++n;
                        }
                        if (stringBuffer.length() > 0) {
                            stringBuffer2.append(stringBuffer.toString());
                        }
                        stringBuffer.setLength(0);
                        if (n >= string4.length()) continue;
                        stringBuffer2.append(", ");
                    }
                    this.params = stringBuffer2.toString();
                } else {
                    this.params = "";
                }
            }
        }
    }

    public String getFormattedClass() {
        return this.className;
    }

    public String getFormattedClassAndMethod() {
        if (this.methodName == null) {
            return this.getFormattedClass();
        }
        return this.className + "." + this.getFormattedMethod();
    }

    public String getFormattedMethod() {
        if (this.methodName == null) {
            return "";
        }
        if ("<clinit>".equals(this.methodName)) {
            return this.methodName;
        }
        return this.methodName + "(" + this.getParamsString() + ")";
    }

    public String getFullFormattedClassAndMethod() {
        if (this.methodName == null) {
            return this.getFormattedClass();
        }
        return this.className + "." + this.getFullFormattedMethod();
    }

    public String getFullFormattedMethod() {
        if (this.methodName == null) {
            return "";
        }
        if ("<clinit>".equals(this.methodName)) {
            return this.methodName;
        }
        if ("<init>".equals(this.methodName)) {
            return this.methodName + "(" + this.getParamsString() + ")";
        }
        return this.methodName + "(" + this.getParamsString() + ") : " + this.getReturnType();
    }

    public String getParamsString() {
        return this.params;
    }

    public String getReturnType() {
        return this.returnType;
    }

    public String toString() {
        return this.getFullFormattedClassAndMethod();
    }

    private boolean isAllWildCard(String string) {
        return string.equals("<all>") || string.equals("*");
    }
}

