/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.results.cpu.cct;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.Stack;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.lib.profiler.marker.Mark;
import org.netbeans.lib.profiler.results.cpu.cct.CPUCCTVisitorAdapter;
import org.netbeans.lib.profiler.results.cpu.cct.nodes.MarkedCPUCCTNode;
import org.netbeans.lib.profiler.results.cpu.cct.nodes.ThreadCPUCCTNode;

public final class CCTResultsFilter
extends CPUCCTVisitorAdapter {
    private static final Logger LOGGER = Logger.getLogger(CCTResultsFilter.class.getName());
    private Set evaluators = null;
    private Set evaluatorProviders = new HashSet();
    private Stack passFlagStack;
    private boolean passingFilter;

    public CCTResultsFilter() {
        this.evaluators = new HashSet();
        this.passFlagStack = new Stack();
        this.doReset();
    }

    public void setEvaluators(Collection collection) {
        this.evaluatorProviders.clear();
        this.evaluatorProviders.addAll(collection);
    }

    public synchronized boolean passesFilter() {
        return this.passingFilter;
    }

    @Override
    public void beforeWalk() {
        super.beforeWalk();
        this.evaluators.clear();
        Iterator iterator = this.evaluatorProviders.iterator();
        while (iterator.hasNext()) {
            this.evaluators.addAll(((EvaluatorProvider)iterator.next()).getEvaluators());
        }
    }

    @Override
    public void afterWalk() {
        this.evaluators.clear();
        super.afterWalk();
    }

    public void reset() {
        this.doReset();
    }

    @Override
    public void visit(ThreadCPUCCTNode threadCPUCCTNode) {
        LOGGER.finest("visiting thread node");
        this.passFlagStack.push(this.passingFilter);
        this.passingFilter = true;
        for (Evaluator evaluator : this.evaluators) {
            this.passingFilter &= evaluator.evaluate(Mark.DEFAULT);
        }
        LOGGER.finest("Evaluator result: " + this.passingFilter);
        super.visit(threadCPUCCTNode);
    }

    @Override
    public void visit(MarkedCPUCCTNode markedCPUCCTNode) {
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.finest("Entering a node marked " + markedCPUCCTNode.getMark().getId());
        }
        this.passFlagStack.push(this.passingFilter);
        this.passingFilter = true;
        for (Evaluator evaluator : this.evaluators) {
            this.passingFilter &= evaluator.evaluate(markedCPUCCTNode.getMark());
        }
    }

    @Override
    public void visitPost(ThreadCPUCCTNode threadCPUCCTNode) {
        super.visitPost(threadCPUCCTNode);
        if (!this.passFlagStack.isEmpty()) {
            this.passingFilter = (Boolean)this.passFlagStack.pop();
        }
    }

    @Override
    public void visitPost(MarkedCPUCCTNode markedCPUCCTNode) {
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.finest("Leaving a node marked " + markedCPUCCTNode.getMark().getId());
        }
        if (!this.passFlagStack.isEmpty()) {
            this.passingFilter = (Boolean)this.passFlagStack.pop();
        }
    }

    private void doReset() {
        this.passingFilter = false;
        this.passFlagStack.clear();
    }

    public static interface EvaluatorProvider {
        public Set getEvaluators();
    }

    public static interface Evaluator {
        public boolean evaluate(Mark var1);
    }
}

