/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.visualvm.modules.appui;

import com.sun.tools.visualvm.modules.appui.about.AboutDialog;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Locale;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.jar.Manifest;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import org.openide.util.Enumerations;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;
import org.openide.windows.WindowManager;

public final class AboutAction
extends AbstractAction {
    private static final Logger LOGGER = Logger.getLogger(AboutAction.class.getName());
    private String versionString = System.getProperty("java.version");
    private AboutDialog aboutDialog;
    private String buildNumber;
    private String details;

    public AboutAction() {
        this.putValue("Name", NbBundle.getMessage(AboutAction.class, (String)"CTL_AboutAction"));
        this.putValue("noIconInMenu", Boolean.TRUE);
    }

    public void actionPerformed(ActionEvent e) {
        AboutDialog ad = this.getAboutDialog();
        if (ad != null) {
            ad.show();
        }
    }

    static AboutAction getMenuAction() {
        if (Utilities.isMac()) {
            return null;
        }
        return new AboutAction();
    }

    private AboutDialog getAboutDialog() {
        if (this.aboutDialog == null) {
            try {
                URL imageURL = this.getClass().getResource("/com/sun/tools/visualvm/modules/appui/about/image.png");
                Image splashImage = Toolkit.getDefaultToolkit().createImage(imageURL);
                this.aboutDialog = AboutDialog.createInstance(WindowManager.getDefault().getMainWindow(), splashImage);
                this.aboutDialog.setCaption(NbBundle.getMessage(AboutAction.class, (String)"LBL_About_VisualVM"));
                this.aboutDialog.setBuildID(NbBundle.getMessage(AboutAction.class, (String)"LBL_Version_Build", (Object[])new Object[]{this.versionString, this.getBuildNumber()}));
                this.aboutDialog.setDetails(this.getDetails());
                this.aboutDialog.setLogfile(this.getLogfile());
            }
            catch (Exception e) {
                LOGGER.throwing(AboutAction.class.getName(), "getAboutDialog", e);
            }
        }
        return this.aboutDialog;
    }

    private String getBuildNumber() {
        if (this.buildNumber == null) {
            this.buildNumber = "unknown";
            try {
                InputStream manifestStream = this.getClass().getResourceAsStream("/META-INF/MANIFEST.MF");
                this.buildNumber = new Manifest(manifestStream).getMainAttributes().getValue("OpenIDE-Module-Implementation-Version");
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return this.buildNumber;
    }

    private String getLogfile() {
        String sep = File.separator;
        String logfilePath = System.getProperty("netbeans.user") + sep + "var" + sep + "log" + sep + "messages.log";
        File logfile = new File(logfilePath);
        if (logfile.exists() && logfile.isFile() && logfile.canRead()) {
            return logfile.getAbsolutePath();
        }
        return null;
    }

    private String getDetails() {
        if (this.details == null) {
            StringBuffer sb = new StringBuffer();
            sb.append("<table border=\"0\">");
            sb.append("<tr>");
            sb.append("<td valign=\"top\" nowrap><b>Version: </b></td>");
            sb.append("<td valign=\"top\" nowrap>" + this.versionString + " (Build 1320-" + this.getBuildNumber() + "); platform " + System.getProperty("netbeans.buildnumber") + "</td>");
            sb.append("</tr>");
            sb.append("<tr>");
            sb.append("<td valign=\"top\" nowrap><b>System: </b></td>");
            sb.append("<td valign=\"top\" nowrap>" + AboutAction.getOSInfo() + "</td>");
            sb.append("</tr>");
            sb.append("<tr>");
            sb.append("<td valign=\"top\" nowrap><b>Java: </b></td>");
            sb.append("<td valign=\"top\" nowrap>" + AboutAction.getJavaInfo() + "</td>");
            sb.append("</tr>");
            sb.append("<tr>");
            sb.append("<td valign=\"top\" nowrap><b>Vendor: </b></td>");
            sb.append("<td valign=\"top\" nowrap>" + AboutAction.getJavaVendor() + "</td>");
            sb.append("</tr>");
            sb.append("<tr>");
            sb.append("<td valign=\"top\" nowrap><b>Environment: </b></td>");
            sb.append("<td valign=\"top\" nowrap>" + AboutAction.getEnvironment() + "</td>");
            sb.append("</tr>");
            sb.append("<tr>");
            sb.append("<td valign=\"top\" nowrap><b>Userdir: </b></td>");
            sb.append("<td valign=\"top\" nowrap>" + System.getProperty("netbeans.user", "unknown") + "</td>");
            sb.append("</tr>");
            sb.append("<tr>");
            sb.append("<td valign=\"top\" nowrap><b>Clusters: </b></td>");
            sb.append("<td valign=\"top\" nowrap>" + AboutAction.getIDEInstallValue() + "</td>");
            sb.append("</tr>");
            sb.append("</table>");
            sb.append("<div style='margin: 4px; margin-top: 15px; margin-bottom: 0px;'>");
            sb.append(NbBundle.getMessage(AboutAction.class, (String)"MSG_Html_License"));
            sb.append("</div>");
            this.details = sb.toString();
        }
        return this.details;
    }

    private static String getOSInfo() {
        Properties systemProperties = System.getProperties();
        String osName = systemProperties.getProperty("os.name", "&lt;not available&gt;");
        String osVersion = systemProperties.getProperty("os.version", "");
        String patchLevel = systemProperties.getProperty("sun.os.patch.level", "");
        String osArch = systemProperties.getProperty("os.arch", "&lt;not available&gt;");
        String sunArch = systemProperties.getProperty("sun.arch.data.model", "?") + "bit";
        return osName + " (" + osVersion + ") " + ("unknown".equals(patchLevel) ? "" : patchLevel) + ", " + osArch + " " + sunArch;
    }

    private static String getJavaInfo() {
        Properties systemProperties = System.getProperties();
        String javaVersion = systemProperties.getProperty("java.version", "unknown");
        String vmName = systemProperties.getProperty("java.vm.name", "&lt;not available&gt;");
        String vmVerison = systemProperties.getProperty("java.vm.version", "");
        String vmInfo = systemProperties.getProperty("java.vm.info", "");
        return javaVersion + "; " + vmName + " (" + vmVerison + ", " + vmInfo + ")";
    }

    private static String getJavaVendor() {
        Properties systemProperties = System.getProperties();
        String javaVendor = systemProperties.getProperty("java.vendor", "unknown");
        String javaVendorUrl = systemProperties.getProperty("java.vendor.url", null);
        return javaVendor + (javaVendorUrl == null ? "" : ", " + javaVendorUrl);
    }

    private static String getEnvironment() {
        String branding = NbBundle.getBranding();
        String encoding = System.getProperty("file.encoding", "unknown");
        String locale = Locale.getDefault().toString() + (branding == null ? "" : " (" + branding + ")");
        return encoding + "; " + locale;
    }

    private static String getIDEInstallValue() {
        String nbhome = System.getProperties().getProperty("netbeans.home");
        String nbdirs = System.getProperty("netbeans.dirs");
        Enumeration<Object> more = nbdirs != null ? new StringTokenizer(nbdirs, File.pathSeparator) : Enumerations.empty();
        Enumeration all = Enumerations.concat((Enumeration)Enumerations.singleton((Object)nbhome), (Enumeration)more);
        HashSet<File> files = new HashSet<File>();
        StringBuilder sb = new StringBuilder();
        String prefix = "";
        while (all.hasMoreElements()) {
            File f;
            String s = (String)all.nextElement();
            if (s == null || !files.add(f = new File(s))) continue;
            sb.append(prefix);
            try {
                sb.append(f.getCanonicalPath());
            }
            catch (IOException e) {
                sb.append(f.getAbsolutePath());
            }
            prefix = "\n";
        }
        return sb.toString();
    }
}

