/*
 * Decompiled with CFR 0.152.
 */
package org.openide.explorer.view;

import java.awt.Dialog;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragGestureRecognizer;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.dnd.InvalidDnDOperationException;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.util.TooManyListenersException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import org.openide.explorer.view.DragDropUtilities;
import org.openide.explorer.view.ExplorerDnDManager;
import org.openide.explorer.view.NodeRenderer;
import org.openide.nodes.Node;
import org.openide.util.Exceptions;
import org.openide.util.Utilities;

abstract class ExplorerDragSupport
implements DragSourceListener,
DragGestureListener {
    boolean active = false;
    DragGestureRecognizer defaultGesture;
    protected JComponent comp;
    ExplorerDnDManager exDnD = ExplorerDnDManager.getDefault();

    ExplorerDragSupport() {
    }

    abstract int getAllowedDropActions();

    @Override
    public void dragGestureRecognized(DragGestureEvent dragGestureEvent) {
        int n;
        MouseEvent mouseEvent;
        Node[] nodeArray;
        if (Utilities.getOperatingSystem() == 4096 && (nodeArray = dragGestureEvent.getTriggerEvent()) instanceof MouseEvent && (mouseEvent = (MouseEvent)nodeArray).getButton() == 3) {
            return;
        }
        nodeArray = this.obtainNodes(dragGestureEvent);
        if (nodeArray == null || nodeArray.length == 0) {
            return;
        }
        int n2 = this.getAllowedDragActions();
        for (n = 0; n < nodeArray.length; ++n) {
            if ((n2 & 2) != 0 && !nodeArray[n].canCut()) {
                n2 = 0x40000001;
            }
            if ((n2 & 1) == 0 || nodeArray[n].canCopy()) continue;
            n2 = 0;
        }
        this.exDnD = ExplorerDnDManager.getDefault();
        this.exDnD.setNodeAllowedActions(n2);
        n = dragGestureEvent.getDragAction();
        boolean bl = this.canDrag(n, n2);
        try {
            Transferable transferable;
            if ((n2 & 2) != 0) {
                transferable = DragDropUtilities.getNodeTransferable(nodeArray, 2);
                this.exDnD.setDraggedTransferable(transferable, true);
                transferable = DragDropUtilities.getNodeTransferable(nodeArray, 1);
                this.exDnD.setDraggedTransferable(transferable, false);
            } else if ((n2 & 1) != 0) {
                transferable = DragDropUtilities.getNodeTransferable(nodeArray, 1);
                this.exDnD.setDraggedTransferable(transferable, false);
            } else {
                transferable = Node.EMPTY.drag();
                this.exDnD.setDraggedTransferable(transferable, false);
            }
            this.exDnD.setDraggedNodes(nodeArray);
            Dialog dialog = (Dialog)SwingUtilities.getAncestorOfClass(Dialog.class, this.comp);
            if (dialog != null && dialog.isModal()) {
                this.exDnD.setDnDActive(false);
                return;
            }
            this.exDnD.setDnDActive(true);
            dragGestureEvent.startDrag(null, transferable, this);
        }
        catch (InvalidDnDOperationException invalidDnDOperationException) {
            Logger.getLogger(ExplorerDragSupport.class.getName()).log(Level.WARNING, null, invalidDnDOperationException);
            this.exDnD.setDnDActive(false);
        }
        catch (IOException iOException) {
            Exceptions.printStackTrace((Throwable)iOException);
            this.exDnD.setDnDActive(false);
        }
    }

    protected int getAllowedDragActions() {
        return 0;
    }

    private boolean canDrag(int n, int n2) {
        return (n2 & n) != 0;
    }

    @Override
    public void dragEnter(DragSourceDragEvent dragSourceDragEvent) {
        this.doDragOver(dragSourceDragEvent);
    }

    @Override
    public void dragOver(DragSourceDragEvent dragSourceDragEvent) {
        this.doDragOver(dragSourceDragEvent);
    }

    @Override
    public void dropActionChanged(DragSourceDragEvent dragSourceDragEvent) {
    }

    @Override
    public void dragExit(DragSourceEvent dragSourceEvent) {
    }

    private void doDragOver(DragSourceDragEvent dragSourceDragEvent) {
    }

    @Override
    public void dragDropEnd(DragSourceDropEvent dragSourceDropEvent) {
        this.exDnD.setDraggedTransferable(null, true);
        this.exDnD.setDraggedTransferable(null, false);
        this.exDnD.setDraggedNodes(null);
        NodeRenderer.dragExit();
        this.exDnD.setDnDActive(false);
    }

    public void activate(boolean bl) {
        if (this.active == bl) {
            return;
        }
        this.active = bl;
        DragGestureRecognizer dragGestureRecognizer = this.getDefaultGestureRecognizer();
        if (bl) {
            dragGestureRecognizer.setSourceActions(this.getAllowedDragActions());
            try {
                dragGestureRecognizer.removeDragGestureListener(this);
                dragGestureRecognizer.addDragGestureListener(this);
            }
            catch (TooManyListenersException tooManyListenersException) {
                throw new IllegalStateException("Too many listeners for drag gesture.");
            }
        } else {
            dragGestureRecognizer.removeDragGestureListener(this);
        }
    }

    DragGestureRecognizer getDefaultGestureRecognizer() {
        if (this.defaultGesture == null) {
            DragSource dragSource = DragSource.getDefaultDragSource();
            this.defaultGesture = dragSource.createDefaultDragGestureRecognizer(this.comp, this.getAllowedDragActions(), this);
        }
        return this.defaultGesture;
    }

    abstract Node[] obtainNodes(DragGestureEvent var1);
}

