/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Set;
import java.util.jar.Manifest;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.Events;
import org.netbeans.InvalidException;
import org.netbeans.Module;
import org.netbeans.ModuleManager;
import org.netbeans.NetigsoFramework;
import org.netbeans.ProxyClassLoader;
import org.openide.modules.SpecificationVersion;
import org.openide.util.Exceptions;

final class NetigsoModule
extends Module {
    static final Logger LOG = Logger.getLogger(NetigsoModule.class.getPackage().getName());
    private File jar;
    private Manifest manifest;

    public NetigsoModule(Manifest manifest, File file, ModuleManager moduleManager, Events events, Object object, boolean bl, boolean bl2, boolean bl3) throws IOException {
        super(moduleManager, events, object, bl, bl2, bl3);
        this.jar = file;
        this.manifest = manifest;
    }

    @Override
    public String[] getProvides() {
        return new String[0];
    }

    @Override
    public String getCodeName() {
        return this.getCodeNameBase();
    }

    @Override
    public String getCodeNameBase() {
        String string = this.getMainAttribute("Bundle-SymbolicName");
        return string.replace('-', '_');
    }

    @Override
    public int getCodeNameRelease() {
        String string = this.getMainAttribute("Bundle-SymbolicName");
        int n = string.lastIndexOf(47);
        if (n != -1) {
            return Integer.parseInt(string.substring(n + 1));
        }
        return -1;
    }

    @Override
    public SpecificationVersion getSpecificationVersion() {
        String string = this.getMainAttribute("Bundle-Version");
        if (string == null) {
            LOG.log(Level.WARNING, "No Bundle-Version for {0}", this.jar);
            return new SpecificationVersion("0.0");
        }
        int n = -1;
        for (int i = 0; i < 3; ++i) {
            if ((n = string.indexOf(46, n + 1)) != -1) continue;
            return new SpecificationVersion(string);
        }
        return new SpecificationVersion(string.substring(0, n));
    }

    public String getImplementationVersion() {
        String string = super.getImplementationVersion();
        return string != null ? string : this.getMainAttribute("Bundle-Version");
    }

    @Override
    protected void parseManifest() throws InvalidException {
        throw new UnsupportedOperationException();
    }

    @Override
    public File getJarFile() {
        return this.jar;
    }

    @Override
    public List<File> getAllJars() {
        return Collections.singletonList(this.jar);
    }

    @Override
    public void setReloadable(boolean bl) {
        this.reloadable = true;
    }

    @Override
    public void reload() throws IOException {
        NetigsoFramework.getDefault().reload(this);
    }

    final void start() throws IOException {
        ProxyClassLoader proxyClassLoader = (ProxyClassLoader)this.classloader;
        Set<String> set = NetigsoFramework.getDefault().createLoader(this, proxyClassLoader, this.jar);
        proxyClassLoader.addCoveredPackages(set);
    }

    @Override
    protected void classLoaderUp(Set<Module> set) throws IOException {
        assert (this.classloader == null);
        this.classloader = new DelegateCL();
        NetigsoFramework.classLoaderUp(this);
    }

    @Override
    protected void classLoaderDown() {
        LOG.log(Level.FINE, "classLoaderDown {0}", this.getCodeNameBase());
        ProxyClassLoader proxyClassLoader = (ProxyClassLoader)this.classloader;
        ClassLoader classLoader = proxyClassLoader.firstParent();
        if (classLoader == null) {
            NetigsoFramework.classLoaderDown(this);
            return;
        }
        NetigsoFramework.getDefault().stopLoader(this, classLoader);
        this.classloader = null;
    }

    @Override
    public ClassLoader getClassLoader() throws IllegalArgumentException {
        if (this.classloader == null) {
            try {
                this.classLoaderUp(null);
            }
            catch (IOException iOException) {
                Exceptions.printStackTrace((Throwable)iOException);
            }
        }
        if (this.classloader == null) {
            throw new IllegalArgumentException("No classloader for " + this.getCodeNameBase());
        }
        return this.classloader;
    }

    @Override
    protected void cleanup() {
    }

    @Override
    protected void destroy() {
    }

    @Override
    public boolean isFixed() {
        return false;
    }

    @Override
    public Manifest getManifest() {
        return this.manifest;
    }

    public Object getLocalizedAttribute(String string) {
        return null;
    }

    @Override
    public String toString() {
        return "Netigso: " + this.jar;
    }

    private String getMainAttribute(String string) {
        String string2 = this.manifest.getMainAttributes().getValue(string);
        if (string2 == null) {
            return null;
        }
        return string2.replaceFirst(";.*$", "");
    }

    private static final class DelegateCL
    extends ProxyClassLoader {
        public DelegateCL() {
            super(new ClassLoader[0], false);
        }

        private ProxyClassLoader delegate() {
            ClassLoader classLoader = this.firstParent();
            assert (classLoader != null);
            return (ProxyClassLoader)classLoader;
        }

        @Override
        public URL findResource(String string) {
            return this.delegate().findResource(string);
        }

        @Override
        public Enumeration<URL> findResources(String string) throws IOException {
            return this.delegate().findResources(string);
        }

        @Override
        protected Class<?> doLoadClass(String string, String string2) {
            return this.delegate().doLoadClass(string, string2);
        }

        @Override
        protected Class loadClass(String string, boolean bl) throws ClassNotFoundException {
            return this.delegate().loadClass(string, bl);
        }

        public String toString() {
            ClassLoader classLoader = this.firstParent();
            return classLoader == null ? "Netigso[uninitialized]" : "Netigso[" + classLoader.toString() + "]";
        }
    }
}

