/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionListener;
import java.beans.PropertyVetoException;
import javax.swing.JInternalFrame;
import javax.swing.event.InternalFrameAdapter;
import javax.swing.event.InternalFrameEvent;
import sun.jvm.hotspot.ui.FrameWrapper;

public class JInternalFrameWrapper
implements FrameWrapper {
    private JInternalFrame frame;
    private boolean hasWindowListener;
    private ActionListener closingActionListener;
    private ActionListener activatedActionListener;

    public JInternalFrameWrapper(JInternalFrame frame) {
        this.frame = frame;
    }

    public Component getComponent() {
        return this.frame;
    }

    public Container getContentPane() {
        return this.frame.getContentPane();
    }

    public void setVisible(boolean visible) {
        this.frame.setVisible(visible);
    }

    public void setSize(int x, int y) {
        this.frame.setSize(x, y);
    }

    public void pack() {
        this.frame.pack();
    }

    public void show() {
        this.frame.show();
    }

    public void dispose() {
        this.frame.dispose();
    }

    public void setBackground(Color color) {
        this.frame.setBackground(color);
    }

    public void setResizable(boolean resizable) {
        this.frame.setResizable(resizable);
    }

    public void setClosable(boolean closable) {
        this.frame.setClosable(closable);
    }

    public void setClosingActionListener(ActionListener l) {
        this.closingActionListener = l;
        this.maybeInstallWindowListener();
    }

    public void setActivatedActionListener(ActionListener l) {
        this.activatedActionListener = l;
        this.maybeInstallWindowListener();
    }

    public void toFront() {
        this.frame.toFront();
        try {
            this.frame.setSelected(true);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
    }

    private void maybeInstallWindowListener() {
        if (!this.hasWindowListener) {
            this.frame.addInternalFrameListener(new InternalFrameAdapter(){

                public void internalFrameClosing(InternalFrameEvent e) {
                    if (JInternalFrameWrapper.this.closingActionListener != null) {
                        JInternalFrameWrapper.this.closingActionListener.actionPerformed(null);
                    }
                }

                public void internalFrameActivated(InternalFrameEvent e) {
                    if (JInternalFrameWrapper.this.activatedActionListener != null) {
                        JInternalFrameWrapper.this.activatedActionListener.actionPerformed(null);
                    }
                }
            });
            this.hasWindowListener = true;
        }
    }
}

