/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.runtime.sparc;

import java.util.Observable;
import java.util.Observer;
import sun.jvm.hotspot.asm.sparc.SPARCRegister;
import sun.jvm.hotspot.debugger.Address;
import sun.jvm.hotspot.runtime.Frame;
import sun.jvm.hotspot.runtime.JavaThread;
import sun.jvm.hotspot.runtime.RegisterMap;
import sun.jvm.hotspot.runtime.VM;
import sun.jvm.hotspot.runtime.VMReg;
import sun.jvm.hotspot.types.TypeDataBase;
import sun.jvm.hotspot.utilities.Assert;

public class SPARCRegisterMap
extends RegisterMap {
    private Address window;
    private Address youngerWindow;
    private static int registerImplNumberOfRegisters;
    private static int[] R_L_nums;
    private static int[] R_I_nums;
    private static int[] R_O_nums;
    private static int[] R_G_nums;
    private static long badMask;
    private static long R_LIO_mask;
    private static int sizeofJint;

    private static void initialize(TypeDataBase db) {
        int i;
        badMask = 0L;
        R_LIO_mask = 0L;
        sizeofJint = (int)db.lookupType("jint").getSize();
        registerImplNumberOfRegisters = db.lookupIntConstant("RegisterImpl::number_of_registers");
        for (i = 0; i < 8; ++i) {
            Assert.that(R_L_nums[i] < locationValidTypeSize, "in first chunk");
            Assert.that(R_I_nums[i] < locationValidTypeSize, "in first chunk");
            Assert.that(R_O_nums[i] < locationValidTypeSize, "in first chunk");
            Assert.that(R_G_nums[i] < locationValidTypeSize, "in first chunk");
        }
        badMask |= 1L << R_O_nums[6];
        badMask |= 1L << R_O_nums[7];
        badMask |= 1L << R_I_nums[6];
        badMask |= 1L << R_I_nums[7];
        badMask |= 1L << R_G_nums[2];
        badMask |= 1L << R_G_nums[7];
        for (i = 0; i < 8; ++i) {
            R_LIO_mask |= 1L << R_L_nums[i];
            R_LIO_mask |= 1L << R_I_nums[i];
            R_LIO_mask |= 1L << R_O_nums[i];
        }
    }

    public SPARCRegisterMap(JavaThread thread, boolean updateMap) {
        super(thread, updateMap);
    }

    protected SPARCRegisterMap(RegisterMap map) {
        super(map);
    }

    public Object clone() {
        SPARCRegisterMap retval = new SPARCRegisterMap(this);
        return retval;
    }

    protected void clearPD() {
        if (this.thread.hasLastJavaFrame()) {
            Frame fr = this.thread.getLastFrame();
            this.window = fr.getSP();
        } else {
            Frame fr;
            this.window = null;
            if (VM.getVM().isDebugging() && (fr = this.thread.getCurrentFrameGuess()) != null) {
                this.window = fr.getSP();
            }
        }
        this.youngerWindow = null;
    }

    protected Address getLocationPD(VMReg vmreg) {
        SPARCRegister reg;
        VM vm = VM.getVM();
        int regname = vmreg.getValue();
        if (Assert.ASSERTS_ENABLED) {
            Assert.that(0 <= regname && regname < regCount, "sanity check");
        }
        if (regname >= registerImplNumberOfRegisters << 1) {
            return null;
        }
        if ((badMask & 1L << regname) != 0L) {
            return null;
        }
        int secondWord = 0;
        if (!this.isEven(regname)) {
            if (vm.isLP64()) {
                secondWord = sizeofJint;
            } else {
                return null;
            }
        }
        if ((reg = new SPARCRegister(regname >> 1)).isOut()) {
            if (Assert.ASSERTS_ENABLED) {
                Assert.that(this.youngerWindow != null, "Younger window should be available");
            }
            return this.youngerWindow.addOffsetTo(reg.afterSave().spOffsetInSavedWindow() + (long)secondWord);
        }
        if (reg.isLocal() || reg.isIn()) {
            if (Assert.ASSERTS_ENABLED) {
                Assert.that(this.window != null, "Window should be available");
            }
            return this.window.addOffsetTo(reg.spOffsetInSavedWindow() + (long)secondWord);
        }
        return null;
    }

    protected void initializePD() {
        this.window = null;
        this.youngerWindow = null;
        this.makeIntegerRegsUnsaved();
    }

    protected void initializeFromPD(RegisterMap map) {
        SPARCRegisterMap srm = (SPARCRegisterMap)map;
        this.window = srm.window;
        this.youngerWindow = srm.youngerWindow;
        this.makeIntegerRegsUnsaved();
    }

    public void shiftWindow(Address sp, Address youngerSP) {
        this.window = sp;
        this.youngerWindow = youngerSP;
        if (this.locationValid[0] != 0L) {
            this.shiftIndividualRegisters();
        }
    }

    public void makeIntegerRegsUnsaved() {
        this.locationValid[0] = 0L;
    }

    private void shiftIndividualRegisters() {
        long lv;
        if (!this.getUpdateMap()) {
            return;
        }
        this.checkLocationValid();
        long lv0 = lv = this.locationValid[0];
        if ((lv &= R_LIO_mask ^ 0xFFFFFFFFFFFFFFFFL) != lv0) {
            for (int i = 0; i < 8; ++i) {
                if ((lv0 & 1L << R_I_nums[i]) == 0L) continue;
                this.location[SPARCRegisterMap.R_O_nums[i]] = this.location[R_I_nums[i]];
                lv |= 1L << R_O_nums[i];
            }
        }
        this.locationValid[0] = lv;
        this.checkLocationValid();
    }

    private boolean isEven(int i) {
        return (i & 1) == 0;
    }

    private void checkLocationValid() {
        if (Assert.ASSERTS_ENABLED) {
            Assert.that((this.locationValid[0] & badMask) == 0L, "cannot have special locations for SP,FP,TLS,etc.");
        }
    }

    static {
        R_L_nums = new int[]{32, 34, 36, 38, 40, 42, 44, 46};
        R_I_nums = new int[]{48, 50, 52, 54, 56, 58, 60, 62};
        R_O_nums = new int[]{16, 18, 20, 22, 24, 26, 28, 30};
        R_G_nums = new int[]{0, 2, 4, 6, 8, 10, 12, 14};
        VM.registerVMInitializedObserver(new Observer(){

            public void update(Observable o, Object data) {
                SPARCRegisterMap.initialize(VM.getVM().getTypeDataBase());
            }
        });
    }
}

