/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.runtime.solaris_amd64;

import java.io.PrintStream;
import java.util.Observable;
import java.util.Observer;
import sun.jvm.hotspot.debugger.Address;
import sun.jvm.hotspot.debugger.JVMDebugger;
import sun.jvm.hotspot.debugger.ThreadProxy;
import sun.jvm.hotspot.debugger.amd64.AMD64ThreadContext;
import sun.jvm.hotspot.runtime.Frame;
import sun.jvm.hotspot.runtime.JavaThread;
import sun.jvm.hotspot.runtime.JavaThreadPDAccess;
import sun.jvm.hotspot.runtime.RegisterMap;
import sun.jvm.hotspot.runtime.VM;
import sun.jvm.hotspot.runtime.amd64.AMD64CurrentFrameGuess;
import sun.jvm.hotspot.runtime.amd64.AMD64Frame;
import sun.jvm.hotspot.runtime.amd64.AMD64RegisterMap;
import sun.jvm.hotspot.types.AddressField;
import sun.jvm.hotspot.types.CIntegerField;
import sun.jvm.hotspot.types.Type;
import sun.jvm.hotspot.types.TypeDataBase;

public class SolarisAMD64JavaThreadPDAccess
implements JavaThreadPDAccess {
    private static AddressField lastJavaFPField;
    private static AddressField osThreadField;
    private static AddressField baseOfStackPointerField;
    private static CIntegerField osThreadThreadIDField;
    private static final long GUESS_SCAN_RANGE = 131072L;

    private static synchronized void initialize(TypeDataBase db) {
        Type type = db.lookupType("JavaThread");
        Type anchorType = db.lookupType("JavaFrameAnchor");
        lastJavaFPField = anchorType.getAddressField("_last_Java_fp");
        osThreadField = type.getAddressField("_osthread");
        type = db.lookupType("OSThread");
        osThreadThreadIDField = type.getCIntegerField("_thread_id");
    }

    public Address getLastJavaFP(Address addr) {
        return lastJavaFPField.getValue(addr.addOffsetTo(JavaThread.getAnchorField().getOffset()));
    }

    public Address getLastJavaPC(Address addr) {
        return null;
    }

    public Address getBaseOfStackPointer(Address addr) {
        return null;
    }

    public Frame getLastFramePD(JavaThread thread, Address addr) {
        Address fp = thread.getLastJavaFP();
        if (fp == null) {
            return null;
        }
        Address pc = thread.getLastJavaPC();
        if (pc != null) {
            return new AMD64Frame(thread.getLastJavaSP(), fp, pc);
        }
        return new AMD64Frame(thread.getLastJavaSP(), fp);
    }

    public RegisterMap newRegisterMap(JavaThread thread, boolean updateMap) {
        return new AMD64RegisterMap(thread, updateMap);
    }

    public Frame getCurrentFrameGuess(JavaThread thread, Address addr) {
        ThreadProxy t = this.getThreadProxy(addr);
        AMD64ThreadContext context = (AMD64ThreadContext)t.getContext();
        AMD64CurrentFrameGuess guesser = new AMD64CurrentFrameGuess(context, thread);
        if (!guesser.run(131072L)) {
            return null;
        }
        if (guesser.getPC() == null) {
            return new AMD64Frame(guesser.getSP(), guesser.getFP());
        }
        return new AMD64Frame(guesser.getSP(), guesser.getFP(), guesser.getPC());
    }

    public void printThreadIDOn(Address addr, PrintStream tty) {
        tty.print(this.getThreadProxy(addr));
    }

    public void printInfoOn(Address threadAddr, PrintStream tty) {
    }

    public Address getLastSP(Address addr) {
        ThreadProxy t = this.getThreadProxy(addr);
        AMD64ThreadContext context = (AMD64ThreadContext)t.getContext();
        return context.getRegisterAsAddress(20);
    }

    public ThreadProxy getThreadProxy(Address addr) {
        Address osThreadAddr = osThreadField.getValue(addr);
        Address tidAddr = osThreadAddr.addOffsetTo(osThreadThreadIDField.getOffset());
        JVMDebugger debugger = VM.getVM().getDebugger();
        return debugger.getThreadForIdentifierAddress(tidAddr);
    }

    static {
        VM.registerVMInitializedObserver(new Observer(){

            public void update(Observable o, Object data) {
                SolarisAMD64JavaThreadPDAccess.initialize(VM.getVM().getTypeDataBase());
            }
        });
    }
}

