/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.runtime;

import sun.jvm.hotspot.oops.Symbol;
import sun.jvm.hotspot.runtime.AddressVisitor;
import sun.jvm.hotspot.runtime.ArgumentSizeComputer;
import sun.jvm.hotspot.runtime.BasicType;
import sun.jvm.hotspot.runtime.Frame;
import sun.jvm.hotspot.runtime.SignatureInfo;
import sun.jvm.hotspot.utilities.Assert;

class ArgumentOopFinder
extends SignatureInfo {
    private AddressVisitor f;
    private int offset;
    private boolean isStatic;
    private Frame fr;

    protected void set(int size, int type) {
        this.offset -= size;
        if (type == BasicType.getTObject() || type == BasicType.getTArray()) {
            this.oopOffsetDo();
        }
    }

    private void oopOffsetDo() {
        this.f.visitAddress(this.fr.addressOfInterpreterFrameTOSAt(this.offset));
    }

    public ArgumentOopFinder(Symbol signature, boolean isStatic, Frame fr, AddressVisitor f) {
        super(signature);
        int argsSize = new ArgumentSizeComputer(signature).size() + (isStatic ? 0 : 1);
        if (Assert.ASSERTS_ENABLED) {
            Assert.that(!fr.isInterpretedFrame() || argsSize <= fr.getInterpreterFrameExpressionStackSize(), "args cannot be on stack anymore");
        }
        this.f = f;
        this.fr = fr;
        this.offset = argsSize;
        this.isStatic = isStatic;
    }

    public void oopsDo() {
        if (!this.isStatic) {
            --this.offset;
            this.oopOffsetDo();
        }
        this.iterateParameters();
    }
}

