/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.asm.x86;

import sun.jvm.hotspot.asm.Immediate;
import sun.jvm.hotspot.asm.ImmediateOrRegister;
import sun.jvm.hotspot.asm.Operand;
import sun.jvm.hotspot.asm.Register;
import sun.jvm.hotspot.asm.SymbolFinder;
import sun.jvm.hotspot.asm.x86.X86Instruction;

public class X86RotateInstruction
extends X86Instruction {
    private final Operand operand1;
    private final ImmediateOrRegister operand2;

    public X86RotateInstruction(String name, Operand operand1, ImmediateOrRegister operand2, int size, int prefixes) {
        super(name, size, prefixes);
        this.operand1 = operand1;
        this.operand2 = operand2;
    }

    public String asString(long currentPc, SymbolFinder symFinder) {
        StringBuffer buf = new StringBuffer();
        buf.append(this.getPrefixString());
        buf.append(this.getName());
        buf.append(spaces);
        if (this.operand2 != null) {
            if (this.operand2 instanceof Register) {
                buf.append(this.operand2.toString());
            } else {
                Number number = ((Immediate)this.operand2).getNumber();
                buf.append("0x");
                buf.append(Integer.toHexString(number.intValue()));
            }
            buf.append(comma);
        }
        buf.append(this.getOperandAsString(this.operand1));
        return buf.toString();
    }

    public Operand getRotateDestination() {
        return this.operand1;
    }

    public Operand getRotateSource() {
        return this.operand1;
    }
}

