/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.asm.sparc;

import sun.jvm.hotspot.asm.ImmediateOrRegister;
import sun.jvm.hotspot.asm.sparc.SPARCMoveInstruction;
import sun.jvm.hotspot.asm.sparc.SPARCRegister;
import sun.jvm.hotspot.asm.sparc.SPARCV9ConditionFlags;
import sun.jvm.hotspot.asm.sparc.SPARCV9Instruction;

public class SPARCV9MOVccInstruction
extends SPARCMoveInstruction
implements SPARCV9Instruction {
    private final int conditionFlag;
    private final int conditionCode;

    public SPARCV9MOVccInstruction(String name, int conditionCode, int conditionFlag, ImmediateOrRegister source, SPARCRegister rd) {
        super(name, 44, source, rd);
        this.conditionCode = conditionCode;
        this.conditionFlag = conditionFlag;
    }

    protected String getDescription() {
        StringBuffer buf = new StringBuffer();
        buf.append(this.getName());
        buf.append(spaces);
        buf.append(SPARCV9ConditionFlags.getFlagName(this.conditionFlag));
        buf.append(comma);
        buf.append(this.getOperand2String());
        buf.append(comma);
        buf.append(this.rd.toString());
        return buf.toString();
    }

    public int getConditionCode() {
        return this.conditionCode;
    }

    public int getConditionFlag() {
        return this.conditionFlag;
    }

    public String getConditionFlagName() {
        return SPARCV9ConditionFlags.getFlagName(this.conditionFlag);
    }

    public boolean isConditional() {
        return true;
    }
}

