/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.masterfs.filebasedfs.fileobjects;

import java.io.File;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.masterfs.filebasedfs.fileobjects.BaseFileObj;
import org.netbeans.modules.masterfs.filebasedfs.fileobjects.FileObjectFactory;
import org.netbeans.modules.masterfs.filebasedfs.fileobjects.FolderObj;
import org.openide.filesystems.FileAttributeEvent;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;

final class FileObjectKeeper
implements FileChangeListener {
    private static final Logger LOG = Logger.getLogger(FileObjectKeeper.class.getName());
    private Set<FolderObj> kept;
    private Collection<FileChangeListener> listeners;
    private final FolderObj root;
    private long timeStamp;

    public FileObjectKeeper(FolderObj folderObj) {
        this.root = folderObj;
    }

    public synchronized void addRecursiveListener(FileChangeListener fileChangeListener) {
        if (this.listeners == null) {
            this.listeners = new CopyOnWriteArraySet<FileChangeListener>();
        }
        if (this.listeners.isEmpty()) {
            Callable callable = null;
            if (fileChangeListener instanceof Callable && fileChangeListener.getClass().getName().equals("org.openide.filesystems.DeepListener")) {
                callable = (Callable)fileChangeListener;
            }
            this.listenToAll(callable);
        }
        this.listeners.add(fileChangeListener);
    }

    public synchronized void removeRecursiveListener(FileChangeListener fileChangeListener) {
        if (this.listeners == null) {
            return;
        }
        this.listeners.remove(fileChangeListener);
        if (this.listeners.isEmpty()) {
            this.listenNoMore();
        }
    }

    public List<File> init(long l, FileObjectFactory fileObjectFactory, boolean bl) {
        File file = this.root.getFileName().getFile();
        LinkedList<File> linkedList = new LinkedList<File>();
        long l2 = this.root.getProvidedExtensions().refreshRecursively(file, l, linkedList);
        for (File file2 : linkedList) {
            if (file2.isDirectory()) continue;
            long l3 = file2.lastModified();
            LOG.log(Level.FINE, "  check {0} for {1}", new Object[]{l3, file2});
            if (l3 > l2) {
                l2 = l3;
            }
            if (l3 <= l || fileObjectFactory == null) continue;
            BaseFileObj baseFileObj = fileObjectFactory.getCachedOnly(file2);
            if (baseFileObj == null) {
                BaseFileObj baseFileObj2 = fileObjectFactory.getValidFileObject(file2, FileObjectFactory.Caller.Others);
                if (baseFileObj2 != null) {
                    LOG.log(Level.FINE, "External change detected {0}", (Object)baseFileObj2);
                    baseFileObj2.fireFileChangedEvent(bl);
                    continue;
                }
                LOG.log(Level.FINE, "Cannot get valid FileObject. File probably removed: {0}", file2);
                continue;
            }
            LOG.log(Level.FINE, "Do classical refresh for {0}", (Object)baseFileObj);
            baseFileObj.refresh(bl, true);
        }
        this.timeStamp = l2;
        LOG.log(Level.FINE, "Testing {0}, time {1}", new Object[]{file, this.timeStamp});
        return linkedList;
    }

    private void listenTo(FileObject fileObject, boolean bl, Collection<? super File> collection) {
        if (bl) {
            fileObject.addFileChangeListener((FileChangeListener)this);
            if (fileObject instanceof FolderObj) {
                FolderObj folderObj = (FolderObj)fileObject;
                folderObj.getKeeper(collection);
                folderObj.getChildren();
                Set<FolderObj> set = this.kept;
                if (set != null) {
                    set.add(folderObj);
                }
            }
            LOG.log(Level.FINER, "Listening to {0}", fileObject);
        } else {
            fileObject.removeFileChangeListener((FileChangeListener)this);
            LOG.log(Level.FINER, "Ignoring {0}", fileObject);
        }
    }

    private void listenToAll(Callable<?> callable) {
        File file;
        assert (Thread.holdsLock(this));
        assert (this.kept == null);
        this.kept = new HashSet<FolderObj>();
        LinkedList linkedList = new LinkedList();
        this.listenTo(this.root, true, linkedList);
        FileObjectFactory fileObjectFactory = null;
        while ((file = (File)linkedList.poll()) != null) {
            BaseFileObj baseFileObj;
            if (fileObjectFactory == null) {
                fileObjectFactory = FileObjectFactory.getInstance(file);
            }
            if (!((baseFileObj = fileObjectFactory.getValidFileObject(file, FileObjectFactory.Caller.Others)) instanceof FolderObj)) continue;
            FolderObj folderObj = (FolderObj)baseFileObj;
            Boolean bl = null;
            if (callable != null) {
                try {
                    bl = (Boolean)callable.call();
                }
                catch (Exception exception) {
                    bl = Boolean.TRUE;
                }
            }
            if (Boolean.TRUE.equals(bl)) {
                LOG.log(Level.INFO, "addRecursiveListener to {0} interrupted", (Object)this.root);
                return;
            }
            this.listenTo(folderObj, true, linkedList);
        }
    }

    private void listenNoMore() {
        assert (Thread.holdsLock(this));
        this.listenTo(this.root, false, null);
        Set<FolderObj> set = this.kept;
        if (set != null) {
            for (FolderObj folderObj : set) {
                this.listenTo(folderObj, false, null);
            }
            this.kept = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fileFolderCreated(FileEvent fileEvent) {
        Collection<FileChangeListener> collection = this.listeners;
        FileObject fileObject = fileEvent.getFile();
        if (fileObject instanceof FolderObj) {
            FolderObj folderObj = (FolderObj)fileObject;
            FileObjectKeeper fileObjectKeeper = this;
            synchronized (fileObjectKeeper) {
                File file;
                LinkedList linkedList = new LinkedList();
                this.listenTo(folderObj, true, linkedList);
                FileObjectFactory fileObjectFactory = null;
                while ((file = (File)linkedList.poll()) != null) {
                    BaseFileObj baseFileObj;
                    if (fileObjectFactory == null) {
                        fileObjectFactory = FileObjectFactory.getInstance(file);
                    }
                    if (!((baseFileObj = fileObjectFactory.getValidFileObject(file, FileObjectFactory.Caller.Others)) instanceof FolderObj)) continue;
                    this.listenTo((FolderObj)baseFileObj, true, linkedList);
                }
            }
        }
        if (collection == null || this.kept == null) {
            return;
        }
        for (FileChangeListener fileChangeListener : collection) {
            fileChangeListener.fileFolderCreated(fileEvent);
        }
    }

    public void fileDataCreated(FileEvent fileEvent) {
        Collection<FileChangeListener> collection = this.listeners;
        if (collection == null) {
            return;
        }
        for (FileChangeListener fileChangeListener : collection) {
            fileChangeListener.fileDataCreated(fileEvent);
        }
    }

    public void fileChanged(FileEvent fileEvent) {
        Collection<FileChangeListener> collection = this.listeners;
        if (collection == null) {
            return;
        }
        for (FileChangeListener fileChangeListener : collection) {
            fileChangeListener.fileChanged(fileEvent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fileDeleted(FileEvent fileEvent) {
        Collection<FileChangeListener> collection = this.listeners;
        FileObject fileObject = fileEvent.getFile();
        if (fileObject.isFolder() && fileEvent.getSource() == fileObject && fileObject != this.root) {
            return;
        }
        if (fileObject instanceof FolderObj) {
            FolderObj folderObj = (FolderObj)fileObject;
            FileObjectKeeper fileObjectKeeper = this;
            synchronized (fileObjectKeeper) {
                if (this.kept != null) {
                    this.kept.remove((Object)folderObj);
                }
                this.listenTo(folderObj, false, null);
            }
        }
        if (collection == null) {
            return;
        }
        for (FileChangeListener fileChangeListener : collection) {
            fileChangeListener.fileDeleted(fileEvent);
        }
    }

    public void fileRenamed(FileRenameEvent fileRenameEvent) {
        Collection<FileChangeListener> collection = this.listeners;
        if (collection == null) {
            return;
        }
        FileObject fileObject = fileRenameEvent.getFile();
        if (fileObject.isFolder() && fileRenameEvent.getSource() == fileObject && fileObject != this.root) {
            return;
        }
        for (FileChangeListener fileChangeListener : collection) {
            fileChangeListener.fileRenamed(fileRenameEvent);
        }
    }

    public void fileAttributeChanged(FileAttributeEvent fileAttributeEvent) {
        Collection<FileChangeListener> collection = this.listeners;
        if (collection == null) {
            return;
        }
        for (FileChangeListener fileChangeListener : collection) {
            fileChangeListener.fileAttributeChanged(fileAttributeEvent);
        }
    }

    long childrenLastModified() {
        return this.timeStamp;
    }
}

