/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.swing.tabcontrol.plaf;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import org.netbeans.swing.tabcontrol.TabDisplayer;
import org.netbeans.swing.tabcontrol.plaf.AbstractViewTabDisplayerUI;
import org.netbeans.swing.tabcontrol.plaf.ColorUtil;
import org.netbeans.swing.tabcontrol.plaf.TabControlButtonFactory;
import org.netbeans.swing.tabcontrol.plaf.TabLayoutModel;
import org.openide.awt.HtmlRenderer;

public final class AquaViewTabDisplayerUI
extends AbstractViewTabDisplayerUI {
    private static final int TXT_X_PAD = 5;
    private static final int ICON_X_PAD = 2;
    private static Map<Integer, String[]> buttonIconPaths;
    private Dimension prefSize = new Dimension(100, 19);

    private AquaViewTabDisplayerUI(TabDisplayer tabDisplayer) {
        super(tabDisplayer);
    }

    public static ComponentUI createUI(JComponent jComponent) {
        return new AquaViewTabDisplayerUI((TabDisplayer)jComponent);
    }

    @Override
    protected AbstractViewTabDisplayerUI.Controller createController() {
        return new OwnController();
    }

    @Override
    public Dimension getPreferredSize(JComponent jComponent) {
        FontMetrics fontMetrics = this.getTxtFontMetrics();
        int n = fontMetrics == null ? 21 : fontMetrics.getAscent() + 2 * fontMetrics.getDescent() + 3;
        Insets insets = jComponent.getInsets();
        this.prefSize.height = ++n + insets.bottom + insets.top;
        return this.prefSize;
    }

    private boolean isMouseOver(int n) {
        return ((OwnController)this.getController()).getMouseIndex() == n && !this.isSelected(n);
    }

    @Override
    protected void paintTabContent(Graphics graphics, int n, String string, int n2, int n3, int n4, int n5) {
        FontMetrics fontMetrics = this.getTxtFontMetrics();
        graphics.setFont(this.getTxtFont());
        int n6 = n4;
        if (this.isSelected(n)) {
            Component component = this.getControlButtons();
            if (null != component) {
                Dimension dimension = component.getPreferredSize();
                n6 = n4 - (dimension.width + 2 + 10);
                component.setLocation(n2 + n6 + 10 - 2, n3 + (n5 - dimension.height) / 2);
            }
        } else {
            n6 = n4 - 10;
        }
        if (string.length() == 0) {
            return;
        }
        int n7 = fontMetrics.getHeight();
        int n8 = n2 + 5;
        if (n == 0) {
            n8 = n2 + 5;
        }
        int n9 = n7 > n5 ? -1 * ((n7 - n5) / 2) + fontMetrics.getAscent() - 1 : n5 / 2 - n7 / 2 + fontMetrics.getAscent();
        int n10 = (int)HtmlRenderer.renderString((String)string, (Graphics)graphics, (int)n8, (int)n9, (int)n6, (int)n5, (Font)this.getTxtFont(), (Color)UIManager.getColor("textText"), (int)1, (boolean)false);
        if (n6 > (n10 = Math.min(n10, n6))) {
            n8 += (n6 - n10) / 2;
        }
        HtmlRenderer.renderString((String)string, (Graphics)graphics, (int)n8, (int)n9, (int)n6, (int)n5, (Font)this.getTxtFont(), (Color)UIManager.getColor("textText"), (int)1, (boolean)true);
    }

    @Override
    protected void paintTabBorder(Graphics graphics, int n, int n2, int n3, int n4, int n5) {
        Color color = UIManager.getColor("NbTabControl.borderColor");
        Color color2 = UIManager.getColor("NbTabControl.borderShadowColor");
        graphics.setColor(color);
        if (n > 0) {
            graphics.drawLine(n2, n3, n2, n3 + n5);
            if (!this.isSelected(n)) {
                graphics.setColor(color2);
                graphics.drawLine(n2 + 1, n3 + 1, n2 + 1, n3 + n5 - 1);
            }
        }
        if (n < this.getDataModel().size() - 1) {
            graphics.setColor(color);
            graphics.drawLine(n2 + n4, n3, n2 + n4, n3 + n5);
            if (!this.isSelected(n)) {
                graphics.setColor(color2);
                graphics.drawLine(n2 + n4 - 1, n3 + 1, n2 + n4 - 1, n3 + n5 - 1);
            }
        }
        graphics.setColor(color);
        if (!this.isSelected(n)) {
            graphics.drawLine(n2, n3 + n5 - 1, n2 + n4, n3 + n5 - 1);
        }
        graphics.drawLine(n2, n3, n2 + n4, n3);
        if (this.getDataModel().size() == 1) {
            graphics.setColor(UIManager.getColor("NbTabControl.editorTabBackground"));
            graphics.drawLine(n2, n3 + n5 - 1, n2 + n4, n3 + n5 - 1);
        }
        if (this.isSelected(n) && this.isFocused(n)) {
            graphics.setColor(UIManager.getColor("NbTabControl.focusedTabBackground"));
            graphics.drawLine(n2 + (n == 0 ? 0 : 1), n3 + 1, n2 + n4 - 1, n3 + 1);
            graphics.drawLine(n2 + (n == 0 ? 0 : 1), n3 + 2, n2 + n4 - 1, n3 + 2);
        }
    }

    @Override
    protected void paintTabBackground(Graphics graphics, int n, int n2, int n3, int n4, int n5) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        Paint paint = graphics2D.getPaint();
        if (this.isSelected(n)) {
            graphics2D.setPaint(ColorUtil.getGradientPaint(n2, n3, UIManager.getColor("NbTabControl.selectedTabBrighterBackground"), n2, n3 + n5 / 2, UIManager.getColor("NbTabControl.selectedTabDarkerBackground")));
        } else if (this.isMouseOver(n)) {
            graphics2D.setPaint(ColorUtil.getGradientPaint(n2, n3, UIManager.getColor("NbTabControl.mouseoverTabBrighterBackground"), n2, n3 + n5 / 2, UIManager.getColor("NbTabControl.mouseoverTabDarkerBackground")));
        } else {
            graphics2D.setPaint(ColorUtil.getGradientPaint(n2, n3, UIManager.getColor("NbTabControl.inactiveTabBrighterBackground"), n2, n3 + n5 / 2, UIManager.getColor("NbTabControl.inactiveTabDarkerBackground")));
        }
        graphics2D.fillRect(n2, n3, n4, n5);
        graphics2D.setPaint(paint);
    }

    private static void initIcons() {
        if (null == buttonIconPaths) {
            String[] stringArray;
            buttonIconPaths = new HashMap<Integer, String[]>(7);
            stringArray = new String[]{"org/netbeans/swing/tabcontrol/resources/mac_bigclose_enabled.png", "org/netbeans/swing/tabcontrol/resources/mac_bigclose_pressed.png", stringArray[0], "org/netbeans/swing/tabcontrol/resources/mac_bigclose_rollover.png"};
            buttonIconPaths.put(1, stringArray);
            stringArray = new String[]{"org/netbeans/swing/tabcontrol/resources/mac_slideright_enabled.png", "org/netbeans/swing/tabcontrol/resources/mac_slideright_pressed.png", stringArray[0], "org/netbeans/swing/tabcontrol/resources/mac_slideright_rollover.png"};
            buttonIconPaths.put(6, stringArray);
            stringArray = new String[]{"org/netbeans/swing/tabcontrol/resources/mac_slideleft_enabled.png", "org/netbeans/swing/tabcontrol/resources/mac_slideleft_pressed.png", stringArray[0], "org/netbeans/swing/tabcontrol/resources/mac_slideleft_rollover.png"};
            buttonIconPaths.put(5, stringArray);
            stringArray = new String[]{"org/netbeans/swing/tabcontrol/resources/mac_slidebottom_enabled.png", "org/netbeans/swing/tabcontrol/resources/mac_slidebottom_pressed.png", stringArray[0], "org/netbeans/swing/tabcontrol/resources/mac_slidebottom_rollover.png"};
            buttonIconPaths.put(7, stringArray);
            stringArray = new String[]{"org/netbeans/swing/tabcontrol/resources/mac_pin_enabled.png", "org/netbeans/swing/tabcontrol/resources/mac_pin_pressed.png", stringArray[0], "org/netbeans/swing/tabcontrol/resources/mac_pin_rollover.png"};
            buttonIconPaths.put(2, stringArray);
        }
    }

    @Override
    public Icon getButtonIcon(int n, int n2) {
        Icon icon = null;
        AquaViewTabDisplayerUI.initIcons();
        String[] stringArray = buttonIconPaths.get(n);
        if (null != stringArray && n2 >= 0 && n2 < stringArray.length) {
            icon = TabControlButtonFactory.getIcon(stringArray[n2]);
        }
        return icon;
    }

    private class OwnController
    extends AbstractViewTabDisplayerUI.Controller {
        private int lastIndex = -1;

        private OwnController() {
        }

        public int getMouseIndex() {
            return this.lastIndex;
        }

        @Override
        public void mouseMoved(MouseEvent mouseEvent) {
            super.mouseMoved(mouseEvent);
            Point point = mouseEvent.getPoint();
            this.updateHighlight(AquaViewTabDisplayerUI.this.getLayoutModel().indexOfPoint(point.x, point.y));
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
            super.mouseExited(mouseEvent);
            if (!this.inControlButtonsRect(mouseEvent.getPoint())) {
                this.updateHighlight(-1);
            }
        }

        private void updateHighlight(int n) {
            int n2;
            int n3;
            int n4;
            int n5;
            if (n == this.lastIndex) {
                return;
            }
            TabLayoutModel tabLayoutModel = AquaViewTabDisplayerUI.this.getLayoutModel();
            Rectangle rectangle = null;
            if (n != -1) {
                n5 = tabLayoutModel.getX(n) - 1;
                n4 = tabLayoutModel.getY(n);
                n3 = tabLayoutModel.getW(n) + 2;
                n2 = tabLayoutModel.getH(n);
                rectangle = new Rectangle(n5, n4, n3, n2);
            }
            if (this.lastIndex != -1 && this.lastIndex < AquaViewTabDisplayerUI.this.getDataModel().size()) {
                n5 = tabLayoutModel.getX(this.lastIndex) - 1;
                n4 = tabLayoutModel.getY(this.lastIndex);
                n3 = tabLayoutModel.getW(this.lastIndex) + 2;
                n2 = tabLayoutModel.getH(this.lastIndex);
                rectangle = rectangle != null ? rectangle.union(new Rectangle(n5, n4, n3, n2)) : new Rectangle(n5, n4, n3, n2);
            }
            if (rectangle != null) {
                AquaViewTabDisplayerUI.this.getDisplayer().repaint(rectangle);
            }
            this.lastIndex = n;
        }
    }
}

