/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.windows.actions;

import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import org.netbeans.core.windows.ModeImpl;
import org.netbeans.core.windows.Switches;
import org.netbeans.core.windows.WindowManagerImpl;
import org.netbeans.core.windows.actions.ActionUtils;
import org.openide.util.NbBundle;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

public final class UndockWindowAction
extends AbstractAction {
    private final TopComponent tc;

    public UndockWindowAction() {
        this.tc = null;
    }

    public UndockWindowAction(TopComponent topComponent) {
        this.tc = topComponent;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        WindowManagerImpl windowManagerImpl = WindowManagerImpl.getInstance();
        TopComponent topComponent = this.getTC2WorkWith();
        boolean bl = windowManagerImpl.isDocked(topComponent);
        ModeImpl modeImpl = (ModeImpl)windowManagerImpl.findMode(topComponent);
        if (bl) {
            windowManagerImpl.userUndockedTopComponent(topComponent, modeImpl);
        } else {
            windowManagerImpl.userDockedTopComponent(topComponent, modeImpl);
        }
    }

    @Override
    public void putValue(String string, Object object) {
        if ("AcceleratorKey".equals(string)) {
            ActionUtils.putSharedAccelerator("UndockWindowAction", object);
        } else {
            super.putValue(string, object);
        }
    }

    @Override
    public Object getValue(String string) {
        if ("AcceleratorKey".equals(string)) {
            return ActionUtils.getSharedAccelerator("UndockWindowAction");
        }
        return super.getValue(string);
    }

    @Override
    public boolean isEnabled() {
        this.updateName();
        return this.getTC2WorkWith() != null && Switches.isTopComponentUndockingEnabled() && Switches.isUndockingEnabled(this.getTC2WorkWith());
    }

    private void updateName() {
        TopComponent topComponent = this.getTC2WorkWith();
        boolean bl = topComponent != null ? WindowManagerImpl.getInstance().isDocked(topComponent) : true;
        this.putValue("Name", NbBundle.getMessage(UndockWindowAction.class, (String)(bl ? "CTL_UndockWindowAction" : "CTL_UndockWindowAction_Dock")));
    }

    private TopComponent getTC2WorkWith() {
        if (this.tc != null) {
            return this.tc;
        }
        return WindowManager.getDefault().getRegistry().getActivated();
    }
}

