/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.actions;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.text.MessageFormat;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.netbeans.lib.profiler.ProfilerClient;
import org.netbeans.lib.profiler.ProfilerEngineSettings;
import org.netbeans.lib.profiler.TargetAppRunner;
import org.netbeans.lib.profiler.client.ClientUtils;
import org.netbeans.lib.profiler.common.Profiler;
import org.netbeans.lib.profiler.common.event.ProfilingStateEvent;
import org.netbeans.lib.profiler.common.event.ProfilingStateListener;
import org.netbeans.lib.profiler.global.ProfilingSessionStatus;
import org.netbeans.lib.profiler.ui.components.HTMLTextArea;
import org.netbeans.modules.profiler.ui.ProfilerDialogs;
import org.openide.DialogDescriptor;
import org.openide.util.NbBundle;

public final class GetCmdLineArgumentsAction
extends AbstractAction
implements ProfilingStateListener {
    private static final String TARGET_JVM_INACTIVE_MSG = NbBundle.getMessage(GetCmdLineArgumentsAction.class, (String)"GetCmdLineArgumentsAction_TargetJvmInactiveMsg");
    private static final String JVM_ARGUMENTS_STRING = NbBundle.getMessage(GetCmdLineArgumentsAction.class, (String)"GetCmdLineArgumentsAction_JvmArgumentsString");
    private static final String MAIN_CLASS_AND_ARGS_STRING = NbBundle.getMessage(GetCmdLineArgumentsAction.class, (String)"GetCmdLineArgumentsAction_MainClassAndArgsString");

    public GetCmdLineArgumentsAction() {
        this.putValue("Name", NbBundle.getMessage(GetCmdLineArgumentsAction.class, (String)"LBL_GetCmdLineArgumentsAction"));
        this.putValue("ShortDescription", NbBundle.getMessage(GetCmdLineArgumentsAction.class, (String)"HINT_GetCmdLineArgumentsAction"));
        this.putValue("noIconInMenu", Boolean.TRUE);
        this.updateEnabledState();
        Profiler.getDefault().addProfilingStateListener((ProfilingStateListener)this);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        try {
            String string;
            String string2;
            TargetAppRunner targetAppRunner = Profiler.getDefault().getTargetAppRunner();
            ProfilerClient profilerClient = targetAppRunner.getProfilerClient();
            ProfilingSessionStatus profilingSessionStatus = targetAppRunner.getProfilingSessionStatus();
            ProfilerEngineSettings profilerEngineSettings = targetAppRunner.getProfilerEngineSettings();
            if (!profilerClient.targetJVMIsAlive()) {
                throw new ClientUtils.TargetAppOrVMTerminated(1, TARGET_JVM_INACTIVE_MSG);
            }
            if (profilingSessionStatus.runningInAttachedMode) {
                string2 = profilingSessionStatus.jvmArguments;
                string = profilingSessionStatus.javaCommand;
            } else {
                string2 = profilerEngineSettings.getJVMArgsAsSingleString();
                string = profilerEngineSettings.getMainClassName() + " " + profilerEngineSettings.getMainArgsAsSingleString();
            }
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("<b>");
            stringBuffer.append(JVM_ARGUMENTS_STRING);
            stringBuffer.append("</b><br>");
            stringBuffer.append(string2);
            stringBuffer.append("<br><br>");
            stringBuffer.append("<b>");
            stringBuffer.append(MAIN_CLASS_AND_ARGS_STRING);
            stringBuffer.append("</b><br>");
            stringBuffer.append(string);
            HTMLTextArea hTMLTextArea = new HTMLTextArea(stringBuffer.toString());
            hTMLTextArea.getAccessibleContext().setAccessibleName(NbBundle.getMessage(GetCmdLineArgumentsAction.class, (String)"CAPTION_JVMandMainClassCommandLineArguments"));
            JPanel jPanel = new JPanel();
            jPanel.setLayout(new BorderLayout());
            jPanel.setBorder(BorderFactory.createEmptyBorder(12, 12, 12, 12));
            jPanel.add((Component)new JScrollPane((Component)hTMLTextArea), "Center");
            jPanel.setPreferredSize(new Dimension(600, 200));
            ProfilerDialogs.createDialog(new DialogDescriptor((Object)jPanel, NbBundle.getMessage(GetCmdLineArgumentsAction.class, (String)"CAPTION_JVMandMainClassCommandLineArguments"), true, new Object[]{DialogDescriptor.CLOSED_OPTION}, DialogDescriptor.CLOSED_OPTION, 0, null, null)).setVisible(true);
        }
        catch (ClientUtils.TargetAppOrVMTerminated targetAppOrVMTerminated) {
            Profiler.getDefault().displayWarning(MessageFormat.format(NbBundle.getMessage(GetCmdLineArgumentsAction.class, (String)"MSG_NotAvailableNow"), targetAppOrVMTerminated.getMessage()));
        }
    }

    public void profilingStateChanged(ProfilingStateEvent profilingStateEvent) {
        this.updateEnabledState();
    }

    public void threadsMonitoringChanged() {
    }

    public void instrumentationChanged(int n, int n2) {
    }

    private void updateEnabledState() {
        this.setEnabled(Profiler.getDefault().getProfilingState() == 4);
    }
}

