/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.text.MessageFormat;
import java.util.Date;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JTabbedPane;
import javax.swing.JToolBar;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.lib.profiler.results.ExportDataDumper;
import org.netbeans.lib.profiler.results.ResultsSnapshot;
import org.netbeans.lib.profiler.results.coderegion.CodeRegionResultsSnapshot;
import org.netbeans.lib.profiler.ui.UIUtils;
import org.netbeans.lib.profiler.ui.cpu.CodeRegionSnapshotPanel;
import org.netbeans.lib.profiler.utils.StringUtils;
import org.netbeans.modules.profiler.ExportAction;
import org.netbeans.modules.profiler.LoadedSnapshot;
import org.netbeans.modules.profiler.SnapshotInfoPanel;
import org.netbeans.modules.profiler.SnapshotPanel;
import org.openide.util.NbBundle;

public class FragmentSnapshotPanel
extends SnapshotPanel
implements ChangeListener,
ExportAction.ExportProvider {
    private static final String CALLS_TAB_NAME = NbBundle.getMessage(FragmentSnapshotPanel.class, (String)"FragmentSnapshotPanel_CallsTabName");
    private static final String INFO_TAB_NAME = NbBundle.getMessage(FragmentSnapshotPanel.class, (String)"FragmentSnapshotPanel_InfoTabName");
    private static final String CALLS_TAB_DESCR = NbBundle.getMessage(FragmentSnapshotPanel.class, (String)"FragmentSnapshotPanel_CallsTabDescr");
    private static final String INFO_TAB_DESCR = NbBundle.getMessage(FragmentSnapshotPanel.class, (String)"FragmentSnapshotPanel_InfoTabDescr");
    private static final String PANEL_TITLE = NbBundle.getMessage(FragmentSnapshotPanel.class, (String)"FragmentSnapshotPanel_PanelTitle");
    private CodeRegionResultsSnapshot snapshot;
    private JTabbedPane tabs = new JTabbedPane(3);
    private SnapshotInfoPanel infoPanel;

    public FragmentSnapshotPanel(LoadedSnapshot loadedSnapshot) {
        this.snapshot = (CodeRegionResultsSnapshot)loadedSnapshot.getSnapshot();
        this.setLayout(new BorderLayout());
        this.infoPanel = new SnapshotInfoPanel(loadedSnapshot);
        CodeRegionSnapshotPanel codeRegionSnapshotPanel = new CodeRegionSnapshotPanel(this.snapshot);
        this.infoPanel.updateInfo();
        this.tabs.addTab(CALLS_TAB_NAME, null, (Component)codeRegionSnapshotPanel, CALLS_TAB_DESCR);
        this.tabs.addTab(INFO_TAB_NAME, null, this.infoPanel, INFO_TAB_DESCR);
        this.add((Component)this.tabs, "Center");
        this.tabs.addChangeListener(this);
        JToolBar jToolBar = new JToolBar(){

            @Override
            public Component add(Component component) {
                if (component instanceof JButton) {
                    UIUtils.fixButtonUI((AbstractButton)((JButton)component));
                }
                return super.add(component);
            }
        };
        jToolBar.setFloatable(false);
        jToolBar.putClientProperty("JToolBar.isRollover", Boolean.TRUE);
        jToolBar.setBorder(BorderFactory.createEmptyBorder(4, 0, 4, 0));
        jToolBar.add(new ExportAction(this, loadedSnapshot));
        this.add((Component)jToolBar, "North");
        this.getActionMap().put("PreviousViewAction", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                FragmentSnapshotPanel.this.moveToPreviousSubTab();
            }
        });
        this.getActionMap().put("NextViewAction", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                FragmentSnapshotPanel.this.moveToNextSubTab();
            }
        });
    }

    @Override
    public ResultsSnapshot getSnapshot() {
        return this.snapshot;
    }

    @Override
    public String getTitle() {
        return MessageFormat.format(PANEL_TITLE, StringUtils.formatUserDate((Date)new Date(this.snapshot.getTimeTaken())));
    }

    @Override
    public void stateChanged(ChangeEvent changeEvent) {
        this.updateToolbar();
    }

    @Override
    public void updateSavedState() {
        this.infoPanel.updateInfo();
    }

    private void moveToNextSubTab() {
        this.tabs.setSelectedIndex(UIUtils.getNextSubTabIndex((JTabbedPane)this.tabs, (int)this.tabs.getSelectedIndex()));
    }

    private void moveToPreviousSubTab() {
        this.tabs.setSelectedIndex(UIUtils.getPreviousSubTabIndex((JTabbedPane)this.tabs, (int)this.tabs.getSelectedIndex()));
    }

    private void updateToolbar() {
    }

    @Override
    public String getViewName() {
        return PANEL_TITLE;
    }

    @Override
    public boolean hasLoadedSnapshot() {
        return true;
    }

    @Override
    public void exportData(int n, ExportDataDumper exportDataDumper) {
    }

    @Override
    public boolean hasExportableView() {
        return false;
    }
}

