/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.visualvm.profiling.snapshot.diff;

import com.sun.tools.visualvm.core.datasource.DataSource;
import com.sun.tools.visualvm.core.ui.DataSourceWindowManager;
import com.sun.tools.visualvm.core.ui.actions.MultiDataSourceAction;
import com.sun.tools.visualvm.profiling.snapshot.ProfilerSnapshot;
import com.sun.tools.visualvm.profiling.snapshot.diff.SnapshotDiffContainer;
import java.awt.event.ActionEvent;
import java.util.Set;
import org.netbeans.modules.profiler.LoadedSnapshot;
import org.netbeans.modules.profiler.NetBeansProfiler;
import org.openide.util.NbBundle;

final class CompareSnapshotsAction
extends MultiDataSourceAction<ProfilerSnapshot> {
    private static CompareSnapshotsAction instance;

    public static synchronized CompareSnapshotsAction instance() {
        if (instance == null) {
            instance = new CompareSnapshotsAction();
        }
        return instance;
    }

    protected void actionPerformed(Set<ProfilerSnapshot> snapshots, ActionEvent actionEvent) {
        ProfilerSnapshot[] snapshotsArr = snapshots.toArray(new ProfilerSnapshot[2]);
        LoadedSnapshot s1 = snapshotsArr[0].getLoadedSnapshot();
        LoadedSnapshot s2 = snapshotsArr[1].getLoadedSnapshot();
        if (org.netbeans.modules.profiler.actions.CompareSnapshotsAction.areComparableSnapshots((LoadedSnapshot)s2, (LoadedSnapshot)s1)) {
            SnapshotDiffContainer sdc = new SnapshotDiffContainer(snapshotsArr[0], snapshotsArr[1], snapshotsArr[0].getMaster());
            DataSourceWindowManager.sharedInstance().openDataSource((DataSource)sdc);
        } else {
            String msg = NbBundle.getMessage(CompareSnapshotsAction.class, (String)"MSG_Not_Comparable");
            NetBeansProfiler.getDefaultNB().displayError(msg);
        }
    }

    protected boolean isEnabled(Set<ProfilerSnapshot> snapshots) {
        if (snapshots.size() != 2) {
            return false;
        }
        ProfilerSnapshot[] snapshotsArr = snapshots.toArray(new ProfilerSnapshot[2]);
        LoadedSnapshot s1 = snapshotsArr[0].getLoadedSnapshot();
        LoadedSnapshot s2 = snapshotsArr[1].getLoadedSnapshot();
        return (s1.getType() & 0xC) != 0 && (s2.getType() & 0xC) != 0;
    }

    private CompareSnapshotsAction() {
        super(ProfilerSnapshot.class);
        this.putValue("Name", NbBundle.getMessage(CompareSnapshotsAction.class, (String)"MSG_Compare_Snapshots"));
        this.putValue("ShortDescription", NbBundle.getMessage(CompareSnapshotsAction.class, (String)"DESCR_Compare_Snapshots"));
    }
}

