/*
 * Decompiled with CFR 0.152.
 */
package name.yumao.douyu.utils;

import org.apache.mina.core.buffer.IoBuffer;

public class HexUtils {
    private static final byte[] hex = "0123456789ABCDEF".getBytes();

    public static IoBuffer hexString2IoBuffer(String hexString) {
        IoBuffer ioBuffer = IoBuffer.allocate((int)8);
        ioBuffer.setAutoExpand(true);
        ioBuffer.put(HexUtils.HexString2Bytes(hexString));
        ioBuffer.flip();
        return ioBuffer;
    }

    public static String ioBufferToString(Object message) throws Exception {
        if (!(message instanceof IoBuffer)) {
            return "";
        }
        IoBuffer ioBuffer = (IoBuffer)message;
        byte[] b = new byte[ioBuffer.limit()];
        ioBuffer.get(b);
        String bb = new String(b, "utf-8");
        return bb;
    }

    public static String ioBufferToHexString(Object message) throws Exception {
        if (!(message instanceof IoBuffer)) {
            return "";
        }
        IoBuffer ioBuffer = (IoBuffer)message;
        byte[] b = new byte[ioBuffer.limit()];
        ioBuffer.get(b);
        String bb = HexUtils.Bytes2HexString(b);
        return bb;
    }

    private static int parse(char c) {
        if (c >= 'a') {
            return c - 97 + 10 & 0xF;
        }
        if (c >= 'A') {
            return c - 65 + 10 & 0xF;
        }
        return c - 48 & 0xF;
    }

    public static String Bytes2HexString(byte[] b) {
        byte[] buff = new byte[3 * b.length];
        int i = 0;
        while (i < b.length) {
            buff[3 * i] = hex[b[i] >> 4 & 0xF];
            buff[3 * i + 1] = hex[b[i] & 0xF];
            buff[3 * i + 2] = 45;
            ++i;
        }
        String re = new String(buff);
        return re.replace("-", " ");
    }

    public static String Bytes2HexStringLower(byte[] b) {
        byte[] buff = new byte[3 * b.length];
        int i = 0;
        while (i < b.length) {
            buff[3 * i] = hex[b[i] >> 4 & 0xF];
            buff[3 * i + 1] = hex[b[i] & 0xF];
            buff[3 * i + 2] = 45;
            ++i;
        }
        String re = new String(buff);
        return re.replace("-", "").toLowerCase();
    }

    public static byte[] HexString2Bytes(String hexstr) {
        hexstr = hexstr.replace(" ", "");
        byte[] b = new byte[hexstr.length() / 2];
        int j = 0;
        int i = 0;
        while (i < b.length) {
            char c0 = hexstr.charAt(j++);
            char c1 = hexstr.charAt(j++);
            b[i] = (byte)(HexUtils.parse(c0) << 4 | HexUtils.parse(c1));
            ++i;
        }
        return b;
    }

    public static String setStringHeader(String hexStr) {
        String length = String.valueOf(Integer.toHexString((hexStr.length() + 8) / 2)) + "000000";
        return String.valueOf(length) + length + hexStr;
    }

    public static int getHexStringLength(String hexStr) {
        if ((hexStr = hexStr.replace(" ", "")).length() < 8) {
            return hexStr.length() + 1;
        }
        String headerStr = hexStr.substring(0, 8);
        String hexLength = "";
        int i = 6;
        while (i >= 0) {
            hexLength = String.valueOf(hexLength) + headerStr.substring(i, i + 2);
            i -= 2;
        }
        return Integer.parseInt(hexLength, 16) * 2 - 8;
    }
}

