/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.image;

import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.BandedSampleModel;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.Raster;
import java.awt.image.RasterFormatException;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import sun.awt.image.SunWritableRaster;

public class ByteBandedRaster
extends SunWritableRaster {
    int[] dataOffsets;
    int scanlineStride;
    byte[][] data;
    private int maxX;
    private int maxY;

    public ByteBandedRaster(SampleModel sampleModel, Point point) {
        this(sampleModel, sampleModel.createDataBuffer(), new Rectangle(point.x, point.y, sampleModel.getWidth(), sampleModel.getHeight()), point, null);
    }

    public ByteBandedRaster(SampleModel sampleModel, DataBuffer dataBuffer, Point point) {
        this(sampleModel, dataBuffer, new Rectangle(point.x, point.y, sampleModel.getWidth(), sampleModel.getHeight()), point, null);
    }

    public ByteBandedRaster(SampleModel sampleModel, DataBuffer dataBuffer, Rectangle rectangle, Point point, ByteBandedRaster byteBandedRaster) {
        super(sampleModel, dataBuffer, rectangle, point, byteBandedRaster);
        this.maxX = this.minX + this.width;
        this.maxY = this.minY + this.height;
        if (!(dataBuffer instanceof DataBufferByte)) {
            throw new RasterFormatException("ByteBandedRaster must havebyte DataBuffers");
        }
        DataBufferByte dataBufferByte = (DataBufferByte)dataBuffer;
        if (sampleModel instanceof BandedSampleModel) {
            BandedSampleModel bandedSampleModel = (BandedSampleModel)sampleModel;
            this.scanlineStride = bandedSampleModel.getScanlineStride();
            int[] nArray = bandedSampleModel.getBankIndices();
            int[] nArray2 = bandedSampleModel.getBandOffsets();
            int[] nArray3 = dataBufferByte.getOffsets();
            this.dataOffsets = new int[nArray.length];
            this.data = new byte[nArray.length][];
            int n = rectangle.x - point.x;
            int n2 = rectangle.y - point.y;
            for (int i = 0; i < nArray.length; ++i) {
                this.data[i] = ByteBandedRaster.stealData(dataBufferByte, nArray[i]);
                this.dataOffsets[i] = nArray3[nArray[i]] + n + n2 * this.scanlineStride + nArray2[i];
            }
        } else {
            throw new RasterFormatException("ByteBandedRasters must haveBandedSampleModels");
        }
        this.verify();
    }

    public int[] getDataOffsets() {
        return (int[])this.dataOffsets.clone();
    }

    public int getDataOffset(int n) {
        return this.dataOffsets[n];
    }

    public int getScanlineStride() {
        return this.scanlineStride;
    }

    public int getPixelStride() {
        return 1;
    }

    public byte[][] getDataStorage() {
        return this.data;
    }

    public byte[] getDataStorage(int n) {
        return this.data[n];
    }

    @Override
    public Object getDataElements(int n, int n2, Object object) {
        if (n < this.minX || n2 < this.minY || n >= this.maxX || n2 >= this.maxY) {
            throw new ArrayIndexOutOfBoundsException("Coordinate out of bounds!");
        }
        byte[] byArray = object == null ? new byte[this.numDataElements] : (byte[])object;
        int n3 = (n2 - this.minY) * this.scanlineStride + (n - this.minX);
        for (int i = 0; i < this.numDataElements; ++i) {
            byArray[i] = this.data[i][this.dataOffsets[i] + n3];
        }
        return byArray;
    }

    @Override
    public Object getDataElements(int n, int n2, int n3, int n4, Object object) {
        if (n < this.minX || n2 < this.minY || n + n3 > this.maxX || n2 + n4 > this.maxY) {
            throw new ArrayIndexOutOfBoundsException("Coordinate out of bounds!");
        }
        byte[] byArray = object == null ? new byte[this.numDataElements * n3 * n4] : (byte[])object;
        int n5 = (n2 - this.minY) * this.scanlineStride + (n - this.minX);
        for (int i = 0; i < this.numDataElements; ++i) {
            int n6 = i;
            byte[] byArray2 = this.data[i];
            int n7 = this.dataOffsets[i];
            int n8 = n5;
            int n9 = 0;
            while (n9 < n4) {
                int n10 = n7 + n8;
                for (int j = 0; j < n3; ++j) {
                    byArray[n6] = byArray2[n10++];
                    n6 += this.numDataElements;
                }
                ++n9;
                n8 += this.scanlineStride;
            }
        }
        return byArray;
    }

    public byte[] getByteData(int n, int n2, int n3, int n4, int n5, byte[] byArray) {
        if (n < this.minX || n2 < this.minY || n + n3 > this.maxX || n2 + n4 > this.maxY) {
            throw new ArrayIndexOutOfBoundsException("Coordinate out of bounds!");
        }
        if (byArray == null) {
            byArray = new byte[this.scanlineStride * n4];
        }
        int n6 = (n2 - this.minY) * this.scanlineStride + (n - this.minX) + this.dataOffsets[n5];
        if (this.scanlineStride == n3) {
            System.arraycopy(this.data[n5], n6, byArray, 0, n3 * n4);
        } else {
            int n7 = 0;
            int n8 = 0;
            while (n8 < n4) {
                System.arraycopy(this.data[n5], n6, byArray, n7, n3);
                n7 += n3;
                ++n8;
                n6 += this.scanlineStride;
            }
        }
        return byArray;
    }

    public byte[] getByteData(int n, int n2, int n3, int n4, byte[] byArray) {
        if (n < this.minX || n2 < this.minY || n + n3 > this.maxX || n2 + n4 > this.maxY) {
            throw new ArrayIndexOutOfBoundsException("Coordinate out of bounds!");
        }
        if (byArray == null) {
            byArray = new byte[this.numDataElements * this.scanlineStride * n4];
        }
        int n5 = (n2 - this.minY) * this.scanlineStride + (n - this.minX);
        for (int i = 0; i < this.numDataElements; ++i) {
            int n6 = i;
            byte[] byArray2 = this.data[i];
            int n7 = this.dataOffsets[i];
            int n8 = n5;
            int n9 = 0;
            while (n9 < n4) {
                int n10 = n7 + n8;
                for (int j = 0; j < n3; ++j) {
                    byArray[n6] = byArray2[n10++];
                    n6 += this.numDataElements;
                }
                ++n9;
                n8 += this.scanlineStride;
            }
        }
        return byArray;
    }

    @Override
    public void setDataElements(int n, int n2, Object object) {
        if (n < this.minX || n2 < this.minY || n >= this.maxX || n2 >= this.maxY) {
            throw new ArrayIndexOutOfBoundsException("Coordinate out of bounds!");
        }
        byte[] byArray = (byte[])object;
        int n3 = (n2 - this.minY) * this.scanlineStride + (n - this.minX);
        for (int i = 0; i < this.numDataElements; ++i) {
            this.data[i][this.dataOffsets[i] + n3] = byArray[i];
        }
        this.markDirty();
    }

    @Override
    public void setDataElements(int n, int n2, Raster raster) {
        int n3 = raster.getMinX() + n;
        int n4 = raster.getMinY() + n2;
        int n5 = raster.getWidth();
        int n6 = raster.getHeight();
        if (n3 < this.minX || n4 < this.minY || n3 + n5 > this.maxX || n4 + n6 > this.maxY) {
            throw new ArrayIndexOutOfBoundsException("Coordinate out of bounds!");
        }
        this.setDataElements(n3, n4, n5, n6, raster);
    }

    private void setDataElements(int n, int n2, int n3, int n4, Raster raster) {
        if (n3 <= 0 || n4 <= 0) {
            return;
        }
        int n5 = raster.getMinX();
        int n6 = raster.getMinY();
        Object object = null;
        for (int i = 0; i < n4; ++i) {
            object = raster.getDataElements(n5, n6 + i, n3, 1, object);
            this.setDataElements(n, n2 + i, n3, 1, object);
        }
    }

    @Override
    public void setDataElements(int n, int n2, int n3, int n4, Object object) {
        if (n < this.minX || n2 < this.minY || n + n3 > this.maxX || n2 + n4 > this.maxY) {
            throw new ArrayIndexOutOfBoundsException("Coordinate out of bounds!");
        }
        byte[] byArray = (byte[])object;
        int n5 = (n2 - this.minY) * this.scanlineStride + (n - this.minX);
        for (int i = 0; i < this.numDataElements; ++i) {
            int n6 = i;
            byte[] byArray2 = this.data[i];
            int n7 = this.dataOffsets[i];
            int n8 = n5;
            int n9 = 0;
            while (n9 < n4) {
                int n10 = n7 + n8;
                for (int j = 0; j < n3; ++j) {
                    byArray2[n10++] = byArray[n6];
                    n6 += this.numDataElements;
                }
                ++n9;
                n8 += this.scanlineStride;
            }
        }
        this.markDirty();
    }

    public void putByteData(int n, int n2, int n3, int n4, int n5, byte[] byArray) {
        if (n < this.minX || n2 < this.minY || n + n3 > this.maxX || n2 + n4 > this.maxY) {
            throw new ArrayIndexOutOfBoundsException("Coordinate out of bounds!");
        }
        int n6 = (n2 - this.minY) * this.scanlineStride + (n - this.minX) + this.dataOffsets[n5];
        int n7 = 0;
        if (this.scanlineStride == n3) {
            System.arraycopy(byArray, 0, this.data[n5], n6, n3 * n4);
        } else {
            int n8 = 0;
            while (n8 < n4) {
                System.arraycopy(byArray, n7, this.data[n5], n6, n3);
                n7 += n3;
                ++n8;
                n6 += this.scanlineStride;
            }
        }
        this.markDirty();
    }

    public void putByteData(int n, int n2, int n3, int n4, byte[] byArray) {
        if (n < this.minX || n2 < this.minY || n + n3 > this.maxX || n2 + n4 > this.maxY) {
            throw new ArrayIndexOutOfBoundsException("Coordinate out of bounds!");
        }
        int n5 = (n2 - this.minY) * this.scanlineStride + (n - this.minX);
        for (int i = 0; i < this.numDataElements; ++i) {
            int n6 = i;
            byte[] byArray2 = this.data[i];
            int n7 = this.dataOffsets[i];
            int n8 = n5;
            int n9 = 0;
            while (n9 < n4) {
                int n10 = n7 + n8;
                for (int j = 0; j < n3; ++j) {
                    byArray2[n10++] = byArray[n6];
                    n6 += this.numDataElements;
                }
                ++n9;
                n8 += this.scanlineStride;
            }
        }
        this.markDirty();
    }

    @Override
    public WritableRaster createWritableChild(int n, int n2, int n3, int n4, int n5, int n6, int[] nArray) {
        if (n < this.minX) {
            throw new RasterFormatException("x lies outside raster");
        }
        if (n2 < this.minY) {
            throw new RasterFormatException("y lies outside raster");
        }
        if (n + n3 < n || n + n3 > this.width + this.minX) {
            throw new RasterFormatException("(x + width) is outside raster");
        }
        if (n2 + n4 < n2 || n2 + n4 > this.height + this.minY) {
            throw new RasterFormatException("(y + height) is outside raster");
        }
        SampleModel sampleModel = nArray != null ? this.sampleModel.createSubsetSampleModel(nArray) : this.sampleModel;
        int n7 = n5 - n;
        int n8 = n6 - n2;
        return new ByteBandedRaster(sampleModel, this.dataBuffer, new Rectangle(n5, n6, n3, n4), new Point(this.sampleModelTranslateX + n7, this.sampleModelTranslateY + n8), this);
    }

    @Override
    public Raster createChild(int n, int n2, int n3, int n4, int n5, int n6, int[] nArray) {
        return this.createWritableChild(n, n2, n3, n4, n5, n6, nArray);
    }

    @Override
    public WritableRaster createCompatibleWritableRaster(int n, int n2) {
        if (n <= 0 || n2 <= 0) {
            throw new RasterFormatException("negative " + (n <= 0 ? "width" : "height"));
        }
        SampleModel sampleModel = this.sampleModel.createCompatibleSampleModel(n, n2);
        return new ByteBandedRaster(sampleModel, new Point(0, 0));
    }

    @Override
    public WritableRaster createCompatibleWritableRaster() {
        return this.createCompatibleWritableRaster(this.width, this.height);
    }

    private void verify() {
        int n;
        int n2;
        if (this.width <= 0 || this.height <= 0 || this.height > Integer.MAX_VALUE / this.width) {
            throw new RasterFormatException("Invalid raster dimension");
        }
        if (this.scanlineStride < 0 || this.scanlineStride > Integer.MAX_VALUE / this.height) {
            throw new RasterFormatException("Incorrect scanline stride: " + this.scanlineStride);
        }
        for (n2 = 0; n2 < this.data.length; ++n2) {
            if (this.scanlineStride <= this.data[n2].length) continue;
            throw new RasterFormatException("Incorrect scanline stride: " + this.scanlineStride);
        }
        for (n2 = 0; n2 < this.dataOffsets.length; ++n2) {
            if (this.dataOffsets[n2] >= 0) continue;
            throw new RasterFormatException("Data offsets for band " + n2 + "(" + this.dataOffsets[n2] + ") must be >= 0");
        }
        n2 = (this.height - 1) * this.scanlineStride;
        if (this.width - 1 > Integer.MAX_VALUE - n2) {
            throw new RasterFormatException("Invalid raster dimension");
        }
        int n3 = n2 + (this.width - 1);
        int n4 = 0;
        for (n = 0; n < this.numDataElements; ++n) {
            if (this.dataOffsets[n] > Integer.MAX_VALUE - n3) {
                throw new RasterFormatException("Invalid raster dimension");
            }
            int n5 = n3 + this.dataOffsets[n];
            if (n5 <= n4) continue;
            n4 = n5;
        }
        if (this.data.length == 1) {
            if (this.data[0].length <= n4 * this.numDataElements) {
                throw new RasterFormatException("Data array too small (it is " + this.data[0].length + " and should be > " + n4 * this.numDataElements + " )");
            }
        } else {
            for (n = 0; n < this.numDataElements; ++n) {
                if (this.data[n].length > n4) continue;
                throw new RasterFormatException("Data array too small (it is " + this.data[n].length + " and should be > " + n4 + " )");
            }
        }
    }

    public String toString() {
        return new String("ByteBandedRaster: width = " + this.width + " height = " + this.height + " #bands " + this.numDataElements + " minX = " + this.minX + " minY = " + this.minY);
    }
}

