/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.xerces.internal.utils;

import com.sun.org.apache.xerces.internal.utils.XMLSecurityManager;
import java.util.Formatter;
import java.util.HashMap;
import java.util.Map;

public final class XMLLimitAnalyzer {
    private XMLSecurityManager securityManager;
    private final int[] values;
    private final String[] names;
    private final int[] totalValue;
    private final Map[] caches;
    private String entityStart;
    private String entityEnd;

    public XMLLimitAnalyzer(XMLSecurityManager securityManager) {
        this.securityManager = securityManager;
        this.values = new int[XMLSecurityManager.Limit.values().length];
        this.totalValue = new int[XMLSecurityManager.Limit.values().length];
        this.names = new String[XMLSecurityManager.Limit.values().length];
        this.caches = new Map[XMLSecurityManager.Limit.values().length];
    }

    public void addValue(XMLSecurityManager.Limit limit, String entityName, int value) {
        this.addValue(limit.ordinal(), entityName, value);
    }

    public void addValue(int index, String entityName, int value) {
        Map<String, Integer> cache;
        if (index == XMLSecurityManager.Limit.ENTITY_EXPANSION_LIMIT.ordinal() || index == XMLSecurityManager.Limit.MAX_OCCUR_NODE_LIMIT.ordinal() || index == XMLSecurityManager.Limit.ELEMENT_ATTRIBUTE_LIMIT.ordinal()) {
            int n = index;
            this.totalValue[n] = this.totalValue[n] + value;
            return;
        }
        if (this.caches[index] == null) {
            this.caches[index] = cache = new HashMap(10);
        } else {
            cache = this.caches[index];
        }
        int accumulatedValue = value;
        if (cache.containsKey(entityName)) {
            cache.put(entityName, accumulatedValue += ((Integer)cache.get(entityName)).intValue());
        } else {
            cache.put(entityName, value);
        }
        if (accumulatedValue > this.values[index]) {
            this.values[index] = accumulatedValue;
            this.names[index] = entityName;
        }
        if (index == XMLSecurityManager.Limit.GENEAL_ENTITY_SIZE_LIMIT.ordinal() || index == XMLSecurityManager.Limit.PARAMETER_ENTITY_SIZE_LIMIT.ordinal()) {
            int n = XMLSecurityManager.Limit.TOTAL_ENTITY_SIZE_LIMIT.ordinal();
            this.totalValue[n] = this.totalValue[n] + value;
        }
    }

    public int getValue(XMLSecurityManager.Limit limit) {
        return this.values[limit.ordinal()];
    }

    public int getValue(int index) {
        return this.values[index];
    }

    public int getTotalValue(XMLSecurityManager.Limit limit) {
        return this.totalValue[limit.ordinal()];
    }

    public int getTotalValue(int index) {
        return this.totalValue[index];
    }

    public int getValueByIndex(int index) {
        return this.values[index];
    }

    public void startEntity(String name) {
        this.entityStart = name;
    }

    public boolean isTracking(String name) {
        if (this.entityStart == null) {
            return false;
        }
        return this.entityStart.equals(name);
    }

    public void endEntity(XMLSecurityManager.Limit limit, String name) {
        this.entityStart = "";
        Map cache = this.caches[limit.ordinal()];
        if (cache != null) {
            cache.remove(name);
        }
    }

    public void debugPrint() {
        Formatter formatter = new Formatter();
        System.out.println(formatter.format("%30s %15s %15s %15s %30s", "Property", "Limit", "Total size", "Size", "Entity Name"));
        for (XMLSecurityManager.Limit limit : XMLSecurityManager.Limit.values()) {
            formatter = new Formatter();
            System.out.println(formatter.format("%30s %15d %15d %15d %30s", limit.name(), this.securityManager.getLimit(limit), this.totalValue[limit.ordinal()], this.values[limit.ordinal()], this.names[limit.ordinal()]));
        }
    }

    public static enum NameMap {
        ENTITY_EXPANSION_LIMIT("jdk.xml.entityExpansionLimit", "entityExpansionLimit"),
        MAX_OCCUR_NODE_LIMIT("jdk.xml.maxOccurLimit", "maxOccurLimit"),
        ELEMENT_ATTRIBUTE_LIMIT("jdk.xml.elementAttributeLimit", "elementAttributeLimit");

        final String newName;
        final String oldName;

        private NameMap(String newName, String oldName) {
            this.newName = newName;
            this.oldName = oldName;
        }

        String getOldName(String newName) {
            if (newName.equals(this.newName)) {
                return this.oldName;
            }
            return null;
        }
    }
}

