/*
 * Decompiled with CFR 0.152.
 */
package chm.writer.hh;

import chm.writer.Util;
import chm.writer.entity.Entry;
import chm.writer.entity.FilePath;
import chm.writer.entity.IndexHtmlFile;
import chm.writer.entity.Pair;
import chm.writer.hh.HH;
import java.io.File;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.htmlparser.NodeFilter;
import org.htmlparser.Parser;
import org.htmlparser.filters.TagNameFilter;
import org.htmlparser.util.NodeList;

public class HHK
extends HH {
    private String docPath;
    private String tmpFolderName;
    private int beginIndex;

    public HHK(String path, String docPath) {
        super(path);
        this.docPath = docPath;
        this.tmpFolderName = String.format("chm_writer_tmp_%f", Math.random());
        this.beginIndex = docPath.length() + 1;
        new File(String.format("%s/%s", this.docPath, this.tmpFolderName)).mkdir();
    }

    private boolean parseIndexHtmlFiles() throws SQLException {
        boolean result = false;
        List list = sqlMapClient.queryForList("selectAllIndexHtmlFiles");
        if (list.size() > 0) {
            for (IndexHtmlFile ihf : list) {
                this.createEntries(ihf.getPath());
            }
            this.createPairs();
            result = true;
        }
        return result;
    }

    private void createEntries(String indexHtmlFilePath) {
        String prefix = "";
        File file = new File(indexHtmlFilePath);
        prefix = file.getName().equals("index-all.html") ? Util.substring(file.getParent(), this.beginIndex) : Util.substring(file.getParentFile().getParent(), this.beginIndex);
        try {
            Parser parser = new Parser(indexHtmlFilePath);
            parser.setEncoding("gb2312");
            NodeList dts = parser.parse((NodeFilter)new TagNameFilter("dt"));
            int i = 0;
            while (i < dts.size()) {
                Entry entry = Entry.parse(dts.elementAt(i), prefix);
                if (entry != null) {
                    sqlMapClient.insert("insertEntry", (Object)entry);
                }
                ++i;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void createPairs() throws SQLException {
        List entries = sqlMapClient.queryForList("selectAllEntries");
        String name = "";
        ArrayList<Entry> list = new ArrayList<Entry>();
        int i = 0;
        while (i < entries.size()) {
            Entry entry = (Entry)entries.get(i);
            if (!entry.getName().equals(name)) {
                if (i != 0) {
                    sqlMapClient.insert("insertPair", (Object)this.createPair(list));
                }
                name = entry.getName();
                list.clear();
            }
            list.add(entry);
            if (i == entries.size() - 1) {
                sqlMapClient.insert("insertPair", (Object)this.createPair(list));
            }
            ++i;
        }
    }

    private Pair createPair(List<Entry> entries) throws SQLException {
        if (entries.size() == 0) {
            return null;
        }
        Pair result = new Pair();
        String name = entries.get(0).getName();
        result.setKey(name);
        if (entries.size() == 1) {
            result.setValue(entries.get(0).getPath());
        } else {
            StringBuilder content = new StringBuilder();
            content.append(String.format("<html><head><meta http-equiv='Content-Type' content='text/html; charset=utf-8'/><title>Occurences of %s</title></head>", name));
            content.append("<body style='{font-family:Verdana,Arial; font-size:10pt; }'>");
            content.append(String.format("<dl><dt><b>%s</b>:", name));
            for (Entry entry : entries) {
                content.append(String.format("<dd><a href='../%s'>%s</a></dd>", entry.getPath(), entry.getCompleteName()));
            }
            content.append("</dl></body></html>");
            String tmpHtmlFileName = String.format("%s_%f.chm.writer.tmp.html", name, Math.random());
            String tmpHtmlFileAbsolutePath = String.format("%s/%s/%s", this.docPath, this.tmpFolderName, tmpHtmlFileName, tmpHtmlFileName);
            Util.save(content.toString(), tmpHtmlFileAbsolutePath);
            FilePath fp = new FilePath();
            fp.setPath(tmpHtmlFileAbsolutePath.substring(this.beginIndex));
            sqlMapClient.insert("insertFilePath", (Object)fp);
            result.setValue(String.format("%s\\%s", this.tmpFolderName, tmpHtmlFileName));
        }
        return result;
    }

    @Override
    public boolean generate() {
        boolean result = false;
        if (this.open()) {
            try {
                if (this.parseIndexHtmlFiles()) {
                    List pairs = sqlMapClient.queryForList("selectAllPairs");
                    this.writeLn("<!DOCTYPE HTML PUBLIC \"-//IETF//DTD HTML//EN\">");
                    this.writeLn("<HTML><HEAD></HEAD><BODY><UL>");
                    for (Pair pair : pairs) {
                        this.writeLn("<LI><OBJECT type=\"text/sitemap\">");
                        this.writeLn(String.format("<param name=\"Name\" value=\"%s\">", pair.getKey()));
                        this.writeLn(String.format("<param name=\"Local\" value=\"%s\">", pair.getValue()));
                        this.writeLn("</OBJECT>");
                    }
                    this.writeLn("</UL></BODY></HTML>");
                    result = true;
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        this.close();
        return result;
    }

    @Override
    public void clean() {
        super.clean();
        Util.delete(String.format("%s/%s", this.docPath, this.tmpFolderName));
    }
}

