/*
 * Decompiled with CFR 0.152.
 */
package chm.writer.hh;

import chm.writer.Util;
import chm.writer.entity.FilePath;
import chm.writer.entity.IndexHtmlFile;
import chm.writer.hh.HH;
import java.io.File;
import java.io.IOException;
import java.sql.SQLException;

public class HHC
extends HH {
    private String docPath;
    private int beginIndex;

    public HHC(String path, String docPath) {
        super(path);
        this.docPath = docPath;
        this.beginIndex = this.docPath.length() + 1;
    }

    private void parse(File file, boolean isRoot) throws IOException, SQLException {
        if (file.isDirectory()) {
            if (isRoot) {
                this.writeLn("<!DOCTYPE HTML PUBLIC \"-//IETF//DTD HTML//EN\">");
                this.writeLn("<HTML><HEAD></HEAD><BODY>");
                this.writeLn("<OBJECT type=\"text/site properties\"><param name=\"Window Styles\" value=\"0x800025\"/></OBJECT>");
            } else {
                String name = file.getName();
                if (!name.startsWith("chm_writer_tmp")) {
                    this.writeLn(String.format("<LI><OBJECT type=\"text/sitemap\"><param name=\"Name\" value=\"%s\"/></OBJECT></LI>", name));
                }
            }
            File[] files = file.listFiles();
            if (files.length > 0) {
                this.writeLn("<UL>");
                File[] fileArray = files;
                int n = files.length;
                int n2 = 0;
                while (n2 < n) {
                    File subFile = fileArray[n2];
                    this.parse(subFile, false);
                    ++n2;
                }
                this.writeLn("</UL>");
            }
            if (isRoot) {
                this.writeLn("</BODY></HTML>");
            }
        } else {
            String absolutePath = file.getAbsolutePath();
            String fileName = file.getName();
            if (fileName.startsWith("index-")) {
                IndexHtmlFile ihf = new IndexHtmlFile();
                ihf.setPath(absolutePath);
                sqlMapClient.insert("insertIndexHtmlFile", (Object)ihf);
            }
            String relativePath = file.getAbsolutePath().substring(this.beginIndex);
            String fileExt = Util.getFileExt(fileName);
            if (!(relativePath.isEmpty() || fileExt.equals(".hhc") || fileExt.equals(".hhk") || fileExt.equals(".hhp"))) {
                FilePath fp = new FilePath();
                fp.setPath(relativePath);
                sqlMapClient.insert("insertFilePath", (Object)fp);
                String title = "";
                if (fileExt.equals(".html") || fileExt.equals(".htm")) {
                    title = Util.getTitle(file, "gb2312");
                    title = title.trim();
                    title = title.replace("\"", "&quot;");
                    title = title.replace("\r\n", " ");
                }
                if (title.isEmpty()) {
                    title = fileName;
                }
                if (!title.isEmpty()) {
                    this.writeLn(String.format("<LI><OBJECT type=\"text/sitemap\"><param name=\"Name\" value=\"%s\"/><param name=\"Local\" value=\"%s\"/></OBJECT></LI>", title, relativePath));
                }
            }
        }
    }

    @Override
    public boolean generate() {
        boolean result = false;
        if (this.open()) {
            try {
                this.parse(new File(this.docPath), true);
                result = true;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.close();
        }
        return result;
    }
}

