/*
 * Decompiled with CFR 0.152.
 */
package chm.writer.entity;

import org.htmlparser.Node;
import org.htmlparser.NodeFilter;
import org.htmlparser.filters.TagNameFilter;
import org.htmlparser.tags.LinkTag;
import org.htmlparser.util.NodeList;

public class Entry {
    private String name;
    private String completeName;
    private String path;

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getCompleteName() {
        return this.completeName;
    }

    public void setCompleteName(String completeName) {
        this.completeName = completeName;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    private static String toName(String name) {
        String result = name.trim();
        int endIndex = result.indexOf("(");
        if (endIndex > -1) {
            result = result.substring(0, endIndex);
        }
        return result;
    }

    private static String toCompleteName(String href) {
        String result = href.trim();
        if (result.startsWith("./")) {
            result = result.substring(2);
        } else if (result.startsWith("../")) {
            result = result.substring(3);
        }
        result = result.replace("/", ".");
        result = result.replace("#", ".");
        result = result.replace(".html", "");
        result = result.replace(".htm", "");
        return result;
    }

    private static String toPath(String href, String prefix) {
        String result = href.trim();
        if (result.startsWith("./")) {
            result = result.substring(2);
        } else if (result.startsWith("../")) {
            result = result.substring(3);
        }
        result = result.replace("/", "\\");
        if (!prefix.isEmpty()) {
            result = String.valueOf(prefix) + "\\" + result;
        }
        return result;
    }

    public static Entry parse(Node dt, String prefix) {
        NodeList list;
        Entry result = null;
        String pts = dt.toPlainTextString().toLowerCase();
        if (pts.indexOf("constructor for class") == -1 && pts.indexOf("\u6784\u9020\u65b9\u6cd5") == -1 && (list = dt.getChildren().extractAllNodesThatMatch((NodeFilter)new TagNameFilter("a"), true)).size() > 0) {
            Node node = list.elementAt(0);
            LinkTag tag = (LinkTag)node;
            String href = tag.getAttribute("href");
            String name = Entry.toName(tag.toPlainTextString());
            String path = Entry.toPath(href, prefix);
            String completeName = Entry.toCompleteName(href);
            result = new Entry();
            result.setName(name);
            result.setCompleteName(completeName);
            result.setPath(path);
        }
        return result;
    }

    public String toString() {
        return String.format("Entry name:%s,completeName:%s,path:%s", this.name, this.completeName, this.path);
    }
}

