/*
 * Decompiled with CFR 0.152.
 */
package chm.writer;

import chm.writer.Util;
import chm.writer.hh.HH;
import chm.writer.hh.HHC;
import chm.writer.hh.HHK;
import chm.writer.hh.HHP;
import java.io.File;
import java.io.InputStream;

public class Generator {
    private String docPath;
    private String chmFileName;
    private String chmTitle;

    public Generator(String docPath, String chmFileName, String chmTitle) {
        this.docPath = new File(Util.adjustDirectoryPath(docPath)).getAbsolutePath();
        this.chmFileName = chmFileName;
        this.chmTitle = chmTitle;
    }

    private boolean callHhcExe(String hhpPath) {
        boolean result = false;
        InputStream in = null;
        if (new File("hhc/hhc.exe").exists()) {
            try {
                try {
                    String command = String.format("hhc\\hhc.exe \"%s\"", hhpPath.replace("/", "\\"));
                    Process process = Runtime.getRuntime().exec(command);
                    in = process.getInputStream();
                    while (in.read() != -1) {
                    }
                    result = true;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    try {
                        if (in != null) {
                            in.close();
                        }
                    }
                    catch (Exception exception) {}
                }
            }
            finally {
                try {
                    if (in != null) {
                        in.close();
                    }
                }
                catch (Exception exception) {}
            }
        }
        return result;
    }

    public String execute() {
        if (!Util.validateJavaDocPath(this.docPath)) {
            return String.format("%s\u4e0d\u662f\u4e00\u4e2a\u6709\u6548\u7684Java Doc\u76ee\u5f55", this.docPath);
        }
        HH hhc = null;
        HHK hhk = null;
        HHP hhp = null;
        try {
            String hhcPath = String.format("%s/tmp.hhc", this.docPath);
            String hhkPath = String.format("%s/tmp.hhk", this.docPath);
            String hhpPath = String.format("%s/tmp.hhp", this.docPath);
            hhc = new HHC(hhcPath, this.docPath);
            if (!((HHC)hhc).generate()) {
                return "hhc\u6587\u4ef6\u521b\u5efa\u5931\u8d25!";
            }
            hhk = new HHK(hhkPath, this.docPath);
            if (!hhk.generate()) {
                return "hhk\u6587\u4ef6\u521b\u5efa\u5931\u8d25!";
            }
            hhp = new HHP(hhpPath, this.chmFileName, this.chmTitle);
            if (!hhp.generate()) {
                return "hhp\u6587\u4ef6\u521b\u5efa\u5931\u8d25!";
            }
            if (!this.callHhcExe(hhpPath)) {
                return "\u8c03\u7528hhc.exe\u5931\u8d25!";
            }
            return "chm\u6587\u4ef6\u751f\u6210\u5b8c\u6bd5!";
        }
        finally {
            if (hhp != null) {
                hhp.clean();
            }
            if (hhc != null) {
                hhc.clean();
            }
            if (hhk != null) {
                hhk.clean();
            }
        }
    }
}

