-- v2 : Maxwell update
-- Hunger update
-- Fixed for Powers update
-- Update v1.6 : Revealed areas load again upon loading a save
-- Update v1.5 : Underground update
--				 note : save/load system has changed so the extra terrain revealed won't be saved.. for now
-- Update v1.4 : bugfix : when you went to a new level it would keep the map revealed
-- 				 note : if you load a game saved from an old version it will save the current map as the survival map not as adventure map
-- Update v1.3 : What is revealed on the map will be saved. All credits go to no_signal and his awesome mod MapRevealRadius
-- Update v1.2 : What you see matches what's revealed on the map
-- Release version
-- Revealer by No_Signal
-- Mod by Kiopho

local FOV = 45
local RADIUS = 72

local FollowCamera = GLOBAL.require("cameras/followcamera")
local default = FollowCamera.SetDefault
FollowCamera.SetDefault = function (self)
	default(self)
	self.fov = FOV
end

local function addRevealer(inst)
	inst:AddComponent("revealer")
	inst.components.revealer.radius = RADIUS
	inst.components.revealer:StartUpdating()
end

for k,prefabname in ipairs(CHARACTERLIST) do
	AddPrefabPostInit(prefabname, addRevealer)
end