require "behaviours/wander"
require "behaviours/runaway"
require "behaviours/doaction"
require "behaviours/panic"
require "behaviours/chattynode"

local START_FACE_DIST = 6
local KEEP_FACE_DIST = 8
local GO_HOME_DIST = 10
local MAX_WANDER_DIST = 8
local MAX_CHASE_TIME = 10
local MAX_CHASE_DIST = 20
local RUN_AWAY_DIST = 5
local STOP_RUN_AWAY_DIST = 8
local SEE_ENTITY_DIST = 30
local SEE_TRAP_DIST = 2
local AWAY_TRAP_DIST = 3
local SEE_MINES_DIST= 5
local AWAY_HOME_DIST = 6
local START_RUN_DIST = 5
local STOP_RUN_DIST = 40
local TRACE_PLAYER_DIST=1
 

local function GoHomeAction(inst)
    if inst.components.homeseeker and 
       inst.components.homeseeker.home and 
       inst.components.homeseeker.home:IsValid() and 
       inst.components.homeseeker.home.components.childspawner then 
        return BufferedAction(inst, inst.components.homeseeker.home, ACTIONS.GOHOME)
    end
end

local function FindItemAction(inst)
    local target = FindEntity(inst, SEE_ENTITY_DIST, function(guy)
        return  not guy.components.activatable and 
            (   
                inst.components.eater:CanEat(guy) 
                or (guy.components.inventoryitem and guy.components.inventoryitem.canbepickedup)
                or (guy.components.trap and guy.components.trap.issprung) 
                or (guy.components.stewer and guy.components.stewer.done)
                or (guy.components.crop and guy.components.crop:IsReadyForHarvest())
                or (guy.components.harvestable and guy.components.harvestable:CanBeHarvested())
            )
    end)

    if not target then
        target = FindEntity(inst, SEE_ENTITY_DIST/1.5, function(guy)
        return (guy.components.workable and guy.components.workable.action == ACTIONS.CHOP)
            or (guy.components.pickable and guy.components.pickable:CanBePicked() and guy.components.pickable.caninteractwith) --能被采集的东西        
        end)
    end
    local has_active_item = inst.components.inventory:GetActiveItem() ~= nil
    local action=nil

    if  target and inst.components.eater:CanEat(target) then
        action = ACTIONS.EAT
    elseif target and not has_active_item then
        if target.components.mine then 
            action = ACTIONS.PICKUP     
        elseif target.components.trap and target.components.trap.issprung then 
            action = ACTIONS.CHECKTRAP
        elseif target.components.inventoryitem and target.components.inventoryitem.canbepickedup then 
            action = ACTIONS.PICKUP
        elseif target.components.pickable and target.components.pickable:CanBePicked() then 
            action = ACTIONS.PICK 
        elseif target.components.workable and target.components.workable.action == ACTIONS.CHOP then
            action = ACTIONS.CHOP 
        elseif target.components.harvestable and target.components.harvestable:CanBeHarvested() then
            action = ACTIONS.HARVEST
        elseif target.components.crop and target.components.crop:IsReadyForHarvest() then
            action = ACTIONS.HARVEST
        elseif target.components.stewer and target.components.stewer.done then
            action = ACTIONS.HARVEST
        end     
    end

    if action then
        return BufferedAction(inst, target, action)
    end
    return 
end

local function CheckMines(inst)
    local target = FindEntity(inst, SEE_MINES_DIST, function(guy)
        return  guy.components.mine
    end)
    return target
end


local function RemovalOfMines (inst)
    local target = FindEntity(inst, SEE_MINES_DIST, function(guy)
        return  guy.components.mine
    end)
    if target then 
        return BufferedAction(inst, target, ACTIONS.PICKUP) 
    else
    end
end 


local function GetFaceTargetFn(inst)
    local target = GetClosestInstWithTag("player", inst, START_FACE_DIST)
    if target and not target:HasTag("notarget") then
        return target
    end
end

local function KeepFaceTargetFn(inst, target)
    return inst:GetDistanceSqToInst(target) <= KEEP_FACE_DIST*KEEP_FACE_DIST and not target:HasTag("notarget")
end

local function ShouldGoHome(inst)
    local home = inst.components.homeseeker and inst.components.homeseeker.home
    local has_active_item = inst.components.inventory:GetActiveItem() ~= nil
    return (home and has_active_item) --or inst.components.health:GetPercent()<0.1
end

local function TracePlayer(inst)
    local playerPos =inst.components.knownlocations:GetLocation("playertrack")
    local myPos = Vector3(inst.Transform:GetWorldPosition())

    if playerPos and distsq(playerPos, myPos)<TRACE_PLAYER_DIST*TRACE_PLAYER_DIST then
        inst.components.knownlocations:RememberLocation("playertrack",nil)
    else
        if  not playerPos then
            local player=GetPlayer()
            playerPos = Vector3(player.Transform:GetWorldPosition())
            inst.components.knownlocations:RememberLocation("playertrack",playerPos)
        end
        return true
    end
    return false
end

local function GoToPlayer(inst)
    local playerPos = inst.components.knownlocations:GetLocation("playertrack")
    if playerPos then
        return BufferedAction(inst, nil, ACTIONS.WALKTO, nil, playerPos)
    end
end

local PigGuardBrain = Class(Brain, function(self, inst)
    Brain._ctor(self, inst)
end)

local function ShouldRunAway(inst)
    if inst.components.health:GetPercent()<0.5 and inst.components.combat.lastattacker == GetPlayer() then
        return true
    end
    
end


function PigGuardBrain:OnStart()
    local root = PriorityNode(
    {
        WhileNode( function() return self.inst.components.health.takingfiredamage end, "OnFire", Panic(self.inst)),
        AttackWall(self.inst),
        ChattyNode(self.inst, "check mine",WhileNode(function() return CheckMines(self.inst) end, "CheckMines",DoAction(self.inst, RemovalOfMines,"RemovalOfMines",true) ) ),        
        WhileNode(function() return ShouldGoHome(self.inst) end, "ShouldGoHome",
            ChattyNode(self.inst, STRINGS.PIG_GUARD_TALK_GOHOME,
                DoAction(self.inst, GoHomeAction, "Go Home", true ) ) ),        
        WhileNode(function () return ShouldRunAway(self.inst) end,"RunAwayPlayer",
            ChattyNode(self.inst, STRINGS.PIG_TALK_RUNAWAY_WILSON,
                RunAway(self.inst, "player", START_RUN_DIST, STOP_RUN_DIST))),
        ChattyNode(self.inst, STRINGS.PIG_GUARD_TALK_FIGHT,
            WhileNode( function() return self.inst.components.combat.target == nil or not self.inst.components.combat:InCooldown() end, "AttackMomentarily",
                ChaseAndAttack(self.inst, MAX_CHASE_TIME, MAX_CHASE_DIST) ) ),
        ChattyNode(self.inst, STRINGS.PIG_GUARD_TALK_FIGHT,
            WhileNode( function() return self.inst.components.combat.target and self.inst.components.combat:InCooldown() end, "Dodge",
                RunAway(self.inst, function() return self.inst.components.combat.target end, RUN_AWAY_DIST, STOP_RUN_AWAY_DIST) ) ),
        ChattyNode(self.inst, "find itme",DoAction(self.inst, FindItemAction )),
        WhileNode(function() return TracePlayer(self.inst) end,"TracePlayer",
            ChattyNode(self.inst, "TracePlayer" ,
                DoAction(self.inst , GoToPlayer ,"GoToPlayer",true))),
        ChattyNode(self.inst, STRINGS.PIG_GUARD_TALK_LOOKATWILSON,
            FaceEntity(self.inst, GetFaceTargetFn, KeepFaceTargetFn) ),
        Wander(self.inst, function() return self.inst.components.knownlocations:GetLocation("home") end, MAX_WANDER_DIST)
    }, .25)
    
    self.bt = BT(self.inst, root)
    
end

return PigGuardBrain