;----------------------------------------------------------
; ߣҢ
; ļRing.inc
; 汾1.04
; ڣ2001.08.01
;----------------------------------------------------------


FRING	struc
	rng_len	dw	?
	rng_grain	dw	?
	rng_addr	dw	?
	rng_curptr	dw	?
	ends

CreateRing	MACRO	ring,grain,rim
		IFNB	<rim>
			err	'Syntax: CreateRing ring,grain'
		ENDIF
		IFB	<grain>
			err	'Syntax: CreateRing ring,grain'
		ENDIF
		LibCall	CreateRing,<ring>,<grain>
		ENDM

ClearRing	MACRO	ring,rim
		IFNB	<rim>
			err	'Syntax: ClearRing ring'
		ENDIF
		IFB	<ring>
			err	'Syntax: ClearRing ring'
		ENDIF
		LibCall	ClearRing,<ring>
		ENDM

rngMoveBy	MACRO	ring,step,rim
		IFNB	<rim>
			err	'Syntax: rngMoveBy ring,step'
		ENDIF
		IFB	<step>
			err	'Syntax: rngMoveBy ring,step'
		ENDIF
		LibCall	rngMoveBy,<ring>,<step>
		ENDM

rngInsertBefore	MACRO	ring,value,rim
			IFNB	<rim>
				err	'Syntax: rngInsertBefore ring,value'
			ENDIF
			IFB	<value>
				err	'Syntax: rngInsertBefore ring,value'
			ENDIF
			LibCall	rngInsertBefore,<ring>,<value>
			ENDM

rngInsertAfter	MACRO	ring,value,rim
			IFNB	<rim>
				err	'Syntax: rngInsertAfter ring,value'
			ENDIF
			IFB	<value>
				err	'Syntax: rngInsertAfter ring,value'
			ENDIF
			LibCall	rngInsertAfter,<ring>,<value>
			ENDM

rngDelete	MACRO	ring,rim
		IFNB	<rim>
			err	'Syntax: rngDelete ring'
		ENDIF
		IFB	<ring>
			err	'Syntax: rngDelete ring'
		ENDIF
		LibCall	rngDelete,<ring>
		ENDM
		
rngLength	MACRO	ring,rim
		IFNB	<rim>
			err	'Syntax: rngLength ring'
		ENDIF
		IFB	<ring>
			err	'Syntax: rngLength ring'
		ENDIF
		LibCall	rngLength,<ring>
		ENDM

rngGetValue	MACRO	ring,value,rim
		IFNB	<rim>
			err	'Syntax: rngGetValue ring,value'
		ENDIF
		IFB	<value>
			err	'Syntax: rngGetValue ring,value'
		ENDIF
		LibCall	rngGetValue,<ring>,<value>
		ENDM

rngSetValue	MACRO	ring,value,rim
		IFNB	<rim>
			err	'Syntax: rngSetValue ring,value'
		ENDIF
		IFB	<value>
			err	'Syntax: rngSetValue ring,value'
		ENDIF
		LibCall	rngSetValue,<ring>,<value>
		ENDM