;----------------------------------------------------------
; ߣҢ
; ļQueue.inc
; 汾1.04
; ڣ2001.08.01
;----------------------------------------------------------


FQUEUE	struc
		que_len	dw	?
		que_grain	dw	?
		que_head	dw	?
		que_tail	dw	?
		ends

CreateQueue	MACRO	queue,grain,rim
		IFNB	<rim>
			err	'Syntax: CreateQueue queue,grain'
		ENDIF
		IFB	<grain>
			err	'Syntax: CreateQueue queue,grain'
		ENDIF
		LibCall	CreateQueue,<queue>,<grain>
		ENDM

ClearQueue	MACRO	queue,rim
		IFNB	<rim>
			err	'Syntax: ClearQueue queue'
		ENDIF
		IFB	<queue>
			err	'Syntax: ClearQueue queue'
		ENDIF
		LibCall	ClearQueue,<queue>
		ENDM

EnQueue	MACRO	queue,value,rim
		IFNB	<rim>
			err	'Syntax: EnQueue queue,value'
		ENDIF
		IFB	<value>
			err	'Syntax: EnQueue queue,value'
		ENDIF
		LibCall	EnQueue,<queue>,<value>
		ENDM


DeQueue	MACRO	queue,value,rim
		IFNB	<rim>
			err	'Syntax: DeQueue queue,value'
		ENDIF
		IFB	<value>
			err	'Syntax: DeQueue queue,value'
		ENDIF
		LibCall	DeQueue,<queue>,<value>
		ENDM

QueueTop	MACRO	queue,value,rim
		IFNB	<rim>
			err	'Syntax: QueueTop queue,value'
		ENDIF
		IFB	<value>
			err	'Syntax: QueueTop queue,value'
		ENDIF
		LibCall	QueueTop,<queue>,<value>
		ENDM

QueueLength	MACRO	queue,rim
		IFNB	<rim>
			err	'Syntax: QueueLength queue'
		ENDIF
		IFB	<queue>
			err	'Syntax: QueueLength queue'
		ENDIF
		LibCall	QueueLength,<queue>
		ENDM