(setq _zro  1.0
      _zroa 1e-3
)
(defun #c_arc3p	(cp p1 p2 / a1 v)
  (setq	a1 (angle cp p1)
	v  (angle cp p2)
	v  (if (< v a1)
	     (+ v pi pi)
	     v
	   )
	v  (/ (+ a1 v) 2)
	v  (polar cp v (distance cp p1))
  )
  (list p1 v p2)
)
(defun #arc_cp (cp p1 p2)
  (apply 'command (cons ".arc" (#c_arc3p cp p1 p2)))
)
(defun #ent_info (ee / wzq cp r)
  (getent ee)
  (setq	wzq (socas 0)
	cp  (socas 10)
  )
  (cond	((= wzq "LINE") (list cp (socas 11)))
	((= wzq "ARC")
	 (setq r (socas 40))
	 (list (polar cp (socas 50) r) (polar cp (socas 51) r) cp r)
	)
	((= wzq "3DFACE")
	 (list cp (socas 11) (socas 12) (socas 13))
	)
  )
)
(defun #x_lc (p1 p2 p0 r1 / a)
  (setq	a  (angle p1 p2)
	p1 (polar p1 a -1e4)
	p2 (polar p2 a 1e4)
  )
  (lxa p1 p2 p0 r1)
)
(defun #arc_mid	(arc_info p1 p2 / ps pe cp r)
  (mapcar 'set '(ps pe cp r) arc_info)
  (setq	ps (angle cp ps)
	p1 (#ang_ref (angle cp p1) ps)
	p2 (#ang_ref (angle cp p2) ps)
  )
  (polar cp (/ (+ p1 p2) 2) r)
)
(defun #arc_clock (arc_info p1 p2 / ps pe cp r)
  (mapcar 'set '(ps pe cp r) arc_info)
  (setq	ps (angle cp ps)
	p1 (#ang_ref (angle cp p1) ps)
	p2 (#ang_ref (angle cp p2) ps)
  )
  (> p2 p1)
)
(defun #arc3p_pl (ps pm pe) (apply 'atop (arcp0 ps pm pe)))
(defun #arcpl_3p (ps x pe / cp r a1 a2)
  (mapcar 'set '(x cp r a1 a2) (ptoa ps x pe))
  (setq	a2 (#ang_ref a2 a1)
	x  (polar cp (* 0.5 (+ a1 a2)) r)
  )
  (list ps x pe)
)
(defun #comm_pt	(lt / al pb pt lt1)
  (if (not (numberp (caar lt)))
    (setq pb (getvar "LASTPOINT"))
  )
  (while lt
    (setq al  (car lt)
	  lt  (cdr lt)
	  pt  (cond
		((= "@" (car al)) (setq pb (mapcar '+ pb (cdr al))))
		((= "<" (car al)) (setq pb (polar pb (cadr al) (caddr al))))
		((numberp (car al)) (setq pb al))
		(T nil)
	      )
	  lt1 (cons (if	pt
		      pt
		      al
		    )
		    lt1
	      )
    )
  )
  (reverse lt1)
)
(defun #subone (lt cmp)
  (while (and lt (not (cmp (car lt)))) (setq lt (cdr lt)))
  (car lt)
)
(defun #subset (lt cmp / _sublt)
  (foreach x lt
    (if	(cmp x)
      (setq _sublt (cons x _sublt))
    )
  )
  _sublt
)
(defun #sub2set	(lt cmp / _sublt1 _sublt2)
  (foreach x lt
    (if	(cmp x)
      (setq _sublt1 (cons x _sublt1))
      (setq _sublt2 (cons x _sublt2))
    )
  )
  (list _sublt1 _sublt2)
)
(defun #substrto (str c / i temp str1)
  (setq	i 0
	str1 ""
  )
  (while (and (/= (setq temp (substr str (setq i (1+ i)) 1)) "")
	      (/= temp c)
	 )
    (setq str1 (strcat str1 temp))
  )
  str1
)
(defun #ang_ref	(aa a0)
  (cond	((equal aa a0 _zroa) a0)
	((< aa a0) (+ aa pi pi))
	(T aa)
  )
)
(defun #sel (sb se / st)
  (setq	st (ssadd)
	sb (if (not sb)
	     (entnext)
	     (entnext sb)
	   )
  )
  (while (and sb (not (eq sb se)))
    (setq st (ssadd sb st)
	  sb (entnext sb)
    )
  )
  (if sb
    (ssadd se st)
  )
)
(defun #ssand (ss1 ss2 / i e1 ss)
  (if (and ss1 ss2)
    (progn (setq ss (ssadd))
	   (setq i 0)
	   (while (setq e1 (ssname ss1 i))
	     (if (ssmemb e1 ss2)
	       (ssadd e1 ss)
	     )
	     (setq i (1+ i))
	   )
	   (if (> (sslength ss) 0)
	     ss
	   )
    )
  )
)
(defun #p_3d (pb vec r / x)
  (if (not (caddr pb))
    (setq pb (list (car pb) (cadr pb) 0))
  )
  (mapcar '+ pb (mapcar '(lambda (x) (* r x)) vec))
)
(defun #p_ratio	(pp p1 p2 / wzq x1 x2 x)
  (setq	wzq (if	(equal (car p1) (car p2) _zroa)
	      'cadr
	      'car
	    )
  )
  (mapcar 'set '(x1 x2 x) (mapcar wzq (list p1 p2 pp)))
  (/ (- x x1) (- x2 x1))
)
(defun #eq_a (a1 a2)
  (equal (polar '(0 0 0) a1 10) (polar '(0 0 0) a2 10) 1e-3)
)
(defun #arc_ratio (pp info / ps pe cp r)
  (mapcar 'set '(ps pe cp r) info)
  (setq	ps (angle cp ps)
	pe (#ang_ref (angle cp pe) ps)
	pp (#ang_ref (angle cp pp) ps)
  )
  (/ (- pp ps) (- pe ps))
)
(defun #min_max	(lt / x i dmin dmax n1 n2)
  (setq	i    0
	dmin 1.0e6
	dmax -1.0e6
  )
  (foreach x lt
    (if	(< x dmin)
      (setq dmin x
	    n1 i
      )
    )
    (if	(> x dmax)
      (setq dmax x
	    n2 i
      )
    )
    (setq i (1+ i))
  )
  (list n1 n2)
)
(defun #near_pt	(pl pt dmin / x a p1)
  (if (not dmin)
    (setq dmin 1.0e6)
  )
  (foreach x pl
    (setq a (distance x pt))
    (if	(< a dmin)
      (setq p1 x
	    dmin a
      )
    )
  )
  p1
)
(defun #a_list (e1)
  (if (not (listp e1))
    (progn (getent e1)
	   (setq cp (socas 10)
		 r  (socas 40)
		 a1 (socas 50)
		 a2 (socas 51)
	   )
	   (if a2
	     (setq a2 (#ang_ref a2 a1))
	   )
    )
    (progn (mapcar 'set '(a1 a2 cp r) e1)
	   (if (and a1 (listp a1))
	     (setq a1 (angle cp a1)
		   a2 (#ang_ref (angle cp a2) a1)
	     )
	   )
    )
  )
  (if (not a1)
    (setq a1 0
	  a2 (+ pi pi)
    )
  )
  (list a1 a2 cp r)
)
(defun #arc_num	(e1 / cp r a1 a2 aa n)
  (#a_list e1)
  (setq	aa	 (/ pi 6)
	div_accu (if (and (numberp div_accu) (> div_accu _zro))
		   div_accu
		   50.0
		 )
  )
  (if (> r (* 1.2 div_accu))
    (setq r  (/ r (- r div_accu))
	  aa (min aa (atan (sqrt (1- (* r r))) 1))
    )
  )
  (setq	n (fix (+ 0.5 (/ (- a2 a1) aa)))
	n (if (< n 2)
	    2
	    n
	  )
  )
)
(defun #poly_inarc (e1 n / ps pe cp r a1 a2 aa n plt)
  (setq e1 (#a_list e1))
  (if (not n)
    (setq n (#arc_num e1))
  )
  (setq	aa  (/ (- a2 a1) n)
	ps  (polar cp a1 r)
	pe  (polar cp a2 r)
	plt (list ps)
  )
  (repeat (1- n)
    (setq a1  (+ a1 aa)
	  ps  (polar cp a1 r)
	  plt (cons ps plt)
    )
  )
  (reverse (cons pe plt))
)
(defun #div_poly (ep / elt cp r z info lt tftp)
  (if (listp ep)
    (setq elt ep)
    (progn (getent ep)
	   (setq tftp (= (socas 0) "POLYLINE")
		 z    (socas 38)
		 info (logand (socas 70) 1)
	   )
	   (while (setq	cp (if tftp
			     (nextent)
			     (soclw0 10)
			   )
		  )
	     (setq elt (cons (if tftp
			       cp
			       (list (car cp) (cadr cp) z)
			     )
			     elt
		       )
		   elt (cons (socas 42) elt) ;revised by dongyi soclw
	     )
	   )
	   (if (= info 1)
	     (setq elt (cons (last elt) elt))
	   )
	   (setq elt (reverse elt))
    )
  )
  (if elt
    (setq lt (list (car elt)))
  )
  (while (cddr elt)
    (if	(= (cadr elt) 0)
      (setq lt (append lt (list (caddr elt))))
      (progn (setq info	(ptoa (car elt) (cadr elt) (caddr elt))
		   tf	(car info)
		   cp	(cadr info)
		   r	(caddr info)
		   info	(list (polar cp (nth 3 info) r)
			      (polar cp (nth 4 info) r)
			      cp
			      r
			)
		   info	(#poly_inarc info nil)
		   info	(if tf
			  info
			  (reverse info)
			)
		   lt	(append lt (cdr info))
	     )
      )
    )
    (setq elt (cddr elt))
  )
  lt
)
(defun #inv_poly (plt / lt df ps tf wzq)
  (while plt
    (setq ps (car plt)
	  lt (cons ps lt)
    )
    (if	(= (caadr plt) "A")
      (setq df	(cadr (apply 'atop (arcp0 ps (cadadr plt) (caddr plt))))
	    plt	(cdr plt)
      )
      (setq df 0)
    )
    (setq plt (cdr plt))
    (if	plt
      (setq lt (cons df lt))
    )
  )
  lt
)
(defun #x_x (info1 info2 / cp1 cp2)
  (cond	((and (cddr info1) (cddr info2))
	 (setq cp1 (caddr info1)
	       cp2 (caddr info2)
	 )
	 (axa cp1 (nth 3 info1) cp2 (nth 3 info2))
	)
	((and (cddr info2) (not (cddr info1)))
	 (setq cp2 (caddr info2))
	 (#x_lc (car info1) (cadr info1) cp2 (nth 3 info2))
	)
	((and (cddr info1) (not (cddr info2)))
	 (setq cp1 (caddr info1))
	 (#x_lc (car info2) (cadr info2) cp1 (nth 3 info1))
	)
	((not (or (cddr info2) (cddr info1)))
	 (setq cp1 (inters (car info1)
			   (cadr info1)
			   (car info2)
			   (cadr info2)
			   nil
		   )
	 )
	 (if cp1
	   (list cp1)
	 )
	)
  )
)
(defun #offset (plt wlt	/ p1 x w p2 pm aa a1 a2	cp r pt1 pt2 info tf
		tf_cw ipt elt prev)
  (setq	p1  (car plt)
	plt (cdr plt)
  )
  (if (equal p1 (last plt) 1e-5)
    (setq tf  T
	  plt (append plt (list (car plt) (cadr plt)))
    )
  )
  (while (setq x  (car plt)
	       p2 (cadr plt)
	 )
    (if	wlt
      (setq w	(car wlt)
	    wlt	(cdr wlt)
      )
    )
    (if	(= x 0)
      (setq aa	 (angle p1 p2)
	    a1	 (- aa _pi2)
	    pt1	 (polar p1 a1 w)
	    pt2	 (polar p2 a1 w)
	    info (list pt1 pt2)
      )
      (progn (setq info (ptoa p1 x p2))
	     (mapcar 'set '(tf_cw cp r a1 a2) info)
	     (setq r	(if tf_cw
			  (+ r w)
			  (- r w)
			)
		   pt1	(polar cp a1 r)
		   pt2	(polar cp a2 r)
		   info	(list pt1 pt2 cp r)
	     )
      )
    )
    (if	elt
      (setq ipt (#near_pt (#x_x info prev) (car elt) nil))
      (setq ipt	(if (cddr info)
		  (if tf_cw
		    pt1
		    pt2
		  )
		  pt1
		)
      )
    )
    (if	(not ipt)
      (setq ipt	(if (cddr info)
		  (if tf_cw
		    pt1
		    pt2
		  )
		  pt1
		)
      )
    )
    (if	(cddr info)
      (setq prev (if tf_cw
		   (list ipt pt2 cp r)
		   (list pt1 ipt cp r)
		 )
	    pm	 (#arc_mid prev (car prev) (cadr prev))
	    info (list ipt
		       (list "A" pm)
		       (if tf_cw
			 pt2
			 pt1
		       )
		 )
      )
      (setq prev (list ipt pt2)
	    info prev
      )
    )
    (setq elt (append (reverse info) (cdr elt)))
    (setq plt (cddr plt)
	  p1  p2
    )
  )
  (if tf
    (cons (cadr elt) (cdr (reverse (cdr elt))))
    (reverse elt)
  )
)
(defun #in_line	(p1 p2 p3 tf / a b c)
  (setq	a (distance p1 p2)
	b (distance p2 p3)
	c (distance p1 p3)
  )
  (or (equal (+ a b) c 1e-4)
      (and (not tf) (equal (abs (- a b)) c 1e-4))
  )
)
(defun #p_merge	(lt / p1 p2 p3 a b c ltnew)
  (setq	p1 (car lt)
	p2 (cadr lt)
	lt (cddr lt)
  )
  (if p1
    (setq ltnew (list p1))
  )
  (while (setq p3 (car lt))
    (if	(#in_line p1 p2 p3 nil)
      (setq p2 p3)
      (setq ltnew (cons p2 ltnew)
	    p1	  p2
	    p2	  p3
      )
    )
    (setq lt (cdr lt))
  )
  (if p2
    (setq ltnew (cons p2 ltnew))
  )
  (setq p2 (car ltnew))
  (if (equal p2 (last ltnew) _zro)
    (progn (setq ltnew (cdr ltnew)
		 p3    (car ltnew)
		 ltnew (reverse ltnew)
		 p1    (cadr ltnew)
		 ltnew (cons (last ltnew)
			     (if (and p1 (#in_line p1 p2 p3 nil))
			       (cdr ltnew)
			       ltnew
			     )
		       )
	   )
    )
    (reverse ltnew)
  )
)
(defun #join_segs (lt / i j n lti ltj a1 a2 b1 b2 wzq)
  (setq i -1)
  (while (setq lti (nth (setq i (1+ i)) lt))
    (setq a1  (car lti)
	  a2  (last lti)
	  j   i
	  wzq nil
    )
    (if	(not (equal a1 a2 _zro))
      (while (and (not wzq) (setq ltj (nth (setq j (1+ j)) lt)))
	(setq b1  (car ltj)
	      b2  (last ltj)
	      wzq (cond
		    ((equal a1 b1 _zro) (append (reverse lti) (cdr ltj)))
		    ((equal a1 b2 _zro) (append ltj (cdr lti)))
		    ((equal a2 b1 _zro) (append lti (cdr ltj)))
		    ((equal a2 b2 _zro) (append ltj (cdr (reverse lti))))
		  )
	)
      )
    )
    (if	wzq
      (setq lt (subst nil lti lt)
	    lt (subst wzq ltj lt)
      )
    )
  )
  (setq lti nil)
  (foreach x lt
    (if	x
      (setq lti (cons x lti))
    )
  )
  lti
)
(defun #mkface (plt vec1 zf / plt1 x)
  (if (> (abs zf) 1e-4)
    (progn (setq vec1 (mapcar '(lambda (x) (* zf x)) vec1)
		 plt1 (mapcar '(lambda (x) (mapcar '+ x vec1)) plt)
	   )
	   (while (cadr plt)
	     (if (not (equal (car plt) (cadr plt) _zro))
	       (command	".3dface"
			(car plt)
			(cadr plt)
			(cadr plt1)
			(car plt1)
			""
	       )
	     )
	     (setq plt	(cdr plt)
		   plt1	(cdr plt1)
	     )
	   )
    )
  )
)
(defun #selpt (pt filter / ll ur ss e1 p1 h1)
  (setq	h1 (/ (getvar "viewsize") 100)
	p1 (trans pt 0 2)
	ll (trans (polar P1 (/ (* pi 5) 4) h1) 2 0)
	ur (trans (polar P1 (/ pi 4) h1) 2 0)
  )
  (if filter
    (ssget "c" ll ur filter)
    (ssget "c" ll ur)
  )
)
(defun #svlay (lay / ss wzq)
  (if (setq ss (ssget "X" (list (cons 8 lay))))
    (progn (getss ss 1)
	   (while (namess 1)
	     (setq wzq (socas 8))
	     (modent 8 "TA_ATTR")
	     (xdin "LAYER" wzq)
	   )
	   (command ".LAYER" "F" "TA_ATTR" "")
    )
  )
)
(defun #rslay (/ ss wzq)
  (if (setq ss (ssget "X" (list '(8 . "TA_ATTR") '(-3 ("LAYER")))))
    (progn (getss ss 1)
	   (while (namess 1)
	     (setq wzq (car (xdout "LAYER")))
	     (modent 8 wzq)
	     (xdin "LAYER")
	   )
    )
  )
)
(defun #get_layer (str / e1 la)
  (setq	e1 (entsel (strcat str "ȡָͼ <س>: "))
	la (if e1
	     (cdr (assoc 8 (entget (car e1))))
	     (getstring "\nͼ <ǰ>: ")
	   )
  )
  (if (and la (/= la ""))
    la
    (getvar "clayer")
  )
)
