(_@ld "vptool")
(defun _getvpnum (/ vplt x lt)
  (if (= (getvar "tilemode") 0)
    (progn (setq vplt (vports))
	   (foreach x vplt
	     (if (/= (car x) 1)
	       (setq lt (cons (car x) lt))
	     )
	   )
	   (setq lt   (apply 'sortd lt)
		 vplt nil
	   )
	   (foreach x lt (setq vplt (append vplt (list (fix x)))))
    )
  )
)
(defun c:3d_init (/ ss lt v3 tf wzq)
  (setvar "tilemode" 0)
  (if (and (setq ss (ssget "X" '((0 . "VIEWPORT"))))
	   (> (sslength ss) 1)
      )
    (command ".pspace" ".erase" ss "")
  )
  (if (< (length (setq view_lt (vports))) 4)
    (progn (command ".layer" "t" "0" "s" "0" "")
	   (command ".mview" 3 "" "F")
	   (setq view_lt (vports))
    )
    (setq tf T)
  )
  (setq view_lt (_getvpnum))
  (command ".mspace")
  (if (not tf)
    (progn (command ".layer" "T" "~defpoints" "")
	   (setvar "cvport" (car view_lt))
	   (command ".vpoint" '(0 0 1))
    )
  )
  (setvar "cvport" (cadr view_lt))
  (if (tbl_test "layer" (setq v3 (glayer "ʱ*")))
    (command ".vplayer"
	     "F"
	     (glayer "~*")
	     ""
	     "F"
	     v3
	     "All"
	     "T"
	     v3
	     ""
	     ""
    )
    (command ".vplayer" "F" (glayer "~*") "" "")
  )
  (if (not tf)
    (command ".vpoint" '(1 -1 1))
  )
  (setvar "cvport" (caddr view_lt))
  (if (tbl_test "layer" (setq v3 (glayer "ά*")))
    (command ".vplayer"
	     "F"
	     (glayer "~*")
	     ""
	     "F"
	     v3
	     "All"
	     "T"
	     v3
	     ""
    )
    (command ".vplayer" "F" (glayer "~*") "")
  )
  (command "T" "0" "" "")
  (if (not tf)
    (command ".vpoint" '(1 -1 1))
  )
  (princ)
)
(defun c:enlgvp	(/ a b c c1 c2 c0)
  (if (= (getvar "tilemode") 0)
    (progn (setq a  (getvar "cvport")
		 b  (vports)
		 c  (cdr (assoc a b))
		 c1 (car c)
		 c2 (cadr c)
		 c0 (abs (- (car c1) (car c2)))
	   )
	   (command ".PSPACE")
	   (setq c  (mapcar '- (getvar "vsmax") (getvar "vsmin"))
		 c2 (mapcar '+ c1 (list c0 (* (cadr c) (/ c0 (car c)))))
	   )
	   (command ".ZOOM" "_W" c1 c2 ".MSPACE")
    )
  )
  (princ)
)
(defun c:mk3vp (/ n tf tmode v3)
  (setq	tmode (getvar "tilemode")
	n     1
  )
  (setvar "tilemode" 0)
  (command ".PSPACE"
	   ".ZOOM"
	   "_W"
	   (getvar "extmin")
	   (getvar "extmax")
	   ".MSPACE"
  )
  (if (< (length (vports)) 4)
    (progn (initget "Yes No")
	   (setq tf (getkword "\nӴ, (Yes/No)? <No>: "))
	   (if (= tf "Yes")
	     (c:3d_init)
	     (setvar "tilemode" tmode)
	   )
    )
  )
  (princ)
)
(defun set_vport (n / i)
  (if n
    (progn
      (if (< (length (vports)) 3)
	(if (= (getvar "tilemode") 0)
	  (command ".PSPACE" ".ZOOM" "_E" ".MSPACE")
	)
      )
      (if (< (length (vports)) 3)
	(progn (setq i (- (length view_lt) (length (member n view_lt))))
	       (c:3d_init)
	       (setq n (nth i view_lt))
	)
      )
      (setvar "cvport" n)
      T
    )
  )
)
(defun c:3dpurge (/ ss ss1 lt lay wzq)
  (begin)
  (if (and (> (length (vports)) 3) (not view_lt))
    (c:3d_init)
  )
  (if (set_vport (caddr view_lt))
    (progn
      (initget "Yes No")
      (setq wzq
	     (getkword
	       "\nɾӴֻӴпɼ(Yes/No)? <Yes>: "
	     )
      )
      (if (/= wzq "No")
	(progn (setq ss
		      (ssget "X"
			     (list '(0 . "VIEWPORT") (cons 69 (caddr view_lt)))
		      )
	       )
	       (if ss
		 (progn	(setq lt (entget (ssname ss 0) '("*"))
			      lt (cdr (assoc "ACAD" (cdr (assoc -3 lt))))
			)
			(foreach x lt
			  (if (= (car x) 1003)
			    (setq lay (cons (cdr x) lay))
			  )
			)
			(if (cdr lay)
			  (setq	wzq (car lay)
				lay (mapcar '(lambda (x) (strcat "," x)) (cdr lay))
				lay (apply 'strcat (cons wzq lay))
				ss  (ssget "x" (list (cons 8 lay)))
			  )
			)
		 )
	       )
	)
      )
      (command ".VIEW" "S" "_tchtmp" ".PSPACE")
      (setvar "highlight" 0)
      (setq ss1 (ssget "x" '((0 . "viewport"))))
      (if ss1
	(command ".erase" ss1 "")
      )
      (command ".layer"	       "T"     "*"     "on"    "*"     ""
	       ".vplayer"      "V"     "*"     "T"     "T"     "*"
	       "All"   ""
	      )
      (command ".MSPACE")
      (setvar "tilemode" 1)
      (if ss
	(command ".erase" ss "")
      )
      (setq ss1	(ssget "x" (list '(2 . "_pstn")))
	    wzq	(eval win_init)
      )
      (if ss1
	(command ".erase" ss1 "")
      )
      (setvar "highlight" 1)
      (command ".VIEW" "R" "_tchtmp")
      (command ".UCS" "")
      (setq view_lt nil)
      (initget "Yes No")
      (princ
	"\nͼȷ.ɽһδ, 󽫲'U'."
      )
      (if (= (setq wzq (getkword "\n(Yes/No)? <No>: ")) "Yes")
	(progn (_@ld "cladwg") (c:cladwg))
      )
    )
  )
  (end)
)